/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.graalvm.compiler.processor.AbstractProcessor;
import org.graalvm.compiler.replacements.processor.AnnotationHandler;
import org.graalvm.compiler.replacements.processor.GeneratedNodeIntrinsicPlugin;
import org.graalvm.compiler.replacements.processor.PluginGenerator;

public final class NodeIntrinsicHandler
extends AnnotationHandler {
    static final String CONSTANT_NODE_PARAMETER_CLASS_NAME = "org.graalvm.compiler.graph.Node.ConstantNodeParameter";
    static final String MARKER_TYPE_CLASS_NAME = "org.graalvm.compiler.nodeinfo.StructuralInput.MarkerType";
    static final String GRAPH_BUILDER_CONTEXT_CLASS_NAME = "org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext";
    static final String STRUCTURAL_INPUT_CLASS_NAME = "org.graalvm.compiler.nodeinfo.StructuralInput";
    static final String RESOLVED_JAVA_METHOD_CLASS_NAME = "jdk.vm.ci.meta.ResolvedJavaMethod";
    static final String RESOLVED_JAVA_TYPE_CLASS_NAME = "jdk.vm.ci.meta.ResolvedJavaType";
    static final String VALUE_NODE_CLASS_NAME = "org.graalvm.compiler.nodes.ValueNode";
    static final String STAMP_CLASS_NAME = "org.graalvm.compiler.core.common.type.Stamp";
    static final String NODE_CLASS_NAME = "org.graalvm.compiler.graph.Node";
    static final String NODE_INFO_CLASS_NAME = "org.graalvm.compiler.nodeinfo.NodeInfo";
    static final String NODE_INTRINSIC_CLASS_NAME = "org.graalvm.compiler.graph.Node.NodeIntrinsic";
    static final String INJECTED_NODE_PARAMETER_CLASS_NAME = "org.graalvm.compiler.graph.Node.InjectedNodeParameter";

    public NodeIntrinsicHandler(AbstractProcessor processor) {
        super(processor, NODE_INTRINSIC_CLASS_NAME);
    }

    @Override
    public void process(Element element, AnnotationMirror annotation, PluginGenerator generator) {
        TypeMirror returnType;
        if (element.getKind() != ElementKind.METHOD) {
            assert (false) : "Element is guaranteed to be a method.";
            return;
        }
        ExecutableElement intrinsicMethod = (ExecutableElement)element;
        Messager messager = this.processor.env().getMessager();
        if (!intrinsicMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("A @%s method must be static.", AbstractProcessor.getSimpleName((String)NODE_INTRINSIC_CLASS_NAME)), element, annotation);
        }
        if (!intrinsicMethod.getModifiers().contains((Object)Modifier.NATIVE)) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("A @%s method must be native.", AbstractProcessor.getSimpleName((String)NODE_INTRINSIC_CLASS_NAME)), element, annotation);
        }
        TypeMirror nodeClassMirror = (TypeMirror)AbstractProcessor.getAnnotationValue((AnnotationMirror)annotation, (String)"value", TypeMirror.class);
        TypeElement nodeClass = this.processor.asTypeElement(nodeClassMirror);
        if (this.processor.env().getTypeUtils().isSameType(nodeClassMirror, annotation.getAnnotationType())) {
            Element enclosingElement;
            for (enclosingElement = intrinsicMethod.getEnclosingElement(); enclosingElement != null && enclosingElement.getKind() != ElementKind.CLASS; enclosingElement = enclosingElement.getEnclosingElement()) {
            }
            if (enclosingElement != null) {
                nodeClass = (TypeElement)enclosingElement;
            } else {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("Cannot find a class enclosing @%s method.", AbstractProcessor.getSimpleName((String)NODE_INTRINSIC_CLASS_NAME)), element, annotation);
            }
        }
        if ((returnType = intrinsicMethod.getReturnType()) instanceof TypeVariable) {
            messager.printMessage(Diagnostic.Kind.ERROR, "@NodeIntrinsic cannot have a generic return type.", element, annotation);
        }
        boolean injectedStampIsNonNull = (Boolean)AbstractProcessor.getAnnotationValue((AnnotationMirror)annotation, (String)"injectedStampIsNonNull", Boolean.class);
        if (returnType.getKind() == TypeKind.VOID) {
            for (VariableElement variableElement : intrinsicMethod.getParameters()) {
                if (this.processor.getAnnotation((Element)variableElement, this.processor.getType(INJECTED_NODE_PARAMETER_CLASS_NAME)) == null) continue;
                messager.printMessage(Diagnostic.Kind.ERROR, "@NodeIntrinsic with an injected Stamp parameter cannot have a void return type.", element, annotation);
                break;
            }
        }
        TypeMirror[] constructorSignature = this.constructorSignature(intrinsicMethod);
        HashMap<ExecutableElement, String> hashMap = new HashMap<ExecutableElement, String>();
        List<ExecutableElement> factories = this.findIntrinsifyFactoryMethod(nodeClass, constructorSignature, hashMap, injectedStampIsNonNull);
        List<Object> constructors = Collections.emptyList();
        if (nodeClass.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            if (factories.isEmpty()) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("Cannot make a node intrinsic for abstract class %s.", nodeClass.getSimpleName()), element, annotation);
            }
        } else if (!this.isNodeType(nodeClass)) {
            if (factories.isEmpty()) {
                messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s is not a subclass of %s.", nodeClass.getSimpleName(), this.processor.getType(NODE_CLASS_NAME)), element, annotation);
            }
        } else {
            TypeMirror ret = returnType;
            if (this.processor.env().getTypeUtils().isAssignable(ret, this.processor.getType(STRUCTURAL_INPUT_CLASS_NAME))) {
                this.checkInputType(nodeClass, ret, element, annotation);
            }
            constructors = this.findConstructors(nodeClass, constructorSignature, hashMap, injectedStampIsNonNull);
        }
        Formatter msg = new Formatter();
        if (factories.size() > 1) {
            msg.format("Found more than one factory in %s matching node intrinsic:", nodeClass);
            for (ExecutableElement executableElement : factories) {
                msg.format("%n  %s", executableElement);
            }
            messager.printMessage(Diagnostic.Kind.ERROR, msg.toString(), intrinsicMethod, annotation);
        } else if (constructors.size() > 1) {
            msg.format("Found more than one constructor in %s matching node intrinsic:", nodeClass);
            for (ExecutableElement executableElement : constructors) {
                msg.format("%n  %s", executableElement);
            }
            messager.printMessage(Diagnostic.Kind.ERROR, msg.toString(), intrinsicMethod, annotation);
        } else if (factories.size() == 1) {
            generator.addPlugin(new GeneratedNodeIntrinsicPlugin.CustomFactoryPlugin(intrinsicMethod, factories.get(0), constructorSignature));
        } else if (constructors.size() == 1) {
            generator.addPlugin(new GeneratedNodeIntrinsicPlugin.ConstructorPlugin(intrinsicMethod, (ExecutableElement)constructors.get(0), constructorSignature));
        } else {
            msg.format("Could not find any factories or constructors in %s matching node intrinsic", nodeClass);
            if (!hashMap.isEmpty()) {
                msg.format("%nFactories and constructors that failed to match:", new Object[0]);
                for (Map.Entry entry : hashMap.entrySet()) {
                    msg.format("%n  %s: %s", entry.getKey(), entry.getValue());
                }
            }
            messager.printMessage(Diagnostic.Kind.ERROR, msg.toString(), intrinsicMethod, annotation);
        }
    }

    private void checkInputType(TypeElement nodeClass, TypeMirror returnType, Element element, AnnotationMirror annotation) {
        String inputType = this.getInputType(returnType, element, annotation);
        if (!inputType.equals("Value")) {
            boolean allowed = false;
            List allowedTypes = AbstractProcessor.getAnnotationValueList((AnnotationMirror)this.processor.getAnnotation((Element)nodeClass, this.processor.getType(NODE_INFO_CLASS_NAME)), (String)"allowedUsageTypes", VariableElement.class);
            for (VariableElement allowedType : allowedTypes) {
                if (!allowedType.getSimpleName().contentEquals(inputType)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                this.processor.env().getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("@NodeIntrinsic returns input type %s, but only %s is allowed.", inputType, allowedTypes), element, annotation);
            }
        }
    }

    private String getInputType(TypeMirror type, Element element, AnnotationMirror annotation) {
        TypeElement current = this.processor.asTypeElement(type);
        while (current != null) {
            AnnotationMirror markerType = this.processor.getAnnotation((Element)current, this.processor.getType(MARKER_TYPE_CLASS_NAME));
            if (markerType != null) {
                return ((VariableElement)AbstractProcessor.getAnnotationValue((AnnotationMirror)markerType, (String)"value", VariableElement.class)).getSimpleName().toString();
            }
            current = this.processor.asTypeElement(current.getSuperclass());
        }
        this.processor.env().getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("The class %s is a subclass of StructuralInput, but isn't annotated with @MarkerType. %s", type, element.getAnnotationMirrors()), element, annotation);
        return "Value";
    }

    private boolean isNodeType(TypeElement nodeClass) {
        return this.processor.env().getTypeUtils().isSubtype(nodeClass.asType(), this.processor.getType(NODE_CLASS_NAME));
    }

    private TypeMirror[] constructorSignature(ExecutableElement method) {
        TypeMirror[] parameters = new TypeMirror[method.getParameters().size()];
        for (int i = 0; i < method.getParameters().size(); ++i) {
            VariableElement parameter = method.getParameters().get(i);
            if (this.processor.getAnnotation((Element)parameter, this.processor.getType(CONSTANT_NODE_PARAMETER_CLASS_NAME)) == null) {
                parameters[i] = this.processor.getType(VALUE_NODE_CLASS_NAME);
                continue;
            }
            TypeMirror type = parameter.asType();
            if (this.isTypeCompatible(type, this.processor.getType("java.lang.Class"))) {
                type = this.processor.getType(RESOLVED_JAVA_TYPE_CLASS_NAME);
            }
            parameters[i] = type;
        }
        return parameters;
    }

    private List<ExecutableElement> findConstructors(TypeElement nodeClass, TypeMirror[] signature, Map<ExecutableElement, String> nonMatches, boolean requiresInjectedStamp) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(nodeClass.getEnclosedElements());
        ArrayList<ExecutableElement> found = new ArrayList<ExecutableElement>(constructors.size());
        for (ExecutableElement constructor : constructors) {
            if (!this.matchSignature(0, constructor, signature, nonMatches, requiresInjectedStamp)) continue;
            found.add(constructor);
        }
        return found;
    }

    private List<ExecutableElement> findIntrinsifyFactoryMethod(TypeElement nodeClass, TypeMirror[] signature, Map<ExecutableElement, String> nonMatches, boolean requiresInjectedStamp) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(nodeClass.getEnclosedElements());
        ArrayList<ExecutableElement> found = new ArrayList<ExecutableElement>(methods.size());
        for (ExecutableElement method : methods) {
            if (!method.getSimpleName().toString().equals("intrinsify")) continue;
            if (method.getParameters().size() < 2) {
                nonMatches.put(method, "Too few arguments");
                continue;
            }
            VariableElement firstArg = method.getParameters().get(0);
            if (!this.isTypeCompatible(firstArg.asType(), this.processor.getType(GRAPH_BUILDER_CONTEXT_CLASS_NAME))) {
                nonMatches.put(method, "First argument isn't of type GraphBuilderContext");
                continue;
            }
            VariableElement secondArg = method.getParameters().get(1);
            if (!this.isTypeCompatible(secondArg.asType(), this.processor.getType(RESOLVED_JAVA_METHOD_CLASS_NAME))) {
                nonMatches.put(method, "Second argument isn't of type ResolvedJavaMethod");
                continue;
            }
            if (method.getReturnType().getKind() != TypeKind.BOOLEAN) {
                nonMatches.put(method, "Doesn't return boolean");
                continue;
            }
            if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
                nonMatches.put(method, "Method is non-static");
                continue;
            }
            if (!this.matchSignature(2, method, signature, nonMatches, requiresInjectedStamp)) continue;
            found.add(method);
        }
        return found;
    }

    private boolean matchSignature(int numSkippedParameters, ExecutableElement method, TypeMirror[] signature, Map<ExecutableElement, String> nonMatches, boolean requiresInjectedStamp) {
        int sIdx = 0;
        int cIdx = numSkippedParameters;
        boolean missingStampArgument = requiresInjectedStamp;
        while (cIdx < method.getParameters().size()) {
            VariableElement parameter = method.getParameters().get(cIdx++);
            TypeMirror paramType = parameter.asType();
            if (this.processor.getAnnotation((Element)parameter, this.processor.getType(INJECTED_NODE_PARAMETER_CLASS_NAME)) != null) {
                if (!missingStampArgument || !this.processor.env().getTypeUtils().isSameType(paramType, this.processor.getType(STAMP_CLASS_NAME))) continue;
                missingStampArgument = false;
                continue;
            }
            if (missingStampArgument) {
                nonMatches.put(method, String.format("missing injected %s argument", this.processor.getType(STAMP_CLASS_NAME)));
                return false;
            }
            if (cIdx == method.getParameters().size() && paramType.getKind() == TypeKind.ARRAY) {
                TypeMirror varargsType = ((ArrayType)paramType).getComponentType();
                while (sIdx < signature.length) {
                    if (this.isTypeCompatible(varargsType, signature[sIdx++])) continue;
                    nonMatches.put(method, String.format("the types of argument %d are incompatible: %s != %s", sIdx, varargsType, signature[sIdx - 1]));
                    return false;
                }
                continue;
            }
            if (sIdx >= signature.length) {
                nonMatches.put(method, "too many arguments");
                return false;
            }
            if (this.isTypeCompatible(paramType, signature[sIdx++])) continue;
            nonMatches.put(method, String.format("the type of argument %d is incompatible: %s != %s", sIdx, paramType, signature[sIdx - 1]));
            return false;
        }
        if (missingStampArgument) {
            nonMatches.put(method, String.format("missing injected %s argument", this.processor.getType(STAMP_CLASS_NAME)));
            return false;
        }
        if (sIdx != signature.length) {
            nonMatches.put(method, "not enough arguments");
            return false;
        }
        return true;
    }

    private boolean isTypeCompatible(TypeMirror originalType, TypeMirror substitutionType) {
        TypeMirror original = originalType;
        TypeMirror substitution = substitutionType;
        if (NodeIntrinsicHandler.needsErasure(original)) {
            original = this.processor.env().getTypeUtils().erasure(original);
        }
        if (NodeIntrinsicHandler.needsErasure(substitution)) {
            substitution = this.processor.env().getTypeUtils().erasure(substitution);
        }
        return this.processor.env().getTypeUtils().isSameType(original, substitution);
    }

    private static boolean needsErasure(TypeMirror typeMirror) {
        return typeMirror.getKind() != TypeKind.NONE && typeMirror.getKind() != TypeKind.VOID && !typeMirror.getKind().isPrimitive() && typeMirror.getKind() != TypeKind.OTHER && typeMirror.getKind() != TypeKind.NULL;
    }
}

