/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class RubyDetailsProvider
extends DetailsProvider.Basic {
    private static final String RUBY_OBJECT_TYPE_MASK = "org.truffleruby.language.RubyObjectType+";
    private static final String ASCII_ROPE_MASK = "org.truffleruby.core.rope.AsciiOnlyLeafRope";
    private static final String CONCAT_ROPE_MASK = "org.truffleruby.core.rope.ConcatRope";
    private static final String SUB_ROPE_MASK = "org.truffleruby.core.rope.SubstringRope";
    private static final String INVALID_ROPE_MASK = "org.truffleruby.core.rope.InvalidLeafRope";
    private static final String VALID_ROPE_MASK = "org.truffleruby.core.rope.ValidLeafRope";
    private static final String INT_ROPE_MASK = "org.truffleruby.core.rope.LazyIntRope";
    private static final String ROPE_TABLE_KEY_MASK = "org.truffleruby.core.rope.RopeTable$Key";
    private static final String ENCODING_MASK = "org.jcodings.Encoding+";
    private static final String MODULE_FIELDS_MASK = "org.truffleruby.core.module.ModuleFields";
    private static final String BASIC_LAYOUT_MASK = "org.truffleruby.core.basicobject.BasicObjectLayoutImpl$BasicObjectType+";
    private static final String METHOD_INFO_MASK = "org.truffleruby.language.methods.SharedMethodInfo";
    private static final String RUBY_ROOT_NODE_MASK = "org.truffleruby.language.RubyRootNode";

    public RubyDetailsProvider() {
        super(new String[]{RUBY_OBJECT_TYPE_MASK, ASCII_ROPE_MASK, CONCAT_ROPE_MASK, SUB_ROPE_MASK, ROPE_TABLE_KEY_MASK, INVALID_ROPE_MASK, VALID_ROPE_MASK, INT_ROPE_MASK, ENCODING_MASK, MODULE_FIELDS_MASK, BASIC_LAYOUT_MASK, METHOD_INFO_MASK, RUBY_ROOT_NODE_MASK});
    }

    public String getDetailsString(String className, Instance instance, Heap heap) {
        Instance logicalClassInst;
        String encodingString;
        byte[] bytes;
        if (RUBY_OBJECT_TYPE_MASK.equals(className)) {
            String name = instance.getJavaClass().getName();
            int index = name.lastIndexOf(36);
            if (index == -1) {
                index = name.lastIndexOf(46);
            }
            return name.substring(index + 1);
        }
        if (ASCII_ROPE_MASK.equals(className)) {
            Integer len = (Integer)instance.getValueOfField("byteLength");
            return this.getByteArrayFieldString(instance, "bytes", 0, len, "...");
        }
        if (CONCAT_ROPE_MASK.equals(className)) {
            Object vall = instance.getValueOfField("left");
            Object valr = instance.getValueOfField("right");
            String left = DetailsUtils.getInstanceString((Instance)((Instance)vall), (Heap)heap);
            if (left == null) {
                return DetailsUtils.getInstanceString((Instance)((Instance)valr), (Heap)heap);
            }
            if (valr == null || left.length() > 160) {
                return left;
            }
            String value = left + DetailsUtils.getInstanceString((Instance)((Instance)valr), (Heap)heap);
            if (value.length() > 160) {
                return value.substring(0, 160) + "...";
            }
            return value;
        }
        if (SUB_ROPE_MASK.equals(className)) {
            Object offset = instance.getValueOfField("byteOffset");
            Object child = instance.getValueOfField("child");
            String childString = DetailsUtils.getInstanceString((Instance)((Instance)child), (Heap)heap);
            if (offset == null) {
                offset = instance.getValueOfField("offset");
            }
            int byteOffset = (Integer)offset;
            if (childString.length() > byteOffset) {
                return childString.substring(byteOffset);
            }
        }
        if (ENCODING_MASK.equals(className)) {
            return this.getByteArrayFieldString(instance, "name", 0, -1, "...");
        }
        if (ROPE_TABLE_KEY_MASK.equals(className)) {
            bytes = this.getByteArrayFieldString(instance, "bytes", 0, -1);
            encodingString = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"encoding", (Heap)heap);
            return this.getString(bytes, encodingString, "...");
        }
        if (INVALID_ROPE_MASK.equals(className)) {
            bytes = this.getByteArrayFieldString(instance, "bytes", 0, -1);
            encodingString = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"encoding", (Heap)heap);
            return this.getString(bytes, encodingString, "...");
        }
        if (VALID_ROPE_MASK.equals(className)) {
            bytes = this.getByteArrayFieldString(instance, "bytes", 0, -1);
            encodingString = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"encoding", (Heap)heap);
            return this.getString(bytes, encodingString, "...");
        }
        if (INT_ROPE_MASK.equals(className)) {
            return Integer.toString(DetailsUtils.getIntFieldValue((Instance)instance, (String)"value", (int)0));
        }
        if (MODULE_FIELDS_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name", (Heap)heap);
        }
        if (BASIC_LAYOUT_MASK.equals(className) && DynamicObject.isDynamicObject(logicalClassInst = (Instance)instance.getValueOfField("logicalClass"))) {
            DynamicObject logicalClass = new DynamicObject(logicalClassInst);
            ObjectFieldValue fields = (ObjectFieldValue)logicalClass.getFieldValue("fields (hidden)");
            return DetailsUtils.getInstanceString((Instance)fields.getInstance(), (Heap)heap);
        }
        if (METHOD_INFO_MASK.equals(className)) {
            Instance name = (Instance)instance.getValueOfField("name");
            if (name == null) {
                name = (Instance)instance.getValueOfField("notes");
            }
            return DetailsUtils.getInstanceString((Instance)name, (Heap)heap);
        }
        if (RUBY_ROOT_NODE_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"sharedMethodInfo", (Heap)heap);
        }
        return null;
    }

    private byte[] getByteArrayFieldString(Instance instance, String field, int offset, int count) {
        PrimitiveArrayInstance array;
        List values;
        Object fieldVal = instance.getValueOfField(field);
        if (fieldVal instanceof PrimitiveArrayInstance && (values = (array = (PrimitiveArrayInstance)fieldVal).getValues()) != null) {
            int valuesCount = count < 0 ? values.size() - offset : Math.min(count, values.size() - offset);
            int estimatedSize = Math.min(valuesCount, 161);
            byte[] bytes = new byte[estimatedSize];
            int lastValue = offset + valuesCount - 1;
            for (int i = offset; i <= lastValue; ++i) {
                bytes[i - offset] = Byte.parseByte((String)values.get(i));
                if (i - offset + 1 >= 160) break;
            }
            return bytes;
        }
        return null;
    }

    private String getByteArrayFieldString(Instance instance, String field, int offset, int count, String trailer) {
        byte[] bytes = this.getByteArrayFieldString(instance, field, offset, count);
        return this.getString(bytes, Charset.defaultCharset().name(), trailer);
    }

    private String getString(byte[] bytes, String encodingString, String trailer) {
        if (bytes != null) {
            String val;
            int len = Math.min(bytes.length, 160);
            try {
                val = new String(bytes, 0, len, encodingString);
            }
            catch (UnsupportedEncodingException ex) {
                val = new String(bytes, 0, len);
            }
            if (bytes.length > 160) {
                return val + trailer;
            }
            return val;
        }
        return null;
    }
}

