/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.python;

import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.python.PythonType;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleLocalObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectFieldNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleObjectReferenceNode;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleOpenNodeActionProvider;
import org.graalvm.visualvm.heapviewer.truffle.nodes.TruffleTypeNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class PythonNodes
extends TruffleOpenNodeActionProvider<PythonObject, PythonType, PythonHeapFragment, PythonLanguage> {
    private static final int MAX_LOGVALUE_LENGTH = 160;

    public boolean supportsView(HeapContext context, String viewID) {
        return PythonHeapFragment.isPythonHeap(context);
    }

    @Override
    protected boolean supportsNode(HeapViewerNode node) {
        return node instanceof PythonNode;
    }

    @Override
    protected PythonLanguage getLanguage() {
        return PythonLanguage.instance();
    }

    static String getLogicalValue(PythonObject object, String type, Heap heap) {
        String logicalValue = null;
        if ("ModuleSpec".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"name".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("SourceFileLoader".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"path".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("mappingproxy".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"__name__".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("generator".equals(type)) {
            logicalValue = DetailsUtils.getInstanceFieldString((Instance)object.getInstance(), (String)"name", (Heap)heap);
        } else if ("FileIO".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"name".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("super".equals(type)) {
            Object moduleO = object.getInstance().getValueOfField("type");
            if (!(moduleO instanceof Instance)) {
                moduleO = null;
            } else if (!((Instance)moduleO).getJavaClass().getName().equals("com.oracle.graal.python.builtins.objects.type.PythonClass")) {
                moduleO = null;
            }
            logicalValue = moduleO == null ? null : DetailsUtils.getInstanceString((Instance)((Instance)moduleO), (Heap)heap);
        } else if ("code".equals(type)) {
            Object rootNode;
            Object callTarget = object.getInstance().getValueOfField("callTarget");
            if (callTarget instanceof Instance && (rootNode = ((Instance)callTarget).getValueOfField("rootNode")) instanceof Instance) {
                logicalValue = DetailsUtils.getInstanceFieldString((Instance)((Instance)rootNode), (String)"functionName", (Heap)heap);
            }
        } else if ("FileFinder".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"path".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("BufferedReader".equals(type) || "BufferedWriter".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                Instance attributeI;
                if (!"_raw".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue) || !PythonObject.isPythonObject(attributeI = ((ObjectFieldValue)attribute).getInstance())) continue;
                logicalValue = PythonNodes.getLogicalValue(new PythonObject(attributeI), "FileIO", heap);
                break;
            }
        } else if ("TextIOWrapper".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                Instance attributeI;
                if (!"_buffer".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue) || !PythonObject.isPythonObject(attributeI = ((ObjectFieldValue)attribute).getInstance())) continue;
                logicalValue = PythonNodes.getLogicalValue(new PythonObject(attributeI), "BufferedWriter", heap);
                break;
            }
        } else if ("TemplateFormatter".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"template".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("_Printer".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"__name".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("Quitter".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"name".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("CodecInfo".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            for (FieldValue attribute : attributes) {
                if (!"name".equals(attribute.getField().getName()) || !(attribute instanceof ObjectFieldValue)) continue;
                Instance attributeI = ((ObjectFieldValue)attribute).getInstance();
                logicalValue = DetailsSupport.getDetailsString((Instance)attributeI, (Heap)heap);
                break;
            }
        } else if ("dict".equals(type)) {
            List<FieldValue> attributes = object.getAttributes();
            logicalValue = attributes.size() + " pairs";
        }
        if (logicalValue != null && logicalValue.length() > 160) {
            logicalValue = logicalValue.substring(0, 160) + "...";
        }
        return logicalValue != null ? logicalValue : DetailsSupport.getDetailsString((Instance)object.getInstance(), (Heap)heap);
    }

    private static String computeObjectName(TruffleObjectNode.InstanceBased<PythonObject> node, Heap heap) {
        String typeString = node.getTypeName();
        return typeString.substring(typeString.lastIndexOf(46) + 1) + "#" + node.getInstance().getInstanceNumber();
    }

    private static PythonObjectNode createCopy(TruffleObjectNode.InstanceBased<PythonObject> node) {
        return new PythonObjectNode((PythonObject)node.getTruffleObject(), node.getTypeName());
    }

    public static class PythonNodesRendererProvider
    extends HeapViewerRenderer.Provider {
        public boolean supportsView(HeapContext context, String viewID) {
            return true;
        }

        public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
            PythonLanguage language = PythonLanguage.instance();
            Icon instanceIcon = language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Instance"));
            Icon packageIcon = language.createLanguageIcon(Icons.getIcon((String)"LanguageIcons.Package"));
            Heap heap = context.getFragment().getHeap();
            renderers.put(PythonObjectNode.class, new TruffleObjectNode.Renderer(heap, instanceIcon));
            renderers.put(PythonTypeNode.class, new TruffleTypeNode.Renderer(packageIcon));
            renderers.put(PythonObjectFieldNode.class, new TruffleObjectFieldNode.Renderer(heap, instanceIcon));
            renderers.put(PythonObjectReferenceNode.class, new TruffleObjectReferenceNode.Renderer(heap, instanceIcon));
            renderers.put(PythonObjectAttributeReferenceNode.class, new TruffleObjectReferenceNode.Renderer(heap, instanceIcon, "attribute in"));
        }
    }

    static class PythonObjectAttributeReferenceNode
    extends TruffleObjectReferenceNode.InstanceBased<PythonObject>
    implements PythonNode {
        PythonObjectAttributeReferenceNode(PythonObject object, String type, FieldValue value) {
            super(object, type, value);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return PythonNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(PythonObject object, String type, Heap heap) {
            String logicalValue = PythonNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public PythonObjectNode createCopy() {
            return PythonNodes.createCopy(this);
        }
    }

    static class PythonObjectReferenceNode
    extends TruffleObjectReferenceNode.InstanceBased<PythonObject>
    implements PythonNode {
        PythonObjectReferenceNode(PythonObject object, String type, FieldValue value) {
            super(object, type, value);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return PythonNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(PythonObject object, String type, Heap heap) {
            String logicalValue = PythonNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public PythonObjectNode createCopy() {
            return PythonNodes.createCopy(this);
        }
    }

    static class PythonObjectFieldNode
    extends TruffleObjectFieldNode.InstanceBased<PythonObject>
    implements PythonNode {
        PythonObjectFieldNode(PythonObject object, String type, FieldValue field) {
            super(object, type, field);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return PythonNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(PythonObject object, String type, Heap heap) {
            String logicalValue = PythonNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public PythonObjectNode createCopy() {
            return PythonNodes.createCopy(this);
        }
    }

    static class PythonTypeNode
    extends TruffleTypeNode<PythonObject, PythonType>
    implements PythonNode {
        PythonTypeNode(PythonType type) {
            super(type);
        }

        @Override
        public HeapViewerNode createNode(PythonObject object, Heap heap) {
            String type = ((PythonType)this.getType()).getName();
            return new PythonObjectNode(object, type);
        }

        @Override
        public TruffleTypeNode createCopy() {
            PythonTypeNode copy = new PythonTypeNode((PythonType)this.getType());
            this.setupCopy(copy);
            return copy;
        }

        protected void setupCopy(PythonTypeNode copy) {
            super.setupCopy(copy);
        }
    }

    static class PythonLocalObjectNode
    extends TruffleLocalObjectNode.InstanceBased<PythonObject>
    implements PythonNode {
        PythonLocalObjectNode(PythonObject object, String type) {
            super(object, type);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return PythonNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(PythonObject object, String type, Heap heap) {
            String logicalValue = PythonNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        @Override
        public PythonObjectNode createCopy() {
            return PythonNodes.createCopy(this);
        }
    }

    static class PythonObjectNode
    extends TruffleObjectNode.InstanceBased<PythonObject>
    implements PythonNode {
        public PythonObjectNode(PythonObject object, Heap heap) {
            this(object, object.getType(heap));
        }

        public PythonObjectNode(PythonObject robject, String type) {
            super(robject, type);
        }

        @Override
        protected String computeObjectName(Heap heap) {
            return PythonNodes.computeObjectName(this, heap);
        }

        @Override
        protected String computeLogicalValue(PythonObject object, String type, Heap heap) {
            String logicalValue = PythonNodes.getLogicalValue(object, type, heap);
            return logicalValue != null ? logicalValue : super.computeLogicalValue(object, type, heap);
        }

        public PythonObjectNode createCopy() {
            PythonObjectNode copy = PythonNodes.createCopy(this);
            this.setupCopy(copy);
            return copy;
        }

        protected void setupCopy(PythonObjectNode copy) {
            super.setupCopy(copy);
        }
    }

    static interface PythonNode {
    }
}

