/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.javaext;

import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleFrame;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectNode;
import org.graalvm.visualvm.heapviewer.truffle.javaext.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.openide.util.ImageUtilities;

class TruffleViewPlugin
extends HeapViewPlugin {
    private final Heap heap;
    private Instance selected;
    private final TreeTableView objectsView;

    public TruffleViewPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.TruffleViewPlugin_Name(), Bundle.TruffleViewPlugin_Description(), TruffleViewPlugin.graalIcon());
        this.heap = context.getFragment().getHeap();
        this.objectsView = new TreeTableView("truffle_objects_javaext", context, actions, TreeTableViewColumn.instancesPlain((Heap)this.heap)){

            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                if (DynamicObject.isDynamicObject(TruffleViewPlugin.this.selected)) {
                    DynamicObject dobject = new DynamicObject(TruffleViewPlugin.this.selected);
                    return new HeapViewerNode[]{new DynamicObjectNode<DynamicObject>(dobject, dobject.getType(heap))};
                }
                if (TruffleFrame.isTruffleFrame(TruffleViewPlugin.this.selected)) {
                    return new HeapViewerNode[]{new InstanceNode(TruffleViewPlugin.this.selected)};
                }
                return new HeapViewerNode[]{new TextNode(Bundle.TruffleViewPlugin_NoSelection())};
            }

            protected void childrenChanged() {
                HeapViewerNode[] children;
                for (HeapViewerNode child : children = this.getRoot().getChildren()) {
                    this.expandNode(child);
                }
                if (children.length > 0 && (children = children[0].getChildren()).length > 0 && children[0] instanceof TextNode) {
                    this.expandNode(children[0]);
                }
            }
        };
    }

    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    protected void closed() {
        this.objectsView.closed();
    }

    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        Instance instance;
        Instance instance2 = instance = node == null ? null : (Instance)HeapViewerNode.getValue((HeapViewerNode)node, (DataType)DataType.INSTANCE, (Heap)this.heap);
        if (Objects.equals(instance, this.selected)) {
            return;
        }
        this.selected = instance;
        this.objectsView.reloadView();
    }

    private static Icon graalIcon() {
        String path = TruffleViewPlugin.class.getPackage().getName().replace('.', '/') + "/GraalVM.png";
        return new ImageIcon(ImageUtilities.loadImage((String)path, (boolean)true));
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (!JavaHeapFragment.isJavaHeap((HeapContext)context)) {
                return null;
            }
            if (!DynamicObject.hasDynamicObject(context.getFragment().getHeap())) {
                return null;
            }
            return new TruffleViewPlugin(context, actions);
        }
    }
}

