/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.DirectInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

final class StaticInvokeTypeFlow
extends DirectInvokeTypeFlow {
    private AnalysisContext calleeContext;

    protected StaticInvokeTypeFlow(Invoke invoke, MethodCallTargetNode target, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        super(invoke, target, actualParameters, actualReturn, location);
        this.calleeContext = null;
        assert (target.invokeKind() == CallTargetNode.InvokeKind.Static);
    }

    protected StaticInvokeTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, StaticInvokeTypeFlow original) {
        super(bb, methodFlows, original);
    }

    @Override
    public TypeFlow<MethodCallTargetNode> copy(BigBang bb, MethodFlowsGraph methodFlows) {
        return new StaticInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    public void update(BigBang bb) {
        assert (this.isClone());
        JVMCIError.guarantee((this.callee == null ? 1 : 0) != 0, (String)"static invoke updated multiple times!", (Object[])new Object[0]);
        MethodCallTargetNode target = (MethodCallTargetNode)this.invoke.callTarget();
        ((DirectInvokeTypeFlow)this.originalInvoke).callee = this.callee = ((AnalysisMethod)target.targetMethod()).getTypeFlow();
        this.calleeContext = bb.contextPolicy().staticCalleeContext(bb, this.location, this.callerContext, this.callee);
        MethodFlowsGraph calleeFlows = this.callee.addContext(bb, this.calleeContext, this);
        this.linkCallee(bb, true, calleeFlows);
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(BigBang bb) {
        if (this.callee == null || this.calleeContext == null) {
            return Collections.emptyList();
        }
        assert (this.calleeContext != null);
        MethodFlowsGraph methodFlows = this.callee.getFlows(this.calleeContext);
        return Collections.singletonList(methodFlows);
    }

    @Override
    public String toString() {
        return "StaticInvoke<" + ((MethodCallTargetNode)this.getSource()).targetMethod().format("%h.%n") + ">:" + this.getState();
    }
}

