/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.generic.model.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericEvent;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericEventFactory;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericEventType;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventType;
import org.graalvm.visualvm.jfr.model.JFREventTypeVisitor;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.openjdk.jmc.flightrecorder.internal.FlightRecordingLoader;

final class JFRGenericModel
extends JFRModel {
    private static final Logger LOGGER = Logger.getLogger(JFRModel.class.getName());
    private final EventArray[] types;
    private final JFRGenericEventFactory factory;

    JFRGenericModel(String id, File snapshotFile) throws IOException, CouldNotLoadRecordingException {
        super(id);
        this.types = JFRGenericModel.loadFile(snapshotFile);
        this.factory = JFRGenericEventFactory.resolve(this.types);
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEvents(JFREventVisitor ... visitors) {
        for (JFREventVisitor visitor : visitors) {
            visitor.init();
        }
        try {
            JFREventVisitor[] _visitors = new ArrayList(Arrays.asList(visitors));
            Iterator<EventArray> iterables = Arrays.asList(this.types).iterator();
            while (!_visitors.isEmpty() && iterables.hasNext()) {
                EventArray type = iterables.next();
                String typeId = type.getType().getIdentifier();
                Iterator<IItem> items = Arrays.asList(type.getEvents()).iterator();
                while (!_visitors.isEmpty() && items.hasNext()) {
                    JFRGenericEvent event = this.factory.createEvent(items.next());
                    Iterator _visitorsI = _visitors.iterator();
                    while (_visitorsI.hasNext()) {
                        if (!((JFREventVisitor)_visitorsI.next()).visit(typeId, (JFREvent)event)) continue;
                        _visitorsI.remove();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error visiting JFR events (generic loader)", e);
        }
        finally {
            for (JFREventVisitor visitor : visitors) {
                visitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEventTypes(JFREventTypeVisitor ... visitors) {
        for (JFREventTypeVisitor visitor : visitors) {
            visitor.initTypes();
        }
        try {
            JFREventTypeVisitor[] _visitors = new ArrayList(Arrays.asList(visitors));
            int typeIdx = 0;
            while (!_visitors.isEmpty() && typeIdx < this.types.length) {
                EventArray type = this.types[typeIdx];
                IType itype = type.getType();
                String typeId = itype.getIdentifier();
                String[] typeCategory = type.getTypeCategory();
                if (typeCategory == null) {
                    typeCategory = new String[]{"Uncategorized"};
                }
                JFRGenericEventType event = new JFRGenericEventType(typeIdx++, itype, typeCategory);
                Iterator _visitorsI = _visitors.iterator();
                while (_visitorsI.hasNext()) {
                    if (!((JFREventTypeVisitor)_visitorsI.next()).visitType(typeId, (JFREventType)event)) continue;
                    _visitorsI.remove();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error visiting JFR event types (generic loader)", e);
        }
        finally {
            for (JFREventTypeVisitor visitor : visitors) {
                visitor.doneTypes();
            }
        }
    }

    private static EventArray[] loadFile(File file) throws IOException, CouldNotLoadRecordingException {
        InputStream stream = IOToolkit.openUncompressedStream(file);
        try {
            EventArray[] eventArrayArray = FlightRecordingLoader.loadStream((InputStream)stream, (boolean)false, (boolean)true);
            return eventArrayArray;
        }
        finally {
            IOToolkit.closeSilently(stream);
        }
    }
}

