/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

public class RuntimeCodeInfoMemory {
    private final ReentrantLock lock = new ReentrantLock();
    private NonmovableArray<UntetheredCodeInfo> table;
    private int count = 0;

    @Fold
    public static RuntimeCodeInfoMemory singleton() {
        return (RuntimeCodeInfoMemory)ImageSingletons.lookup(RuntimeCodeInfoMemory.class);
    }

    public boolean add(CodeInfo info) {
        assert (!Heap.getHeap().isAllocationDisallowed());
        assert (info.isNonNull());
        this.lock.lock();
        try {
            boolean bl = this.add0(info);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean remove(CodeInfo info) {
        assert (VMOperation.isGCInProgress()) : "Otherwise, we would need to protect the CodeInfo from the GC.";
        assert (info.isNonNull());
        int length = NonmovableArrays.lengthOf(this.table);
        int index = RuntimeCodeInfoMemory.hashIndex(info, length);
        UntetheredCodeInfo entry = NonmovableArrays.getWord(this.table, index);
        while (entry.isNonNull()) {
            if (entry.equal((ComparableWord)info)) {
                NonmovableArrays.setWord(this.table, index, WordFactory.zero());
                --this.count;
                this.rehashAfterUnregisterAt(index);
                return true;
            }
            index = RuntimeCodeInfoMemory.nextIndex(index, length);
            entry = NonmovableArrays.getWord(this.table, index);
        }
        return false;
    }

    @Uninterruptible(reason="Manipulate walkers list atomically with regard to GC.")
    private boolean add0(CodeInfo info) {
        int index;
        boolean resized;
        if (this.table.isNull()) {
            this.table = NonmovableArrays.createWordArray(32);
        }
        do {
            int length = NonmovableArrays.lengthOf(this.table);
            index = RuntimeCodeInfoMemory.hashIndex(info, length);
            while (NonmovableArrays.getWord(this.table, index).isNonNull()) {
                assert (NonmovableArrays.getWord(this.table, index).notEqual((ComparableWord)info)) : "Duplicate CodeInfo";
                index = RuntimeCodeInfoMemory.nextIndex(index, length);
            }
            resized = false;
            int newCount = this.count + 1;
            if (newCount + (newCount << 1) <= length << 1) continue;
            resized = this.resize(length << 1);
        } while (resized);
        NonmovableArrays.setWord(this.table, index, info);
        ++this.count;
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean resize(int newLength) {
        assert (SubstrateUtil.isPowerOf2(newLength));
        int maxLength = 0x40000000;
        int oldLength = NonmovableArrays.lengthOf(this.table);
        if (oldLength == 0x40000000) {
            VMError.guarantee(this.count < 0x3FFFFFFF, "Maximum capacity exhausted");
            return false;
        }
        if (oldLength >= newLength) {
            return false;
        }
        NonmovableArray<UntetheredCodeInfo> oldTable = this.table;
        this.table = NonmovableArrays.createWordArray(newLength);
        for (int i = 0; i < oldLength; ++i) {
            UntetheredCodeInfo tag = NonmovableArrays.getWord(oldTable, i);
            if (!tag.isNonNull()) continue;
            NonmovableArrays.setWord(oldTable, i, WordFactory.zero());
            int u = RuntimeCodeInfoMemory.hashIndex(tag, newLength);
            while (NonmovableArrays.getWord(this.table, u).isNonNull()) {
                u = RuntimeCodeInfoMemory.nextIndex(u, newLength);
            }
            NonmovableArrays.setWord(this.table, u, tag);
        }
        NonmovableArrays.releaseUnmanagedArray(oldTable);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    private void rehashAfterUnregisterAt(int index) {
        int length = NonmovableArrays.lengthOf(this.table);
        int d = index;
        int i = RuntimeCodeInfoMemory.nextIndex(d, length);
        UntetheredCodeInfo info = NonmovableArrays.getWord(this.table, i);
        while (info.isNonNull()) {
            int r = RuntimeCodeInfoMemory.hashIndex(info, length);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                NonmovableArrays.setWord(this.table, d, info);
                NonmovableArrays.setWord(this.table, i, WordFactory.zero());
                d = i;
            }
            i = RuntimeCodeInfoMemory.nextIndex(i, length);
            info = NonmovableArrays.getWord(this.table, i);
        }
    }

    public boolean walkRuntimeMethods(RuntimeCodeCache.CodeInfoVisitor visitor) {
        assert (VMOperation.isGCInProgress()) : "otherwise, we would need to make sure that the CodeInfo is not freeded by the GC";
        if (this.table.isNonNull()) {
            int length = NonmovableArrays.lengthOf(this.table);
            int i = 0;
            while (i < length) {
                UntetheredCodeInfo info = NonmovableArrays.getWord(this.table, i);
                if (info.isNonNull()) {
                    visitor.visitCode(CodeInfoAccess.convert(info));
                }
                if (info != NonmovableArrays.getWord(this.table, i)) continue;
                ++i;
            }
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int hashIndex(UntetheredCodeInfo tag, int length) {
        int h = (int)(tag.rawValue() >>> 32) * 31 + (int)tag.rawValue();
        return (h << 1) - (h << 8) & length - 1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int nextIndex(int index, int length) {
        return index + 1 < length ? index + 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void tearDown() {
        if (this.table.isNonNull()) {
            int length = NonmovableArrays.lengthOf(this.table);
            for (int i = 0; i < length; ++i) {
                UntetheredCodeInfo untetheredInfo = NonmovableArrays.getWord(this.table, i);
                if (!untetheredInfo.isNonNull()) continue;
                Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
                try {
                    CodeInfo info = CodeInfoAccess.convert(untetheredInfo, tether);
                    RuntimeCodeInfoAccess.releaseMethodInfoOnTearDown(info);
                    continue;
                }
                finally {
                    CodeInfoAccess.releaseTetherUnsafe(untetheredInfo, tether);
                }
            }
            NonmovableArrays.releaseUnmanagedArray(this.table);
            this.table = NonmovableArrays.nullArray();
        }
    }
}

