/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TypedDataOutputStream
extends DataOutputStream {
    public static boolean isValueSupported(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> valueClass = value.getClass();
        return valueClass == Boolean.class || valueClass == Byte.class || valueClass == Short.class || valueClass == Character.class || valueClass == Integer.class || valueClass == Long.class || valueClass == Float.class || valueClass == Double.class || valueClass == String.class || value.getClass().isEnum();
    }

    public TypedDataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeTypedValue(Object value) throws IOException {
        Class<?> valueClz = value.getClass();
        if (valueClz == Boolean.class) {
            this.writeByte(90);
            this.writeBoolean((Boolean)value);
        } else if (valueClz == Byte.class) {
            this.writeByte(66);
            this.writeByte(((Byte)value).byteValue());
        } else if (valueClz == Short.class) {
            this.writeByte(83);
            this.writeShort(((Short)value).shortValue());
        } else if (valueClz == Character.class) {
            this.writeByte(67);
            this.writeChar(((Character)value).charValue());
        } else if (valueClz == Integer.class) {
            this.writeByte(73);
            this.writeInt((Integer)value);
        } else if (valueClz == Long.class) {
            this.writeByte(74);
            this.writeLong((Long)value);
        } else if (valueClz == Float.class) {
            this.writeByte(70);
            this.writeFloat(((Float)value).floatValue());
        } else if (valueClz == Double.class) {
            this.writeByte(68);
            this.writeDouble((Double)value);
        } else if (valueClz == String.class) {
            this.writeByte(85);
            this.writeUTF((String)value);
        } else if (valueClz.isEnum()) {
            this.writeByte(85);
            this.writeUTF(((Enum)value).name());
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type: Value: %s, Value type: %s", value, valueClz));
        }
    }
}

