/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal;

import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.libgraal.LibGraal;

public final class LibGraalScope
implements AutoCloseable {
    static final ThreadLocal<LibGraalScope> currentScope = new ThreadLocal();
    private final LibGraalScope parent;
    private final boolean topLevel;
    private final HotSpotJVMCIRuntime runtime;
    private final long isolateThread;

    public static long getIsolateThread() {
        LibGraalScope scope = currentScope.get();
        if (scope == null) {
            throw new IllegalStateException("Cannot get isolate thread outside of a " + LibGraalScope.class.getSimpleName());
        }
        return scope.isolateThread;
    }

    public LibGraalScope(HotSpotJVMCIRuntime runtime) {
        if (LibGraal.inLibGraal() || !LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        this.runtime = runtime;
        this.parent = currentScope.get();
        boolean top = false;
        if (this.parent == null) {
            top = LibGraal.attachCurrentThread(runtime, false);
            this.isolateThread = LibGraal.getCurrentIsolateThread(LibGraal.isolate);
        } else {
            this.isolateThread = this.parent.isolateThread;
        }
        this.topLevel = top;
        currentScope.set(this);
    }

    @Override
    public void close() {
        if (this.topLevel) {
            LibGraal.detachCurrentThread(this.runtime);
        }
        currentScope.set(this.parent);
    }
}

