/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.virtual.phases.ea.EffectsClosure;
import org.graalvm.compiler.virtual.phases.ea.GraphEffectList;
import org.graalvm.compiler.virtual.phases.ea.ReadEliminationBlockState;
import org.graalvm.word.LocationIdentity;

public final class ReadEliminationClosure
extends EffectsClosure<ReadEliminationBlockState> {
    private final boolean considerGuards;

    public ReadEliminationClosure(ControlFlowGraph cfg, boolean considerGuards) {
        super(null, cfg);
        this.considerGuards = considerGuards;
    }

    @Override
    protected ReadEliminationBlockState getInitialState() {
        return new ReadEliminationBlockState();
    }

    @Override
    protected boolean processNode(Node node, ReadEliminationBlockState state, GraphEffectList effects, FixedWithNextNode lastFixedNode) {
        boolean deleted = false;
        if (node instanceof AccessFieldNode) {
            AccessFieldNode access = (AccessFieldNode)node;
            if (access.isVolatile()) {
                ReadEliminationClosure.processIdentity(state, LocationIdentity.any());
            } else {
                ValueNode object = GraphUtil.unproxify(access.object());
                ReadEliminationBlockState.LoadCacheEntry identifier = new ReadEliminationBlockState.LoadCacheEntry(object, new FieldLocationIdentity(access.field()));
                ValueNode cachedValue = state.getCacheEntry(identifier);
                if (node instanceof LoadFieldNode) {
                    if (cachedValue != null && access.stamp(NodeView.DEFAULT).isCompatible(cachedValue.stamp(NodeView.DEFAULT))) {
                        effects.replaceAtUsages(access, cachedValue, access);
                        this.addScalarAlias(access, cachedValue);
                        deleted = true;
                    } else {
                        state.addCacheEntry(identifier, access);
                    }
                } else {
                    assert (node instanceof StoreFieldNode);
                    StoreFieldNode store = (StoreFieldNode)node;
                    ValueNode value = this.getScalarAlias(store.value());
                    if (GraphUtil.unproxify(value) == GraphUtil.unproxify(cachedValue)) {
                        effects.deleteNode(store);
                        deleted = true;
                    }
                    state.killReadCache((LocationIdentity)identifier.identity);
                    state.addCacheEntry(identifier, value);
                }
            }
        } else if (node instanceof ReadNode) {
            ReadNode read = (ReadNode)node;
            if (read.getLocationIdentity().isSingle()) {
                ValueNode object = GraphUtil.unproxify(read.getAddress());
                ReadEliminationBlockState.LoadCacheEntry identifier = new ReadEliminationBlockState.LoadCacheEntry(object, read.getLocationIdentity());
                ValueNode cachedValue = state.getCacheEntry(identifier);
                if (cachedValue != null && ReadEliminationClosure.areValuesReplaceable(read, cachedValue, this.considerGuards)) {
                    effects.replaceAtUsages(read, cachedValue, read);
                    this.addScalarAlias(read, cachedValue);
                    deleted = true;
                } else {
                    state.addCacheEntry(identifier, read);
                }
            }
        } else if (node instanceof WriteNode) {
            WriteNode write = (WriteNode)node;
            if (write.getKilledLocationIdentity().isSingle()) {
                ValueNode object = GraphUtil.unproxify(write.getAddress());
                ReadEliminationBlockState.LoadCacheEntry identifier = new ReadEliminationBlockState.LoadCacheEntry(object, write.getKilledLocationIdentity());
                ValueNode cachedValue = state.getCacheEntry(identifier);
                ValueNode value = this.getScalarAlias(write.value());
                if (GraphUtil.unproxify(value) == GraphUtil.unproxify(cachedValue)) {
                    effects.deleteNode(write);
                    deleted = true;
                }
                ReadEliminationClosure.processIdentity(state, write.getKilledLocationIdentity());
                state.addCacheEntry(identifier, value);
            } else {
                ReadEliminationClosure.processIdentity(state, write.getKilledLocationIdentity());
            }
        } else if (node instanceof UnsafeAccessNode) {
            ResolvedJavaType type = StampTool.typeOrNull(((UnsafeAccessNode)node).object());
            if (type != null && !type.isArray()) {
                if (node instanceof RawLoadNode) {
                    RawLoadNode load = (RawLoadNode)node;
                    if (load.getLocationIdentity().isSingle()) {
                        ValueNode object = GraphUtil.unproxify(load.object());
                        ReadEliminationBlockState.UnsafeLoadCacheEntry identifier = new ReadEliminationBlockState.UnsafeLoadCacheEntry(object, load.offset(), load.getLocationIdentity());
                        ValueNode cachedValue = state.getCacheEntry(identifier);
                        if (cachedValue != null && ReadEliminationClosure.areValuesReplaceable(load, cachedValue, this.considerGuards)) {
                            effects.replaceAtUsages(load, cachedValue, load);
                            this.addScalarAlias(load, cachedValue);
                            deleted = true;
                        } else {
                            state.addCacheEntry(identifier, load);
                        }
                    }
                } else {
                    assert (node instanceof RawStoreNode);
                    RawStoreNode write = (RawStoreNode)node;
                    if (write.getKilledLocationIdentity().isSingle()) {
                        ValueNode object = GraphUtil.unproxify(write.object());
                        ReadEliminationBlockState.UnsafeLoadCacheEntry identifier = new ReadEliminationBlockState.UnsafeLoadCacheEntry(object, write.offset(), write.getKilledLocationIdentity());
                        ValueNode cachedValue = state.getCacheEntry(identifier);
                        ValueNode value = this.getScalarAlias(write.value());
                        if (GraphUtil.unproxify(value) == GraphUtil.unproxify(cachedValue)) {
                            effects.deleteNode(write);
                            deleted = true;
                        }
                        ReadEliminationClosure.processIdentity(state, write.getKilledLocationIdentity());
                        state.addCacheEntry(identifier, value);
                    } else {
                        ReadEliminationClosure.processIdentity(state, write.getKilledLocationIdentity());
                    }
                }
            }
        } else if (node instanceof MemoryCheckpoint.Single) {
            LocationIdentity identity = ((MemoryCheckpoint.Single)((Object)node)).getKilledLocationIdentity();
            ReadEliminationClosure.processIdentity(state, identity);
        } else if (node instanceof MemoryCheckpoint.Multi) {
            for (LocationIdentity identity : ((MemoryCheckpoint.Multi)((Object)node)).getKilledLocationIdentities()) {
                ReadEliminationClosure.processIdentity(state, identity);
            }
        }
        return deleted;
    }

    private static boolean areValuesReplaceable(ValueNode originalValue, ValueNode replacementValue, boolean considerGuards) {
        return originalValue.stamp(NodeView.DEFAULT).isCompatible(replacementValue.stamp(NodeView.DEFAULT)) && (!considerGuards || ReadEliminationClosure.getGuard(originalValue) == null || ReadEliminationClosure.getGuard(originalValue) == ReadEliminationClosure.getGuard(replacementValue));
    }

    private static GuardingNode getGuard(ValueNode node) {
        if (node instanceof GuardedNode) {
            GuardedNode guardedNode = (GuardedNode)((Object)node);
            return guardedNode.getGuard();
        }
        return null;
    }

    private static void processIdentity(ReadEliminationBlockState state, LocationIdentity identity) {
        if (identity.isAny()) {
            state.killReadCache();
            return;
        }
        state.killReadCache(identity);
    }

    @Override
    protected void processLoopExit(LoopExitNode exitNode, ReadEliminationBlockState initialState, ReadEliminationBlockState exitState, GraphEffectList effects) {
        if (exitNode.graph().hasValueProxies()) {
            MapCursor entry = exitState.getReadCache().getEntries();
            while (entry.advance()) {
                if (initialState.getReadCache().get(entry.getKey()) == entry.getValue()) continue;
                ValueProxyNode proxy = new ValueProxyNode(exitState.getCacheEntry((ReadEliminationBlockState.CacheEntry)entry.getKey()), exitNode);
                effects.addFloatingNode(proxy, "readCacheProxy");
                exitState.getReadCache().put(entry.getKey(), (Object)proxy);
            }
        }
    }

    @Override
    protected ReadEliminationBlockState cloneState(ReadEliminationBlockState other) {
        return new ReadEliminationBlockState(other);
    }

    @Override
    protected EffectsClosure.MergeProcessor createMergeProcessor(Block merge) {
        return new ReadEliminationMergeProcessor(merge);
    }

    @Override
    protected void processKilledLoopLocations(Loop<Block> loop, ReadEliminationBlockState initialState, ReadEliminationBlockState mergedStates) {
        assert (initialState != null);
        assert (mergedStates != null);
        if (initialState.readCache.size() > 0) {
            EffectsClosure.LoopKillCache loopKilledLocations = (EffectsClosure.LoopKillCache)this.loopLocationKillCache.get(loop);
            if (loopKilledLocations == null) {
                loopKilledLocations = new EffectsClosure.LoopKillCache(1);
                this.loopLocationKillCache.put(loop, (Object)loopKilledLocations);
            } else {
                OptionValues options = loop.getHeader().getBeginNode().getOptions();
                if (loopKilledLocations.visits() > GraalOptions.ReadEliminationMaxLoopVisits.getValue(options)) {
                    loopKilledLocations.setKillsAll();
                } else {
                    EconomicSet forwardEndLiveLocations = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
                    for (ReadEliminationBlockState.CacheEntry entry : initialState.readCache.getKeys()) {
                        forwardEndLiveLocations.add((Object)entry.getIdentity());
                    }
                    for (ReadEliminationBlockState.CacheEntry entry : mergedStates.readCache.getKeys()) {
                        forwardEndLiveLocations.remove((Object)entry.getIdentity());
                    }
                    for (LocationIdentity location : forwardEndLiveLocations) {
                        loopKilledLocations.rememberLoopKilledLocation(location);
                    }
                    if (this.debug.isLogEnabled() && loopKilledLocations != null) {
                        this.debug.log("[Early Read Elimination] Setting loop killed locations of loop at node %s with %s", (Object)loop.getHeader().getBeginNode(), (Object)forwardEndLiveLocations);
                    }
                }
                loopKilledLocations.visited();
            }
        }
    }

    @Override
    protected ReadEliminationBlockState stripKilledLoopLocations(Loop<Block> loop, ReadEliminationBlockState originalInitialState) {
        ReadEliminationBlockState initialState = super.stripKilledLoopLocations(loop, originalInitialState);
        EffectsClosure.LoopKillCache loopKilledLocations = (EffectsClosure.LoopKillCache)this.loopLocationKillCache.get(loop);
        if (loopKilledLocations != null && loopKilledLocations.loopKillsLocations()) {
            Iterator it = initialState.readCache.getKeys().iterator();
            while (it.hasNext()) {
                ReadEliminationBlockState.CacheEntry entry = (ReadEliminationBlockState.CacheEntry)it.next();
                if (!loopKilledLocations.containsLocation(entry.getIdentity())) continue;
                it.remove();
            }
        }
        return initialState;
    }

    private class ReadEliminationMergeProcessor
    extends EffectsClosure.MergeProcessor {
        private final EconomicMap<Object, ValuePhiNode> materializedPhis;

        ReadEliminationMergeProcessor(Block mergeBlock) {
            super(mergeBlock);
            this.materializedPhis = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        }

        protected ValuePhiNode getCachedPhi(ReadEliminationBlockState.CacheEntry<?> virtual, Stamp stamp) {
            ValuePhiNode result = (ValuePhiNode)this.materializedPhis.get(virtual);
            if (result == null) {
                result = this.createValuePhi(stamp);
                this.materializedPhis.put(virtual, (Object)result);
            }
            return result;
        }

        protected void merge(List<ReadEliminationBlockState> states) {
            MapCursor cursor = states.get((int)0).readCache.getEntries();
            while (cursor.advance()) {
                ReadEliminationBlockState.CacheEntry key = (ReadEliminationBlockState.CacheEntry)cursor.getKey();
                ValueNode value = (ValueNode)cursor.getValue();
                boolean phi = false;
                for (int i = 1; i < states.size(); ++i) {
                    ValueNode otherValue = (ValueNode)states.get((int)i).readCache.get((Object)key);
                    if (otherValue == null || !value.stamp(NodeView.DEFAULT).isCompatible(otherValue.stamp(NodeView.DEFAULT))) {
                        value = null;
                        phi = false;
                        break;
                    }
                    if (phi || otherValue == value) continue;
                    phi = true;
                }
                if (phi) {
                    ValuePhiNode phiNode = this.getCachedPhi(key, value.stamp(NodeView.DEFAULT).unrestricted());
                    this.mergeEffects.addFloatingNode(phiNode, "mergeReadCache");
                    for (int i = 0; i < states.size(); ++i) {
                        ValueNode v = states.get(i).getCacheEntry(key);
                        assert (phiNode.stamp(NodeView.DEFAULT).isCompatible(v.stamp(NodeView.DEFAULT))) : "Cannot create read elimination phi for inputs with incompatible stamps.";
                        this.setPhiInput(phiNode, i, v);
                    }
                    ((ReadEliminationBlockState)this.newState).addCacheEntry(key, phiNode);
                    continue;
                }
                if (value == null) continue;
                ((ReadEliminationBlockState)this.newState).addCacheEntry(key, value);
            }
            for (PhiNode phi : this.getPhis()) {
                if (phi.getStackKind() != JavaKind.Object) continue;
                for (ReadEliminationBlockState.CacheEntry entry : states.get((int)0).readCache.getKeys()) {
                    if (entry.object != this.getPhiValueAt(phi, 0)) continue;
                    this.mergeReadCachePhi(phi, entry, states);
                }
            }
        }

        private void mergeReadCachePhi(PhiNode phi, ReadEliminationBlockState.CacheEntry<?> identifier, List<ReadEliminationBlockState> states) {
            ValueNode[] values = new ValueNode[states.size()];
            values[0] = states.get(0).getCacheEntry(identifier.duplicateWithObject(this.getPhiValueAt(phi, 0)));
            if (values[0] != null) {
                for (int i = 1; i < states.size(); ++i) {
                    ValueNode value = states.get(i).getCacheEntry(identifier.duplicateWithObject(this.getPhiValueAt(phi, i)));
                    if (value == null || !values[i - 1].stamp(NodeView.DEFAULT).isCompatible(value.stamp(NodeView.DEFAULT))) {
                        return;
                    }
                    values[i] = value;
                }
                ReadEliminationBlockState.CacheEntry<?> newIdentifier = identifier.duplicateWithObject(phi);
                ValuePhiNode phiNode = this.getCachedPhi(newIdentifier, values[0].stamp(NodeView.DEFAULT).unrestricted());
                this.mergeEffects.addFloatingNode(phiNode, "mergeReadCachePhi");
                for (int i = 0; i < values.length; ++i) {
                    this.setPhiInput(phiNode, i, values[i]);
                }
                ((ReadEliminationBlockState)this.newState).addCacheEntry(newIdentifier, phiNode);
            }
        }
    }
}

