/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.virtual.phases.ea.EffectsPhase;
import org.graalvm.compiler.virtual.phases.ea.ReadEliminationClosure;
import org.graalvm.compiler.virtual.phases.ea.VirtualUtil;

public class EarlyReadEliminationPhase
extends EffectsPhase<CoreProviders> {
    private final boolean considerGuards;

    public EarlyReadEliminationPhase(CanonicalizerPhase canonicalizer) {
        super(1, canonicalizer, true);
        this.considerGuards = true;
    }

    public EarlyReadEliminationPhase(CanonicalizerPhase canonicalizer, boolean considerGuards) {
        super(1, canonicalizer, true);
        this.considerGuards = considerGuards;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (VirtualUtil.matches(graph, GraalOptions.EscapeAnalyzeOnly.getValue(graph.getOptions()))) {
            this.runAnalysis(graph, context);
        }
    }

    @Override
    protected EffectsPhase.Closure<?> createEffectsClosure(CoreProviders context, StructuredGraph.ScheduleResult schedule, ControlFlowGraph cfg) {
        assert (schedule == null);
        return new ReadEliminationClosure(cfg, this.considerGuards);
    }

    @Override
    public float codeSizeIncrease() {
        return 2.0f;
    }
}

