/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.HotSpotToSVMCalls;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMHotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMObject;
import org.graalvm.libgraal.LibGraalScope;

final class SVMTruffleCompilation
extends SVMObject
implements TruffleCompilation {
    private final SVMHotSpotTruffleCompiler owner;
    private volatile CompilableTruffleAST cachedCompilableTruffleAST;
    private volatile String cachedId;
    private final LibGraalScope scope;

    SVMTruffleCompilation(SVMHotSpotTruffleCompiler owner, long handle, LibGraalScope scope) {
        super(handle);
        this.owner = owner;
        this.scope = scope;
    }

    @Override
    public CompilableTruffleAST getCompilable() {
        CompilableTruffleAST compilable = this.cachedCompilableTruffleAST;
        if (compilable == null) {
            this.cachedCompilableTruffleAST = compilable = HotSpotToSVMCalls.getTruffleCompilationTruffleAST(LibGraalScope.getIsolateThread(), this.handle);
        }
        return compilable;
    }

    @Override
    public void close() {
        try {
            this.owner.closeCompilation(this);
            this.cachedCompilableTruffleAST = null;
        }
        finally {
            HotSpotToSVMCalls.closeCompilation(LibGraalScope.getIsolateThread(), this.handle);
            this.scope.close();
        }
    }

    String getId() {
        String id = this.cachedId;
        if (id == null) {
            this.cachedId = id = HotSpotToSVMCalls.getTruffleCompilationId(LibGraalScope.getIsolateThread(), this.handle);
        }
        return id;
    }
}

