/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.HotSpotToSVMCalls;
import org.graalvm.libgraal.LibGraalScope;

class SVMObject {
    protected final long handle;
    private static final Set<Cleaner> CLEANERS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ReferenceQueue<SVMObject> CLEANERS_QUEUE = new ReferenceQueue();

    SVMObject(long handle) {
        SVMObject.cleanHandles();
        this.handle = handle;
        Cleaner cref = new Cleaner(this, handle);
        CLEANERS.add(cref);
    }

    private static void cleanHandles() {
        Cleaner cleaner;
        while ((cleaner = (Cleaner)CLEANERS_QUEUE.poll()) != null) {
            CLEANERS.remove(cleaner);
            cleaner.clean();
        }
    }

    public String toString() {
        return String.format("%s[0x%x]", this.getClass().getSimpleName(), this.handle);
    }

    private static final class Cleaner
    extends WeakReference<SVMObject> {
        private final long handle;

        Cleaner(SVMObject referent, long handle) {
            super(referent, CLEANERS_QUEUE);
            this.handle = handle;
        }

        void clean() {
            HotSpotToSVMCalls.releaseHandle(LibGraalScope.getIsolateThread(), this.handle);
        }
    }
}

