/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.HotSpotToSVMCalls;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.IgvSupport;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMObject;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMTruffleCompilation;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.util.OptionsEncoder;

final class SVMHotSpotTruffleCompiler
extends SVMObject
implements HotSpotTruffleCompiler {
    private final Map<CompilableTruffleAST, Reference<SVMTruffleCompilation>> activeCompilations = Collections.synchronizedMap(new WeakHashMap());
    Integer pendingTransferToInterpreterOffset;

    SVMHotSpotTruffleCompiler(long handle) {
        super(handle);
    }

    @Override
    public TruffleCompilation openCompilation(CompilableTruffleAST compilable) {
        LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());
        SVMTruffleCompilation compilation = new SVMTruffleCompilation(this, HotSpotToSVMCalls.openCompilation(LibGraalScope.getIsolateThread(), this.handle, compilable), scope);
        this.activeCompilations.put(compilable, new WeakReference<SVMTruffleCompilation>(compilation));
        return compilation;
    }

    @Override
    public TruffleDebugContext openDebugContext(Map<String, Object> options, TruffleCompilation compilation) {
        return IgvSupport.create(this, options, (SVMTruffleCompilation)compilation);
    }

    @Override
    public void doCompile(TruffleDebugContext debug, TruffleCompilation compilation, Map<String, Object> options, TruffleInliningPlan inlining, TruffleCompilationTask task, TruffleCompilerListener listener) {
        byte[] encodedOptions = OptionsEncoder.encode(options);
        HotSpotToSVMCalls.doCompile(LibGraalScope.getIsolateThread(), this.handle, ((IgvSupport)debug).handle, ((SVMTruffleCompilation)compilation).handle, encodedOptions, inlining, task, listener);
    }

    @Override
    public String getCompilerConfigurationName() {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            String string = HotSpotToSVMCalls.getCompilerConfigurationName(LibGraalScope.getIsolateThread(), this.handle);
            return string;
        }
    }

    @Override
    public void shutdown() {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            HotSpotToSVMCalls.shutdown(LibGraalScope.getIsolateThread(), this.handle);
        }
    }

    @Override
    public void installTruffleCallBoundaryMethods() {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            HotSpotToSVMCalls.installTruffleCallBoundaryMethods(LibGraalScope.getIsolateThread(), this.handle);
        }
    }

    @Override
    public int pendingTransferToInterpreterOffset() {
        if (this.pendingTransferToInterpreterOffset == null) {
            try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
                this.pendingTransferToInterpreterOffset = HotSpotToSVMCalls.pendingTransferToInterpreterOffset(LibGraalScope.getIsolateThread(), this.handle);
            }
        }
        return this.pendingTransferToInterpreterOffset;
    }

    void closeCompilation(SVMTruffleCompilation compilation) {
        this.activeCompilations.remove(compilation.getCompilable());
    }

    SVMTruffleCompilation findCompilation(CompilableTruffleAST compilable) {
        Reference<SVMTruffleCompilation> compilationRef = this.activeCompilations.get(compilable);
        return compilationRef == null ? null : compilationRef.get();
    }
}

