/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.util.Map;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.AbstractHotSpotTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.HotSpotToSVMCalls;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMHotSpotTruffleCompiler;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.util.OptionsEncoder;

final class LibGraalTruffleRuntime
extends AbstractHotSpotTruffleRuntime {
    private final long handle;

    LibGraalTruffleRuntime() {
        HotSpotJVMCIRuntime runtime = HotSpotJVMCIRuntime.runtime();
        runtime.registerNativeMethods(HotSpotToSVMCalls.class);
        MetaAccessProvider metaAccess = runtime.getHostJVMCIBackend().getMetaAccess();
        HotSpotResolvedJavaType type = (HotSpotResolvedJavaType)metaAccess.lookupJavaType(this.getClass());
        try (LibGraalScope scope = new LibGraalScope(runtime);){
            long classLoaderDelegate = LibGraal.translate(runtime, type);
            this.handle = HotSpotToSVMCalls.initializeRuntime(LibGraalScope.getIsolateThread(), this, classLoaderDelegate);
        }
    }

    @Override
    public HotSpotTruffleCompiler newTruffleCompiler() {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            SVMHotSpotTruffleCompiler sVMHotSpotTruffleCompiler = new SVMHotSpotTruffleCompiler(HotSpotToSVMCalls.initializeCompiler(LibGraalScope.getIsolateThread(), this.handle));
            return sVMHotSpotTruffleCompiler;
        }
    }

    @Override
    protected String initLazyCompilerConfigurationName() {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            String string = HotSpotToSVMCalls.getCompilerConfigurationFactoryName(LibGraalScope.getIsolateThread());
            return string;
        }
    }

    @Override
    protected Map<String, Object> createInitialOptions() {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            byte[] serializedOptions = HotSpotToSVMCalls.getInitialOptions(LibGraalScope.getIsolateThread(), this.handle);
            Map<String, Object> map = OptionsEncoder.decode(serializedOptions);
            return map;
        }
    }

    @Override
    public void log(String message) {
        try (LibGraalScope scope = new LibGraalScope(HotSpotJVMCIRuntime.runtime());){
            HotSpotToSVMCalls.log(LibGraalScope.getIsolateThread(), message);
        }
    }
}

