/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleInliningDecision;
import org.graalvm.compiler.truffle.runtime.TruffleInliningProfile;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;

public final class TraceInliningListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceInliningListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceInliningListener(runtime));
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        if (TruffleRuntimeOptions.getValue(SharedTruffleRuntimeOptions.TruffleLanguageAgnosticInlining).booleanValue() || !target.getOptionValue(PolyglotCompilerOptions.TraceInlining).booleanValue() || inliningDecision == null) {
            return;
        }
        if (!target.getOptionValue(PolyglotCompilerOptions.Inlining).booleanValue()) {
            this.runtime.logEvent(0, "TruffleFunctionInlining is set to false", "", null);
            return;
        }
        this.runtime.logEvent(0, "inline start", target.toString(), target.getDebugProperties(null));
        this.logInliningDecisionRecursive(target, inliningDecision, 1);
        this.runtime.logEvent(0, "inline done", target.toString(), target.getDebugProperties(inliningDecision));
    }

    private void logInliningDecisionRecursive(OptimizedCallTarget target, TruffleInlining inliningDecision, int depth) {
        for (TruffleInliningDecision decision : inliningDecision) {
            TruffleInliningProfile profile = decision.getProfile();
            boolean inlined = decision.shouldInline();
            String msg = inlined ? "inline success" : "inline failed";
            this.runtime.logEvent(depth, msg, decision.getProfile().getCallNode().getCurrentCallTarget().toString(), profile.getDebugProperties());
            if (!inlined) continue;
            this.logInliningDecisionRecursive(target, decision, depth + 1);
        }
    }
}

