/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.TruffleDebugOptions;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleInliningDecision;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.graphio.GraphBlocks;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.graphio.GraphStructure;

public final class TruffleTreeDumper {
    private static final ASTDumpStructure AST_DUMP_STRUCTURE = new ASTDumpStructure();
    private static final CallTreeDumpStructure CALL_GRAPH_DUMP_STRUCTURE = new CallTreeDumpStructure();
    private static final String AFTER_PROFILING = "After Profiling";
    private static final String AFTER_INLINING = "After Inlining";

    private TruffleTreeDumper() {
    }

    public static void dump(TruffleDebugContext debug, OptimizedCallTarget callTarget, TruffleInlining inliningDecision) {
        if (TruffleDebugOptions.getValue(TruffleDebugOptions.PrintGraph) != TruffleDebugOptions.PrintGraphTarget.Disable && TruffleDebugOptions.getValue(TruffleDebugOptions.PrintTruffleTrees).booleanValue()) {
            try {
                TruffleTreeDumper.dumpASTAndCallTrees(debug, callTarget, inliningDecision);
            }
            catch (IOException ex) {
                throw TruffleTreeDumper.rethrowSilently(RuntimeException.class, ex);
            }
        }
    }

    private static void dumpASTAndCallTrees(TruffleDebugContext debug, OptimizedCallTarget callTarget, TruffleInlining inlining) throws IOException {
        if (callTarget.getRootNode() != null) {
            AST ast = new AST(callTarget);
            GraphOutput<AST, ?> astOutput = debug.buildOutput(GraphOutput.newBuilder(AST_DUMP_STRUCTURE).blocks(AST_DUMP_STRUCTURE).protocolVersion(6, 1));
            astOutput.beginGroup(ast, "AST", "AST", null, 0, debug.getVersionProperties());
            astOutput.print(ast, Collections.emptyMap(), 0, AFTER_PROFILING, new Object[0]);
            if (inlining.countInlinedCalls() > 0) {
                TruffleTreeDumper.dumpInlinedTrees(debug, astOutput, callTarget, inlining, new ArrayList<RootCallTarget>());
                ast.inline(inlining);
                astOutput.print(ast, null, 1, AFTER_INLINING, new Object[0]);
            }
            astOutput.endGroup();
            astOutput.close();
            if (TruffleRuntimeOptions.getValue(SharedTruffleRuntimeOptions.TruffleLanguageAgnosticInlining).booleanValue()) {
                return;
            }
            CallTree callTree = new CallTree(callTarget, null);
            GraphOutput<CallTree, ?> callTreeOutput = debug.buildOutput(GraphOutput.newBuilder(CALL_GRAPH_DUMP_STRUCTURE).blocks(CALL_GRAPH_DUMP_STRUCTURE).protocolVersion(6, 1));
            callTreeOutput.beginGroup(null, "Call Tree", "Call Tree", null, 0, debug.getVersionProperties());
            callTreeOutput.print(callTree, null, 0, AFTER_PROFILING, new Object[0]);
            if (inlining.countInlinedCalls() > 0) {
                callTree = new CallTree(callTarget, inlining);
                callTreeOutput.print(callTree, null, 0, AFTER_INLINING, new Object[0]);
            }
            callTreeOutput.endGroup();
            callTreeOutput.close();
        }
    }

    private static void dumpInlinedTrees(TruffleDebugContext debug, GraphOutput<AST, ?> output, RootCallTarget callTarget, TruffleInlining inlining, List<RootCallTarget> dumped) throws IOException {
        for (DirectCallNode callNode : NodeUtil.findAllNodeInstances((Node)callTarget.getRootNode(), DirectCallNode.class)) {
            RootCallTarget rootCallTarget;
            TruffleInliningDecision decision;
            CallTarget inlinedCallTarget = callNode.getCurrentCallTarget();
            if (!(inlinedCallTarget instanceof RootCallTarget) || !(callNode instanceof OptimizedDirectCallNode) || (decision = inlining.findByCall((OptimizedDirectCallNode)callNode)) == null || !decision.shouldInline() || dumped.contains(rootCallTarget = (RootCallTarget)inlinedCallTarget)) continue;
            AST ast = new AST(rootCallTarget);
            output.beginGroup(ast, inlinedCallTarget.toString(), rootCallTarget.getRootNode().getName(), null, 0, debug.getVersionProperties());
            output.print(ast, Collections.emptyMap(), 0, AFTER_PROFILING, new Object[0]);
            output.endGroup();
            dumped.add(rootCallTarget);
            TruffleTreeDumper.dumpInlinedTrees(debug, output, (OptimizedCallTarget)inlinedCallTarget, decision, dumped);
        }
    }

    private static <E extends Exception> E rethrowSilently(Class<E> type, Throwable ex) throws E {
        throw (Exception)ex;
    }

    private static void readNodeProperties(ASTNode astNode, Node node) {
        NodeClass nodeClass = NodeClass.get((Node)node);
        for (NodeFieldAccessor field : TruffleTreeDumper.findNodeFields(nodeClass)) {
            if (!TruffleTreeDumper.isDataField(nodeClass, field)) continue;
            String key = TruffleTreeDumper.findFieldName(nodeClass, field);
            Object value = TruffleTreeDumper.findFieldValue(nodeClass, field, node);
            astNode.properties.put(key, value);
        }
    }

    private static void copyDebugProperties(ASTNode astNode, Node node) {
        Map debugProperties = node.getDebugProperties();
        for (Map.Entry property : debugProperties.entrySet()) {
            astNode.properties.put((String)property.getKey(), property.getValue());
        }
    }

    private static LinkedHashMap<String, Node> findNamedNodeChildren(Node node) {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        NodeClass nodeClass = NodeClass.get((Node)node);
        for (NodeFieldAccessor field : TruffleTreeDumper.findNodeFields(nodeClass)) {
            Object value;
            if (TruffleTreeDumper.isChildField(nodeClass, field)) {
                value = TruffleTreeDumper.findFieldObject(nodeClass, field, node);
                if (value == null) continue;
                nodes.put(TruffleTreeDumper.findFieldName(nodeClass, field), (Node)value);
                continue;
            }
            if (!TruffleTreeDumper.isChildrenField(nodeClass, field) || (value = TruffleTreeDumper.findFieldObject(nodeClass, field, node)) == null) continue;
            Object[] children = (Object[])value;
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null) continue;
                nodes.put(TruffleTreeDumper.findFieldName(nodeClass, field) + "[" + i + "]", (Node)children[i]);
            }
        }
        return nodes;
    }

    private static Object findFieldValue(NodeClass nodeClass, NodeFieldAccessor field, Node node) {
        return field.loadValue(node);
    }

    private static Iterable<NodeFieldAccessor> findNodeFields(NodeClass nodeClass) {
        return Arrays.asList(nodeClass.getFields());
    }

    private static boolean isChildField(NodeClass nodeClass, NodeFieldAccessor field) {
        return field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD;
    }

    private static boolean isChildrenField(NodeClass nodeClass, NodeFieldAccessor field) {
        return field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN;
    }

    private static Object findFieldObject(NodeClass nodeClass, NodeFieldAccessor field, Node node) {
        return field.getObject(node);
    }

    private static String findFieldName(NodeClass nodeClass, NodeFieldAccessor field) {
        return field.getName();
    }

    private static boolean isDataField(NodeClass nodeClass, NodeFieldAccessor field) {
        return !TruffleTreeDumper.isChildField(nodeClass, field) && !TruffleTreeDumper.isChildrenField(nodeClass, field);
    }

    static class CallTreeDumpStructure
    implements GraphStructure<CallTree, CallTreeNode, CallTreeNode.CallTreeClass, List<CallTreeEdge>>,
    GraphBlocks<CallTree, CallTreeBlock, CallTreeNode> {
        CallTreeDumpStructure() {
        }

        @Override
        public CallTree graph(CallTree currentGraph, Object obj) {
            return obj instanceof CallTree ? (CallTree)obj : null;
        }

        @Override
        public Iterable<? extends CallTreeNode> nodes(CallTree graph) {
            return graph.nodes;
        }

        @Override
        public int nodesCount(CallTree graph) {
            return graph.nodes.size();
        }

        @Override
        public int nodeId(CallTreeNode node) {
            return node.id;
        }

        @Override
        public boolean nodeHasPredecessor(CallTreeNode node) {
            return false;
        }

        @Override
        public void nodeProperties(CallTree graph, CallTreeNode node, Map<String, ? super Object> properties) {
            properties.putAll(node.properties);
        }

        @Override
        public CallTreeNode node(Object obj) {
            return obj instanceof CallTreeNode ? (CallTreeNode)obj : null;
        }

        @Override
        public CallTreeNode.CallTreeClass nodeClass(Object obj) {
            return obj instanceof CallTreeNode.CallTreeClass ? (CallTreeNode.CallTreeClass)obj : null;
        }

        @Override
        public CallTreeNode.CallTreeClass classForNode(CallTreeNode node) {
            return node.c;
        }

        @Override
        public String nameTemplate(CallTreeNode.CallTreeClass nodeClass) {
            return "{p#label}";
        }

        @Override
        public Object nodeClassType(CallTreeNode.CallTreeClass nodeClass) {
            return nodeClass.getNode().source.getClass();
        }

        @Override
        public List<CallTreeEdge> portInputs(CallTreeNode.CallTreeClass nodeClass) {
            return Collections.emptyList();
        }

        @Override
        public List<CallTreeEdge> portOutputs(CallTreeNode.CallTreeClass nodeClass) {
            return nodeClass.getNode().edges;
        }

        @Override
        public int portSize(List<CallTreeEdge> port) {
            return port.size();
        }

        @Override
        public boolean edgeDirect(List<CallTreeEdge> port, int index) {
            return true;
        }

        @Override
        public String edgeName(List<CallTreeEdge> port, int index) {
            return "";
        }

        @Override
        public Object edgeType(List<CallTreeEdge> port, int index) {
            return port.get((int)index).label;
        }

        @Override
        public Collection<? extends CallTreeNode> edgeNodes(CallTree graph, CallTreeNode node, List<CallTreeEdge> port, int index) {
            ArrayList<CallTreeNode> singleton = new ArrayList<CallTreeNode>(1);
            singleton.add(port.get((int)index).target);
            return singleton;
        }

        @Override
        public Collection<? extends CallTreeBlock> blocks(CallTree graph) {
            return Arrays.asList(graph.inlined, graph.notInlined);
        }

        @Override
        public int blockId(CallTreeBlock block) {
            return block.id;
        }

        @Override
        public Collection<? extends CallTreeNode> blockNodes(CallTree info, CallTreeBlock block) {
            return block.nodes;
        }

        @Override
        public Collection<? extends CallTreeBlock> blockSuccessors(CallTreeBlock block) {
            return Collections.emptyList();
        }
    }

    static class CallTreeBlock {
        final int id;
        final List<CallTreeNode> nodes = new ArrayList<CallTreeNode>();

        CallTreeBlock(int id) {
            this.id = id;
        }
    }

    static class CallTreeEdge {
        final CallTreeNode target;
        final String label;

        CallTreeEdge(CallTreeNode target, String label) {
            this.target = target;
            this.label = label;
        }
    }

    static class CallTreeNode {
        final CallTarget source;
        List<CallTreeEdge> edges = new ArrayList<CallTreeEdge>();
        final int id;
        final Map<String, ? super Object> properties = new HashMap<String, Object>();
        final CallTreeClass c = new CallTreeClass();

        CallTreeNode(CallTarget source, int id) {
            this.source = source;
            this.id = id;
        }

        class CallTreeClass {
            CallTreeClass() {
            }

            CallTreeNode getNode() {
                return CallTreeNode.this;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CallTreeClass)) {
                    return false;
                }
                CallTreeClass other = (CallTreeClass)obj;
                return other.getNode() == CallTreeNode.this;
            }

            public int hashCode() {
                return CallTreeNode.this.hashCode();
            }
        }
    }

    static class CallTree {
        final CallTreeNode root;
        final List<CallTreeNode> nodes = new ArrayList<CallTreeNode>();
        final CallTreeBlock inlined = new CallTreeBlock(0);
        final CallTreeBlock notInlined = new CallTreeBlock(1);

        CallTree(RootCallTarget target, TruffleInlining inlining) {
            this.root = this.makeCallTreeNode((CallTarget)target);
            this.inlined.nodes.add(this.root);
            this.root.properties.put("label", target.toString());
            this.root.properties.putAll(((OptimizedCallTarget)target).getDebugProperties(null));
            CallTree.build(target, this.root, inlining, this);
        }

        private static void build(RootCallTarget target, CallTreeNode parent, TruffleInlining inlining, CallTree graph) {
            if (inlining == null) {
                for (DirectCallNode callNode : NodeUtil.findAllNodeInstances((Node)target.getRootNode(), DirectCallNode.class)) {
                    CallTarget inlinedCallTarget = callNode.getCurrentCallTarget();
                    CallTreeNode callTreeNode = graph.makeCallTreeNode(inlinedCallTarget);
                    parent.edges.add(new CallTreeEdge(callTreeNode, ""));
                    graph.notInlined.nodes.add(callTreeNode);
                    callTreeNode.properties.put("label", inlinedCallTarget.toString());
                    callTreeNode.properties.put("inlined", "false");
                }
            } else {
                ArrayList<RootCallTarget> furtherTargets = new ArrayList<RootCallTarget>();
                ArrayList<CallTreeNode> furtherParent = new ArrayList<CallTreeNode>();
                ArrayList<TruffleInliningDecision> furtherDecisions = new ArrayList<TruffleInliningDecision>();
                for (DirectCallNode callNode : NodeUtil.findAllNodeInstances((Node)target.getRootNode(), DirectCallNode.class)) {
                    CallTarget inlinedCallTarget = callNode.getCurrentCallTarget();
                    if (!(inlinedCallTarget instanceof OptimizedCallTarget) || !(callNode instanceof OptimizedDirectCallNode)) continue;
                    TruffleInliningDecision decision = inlining.findByCall((OptimizedDirectCallNode)callNode);
                    CallTreeNode callTreeNode = graph.makeCallTreeNode(inlinedCallTarget);
                    callTreeNode.properties.put("label", inlinedCallTarget.toString());
                    parent.edges.add(new CallTreeEdge(callTreeNode, ""));
                    if (decision != null && decision.shouldInline()) {
                        graph.inlined.nodes.add(callTreeNode);
                        callTreeNode.properties.put("inlined", "true");
                        callTreeNode.properties.putAll(decision.getProfile().getDebugProperties());
                        furtherTargets.add((RootCallTarget)inlinedCallTarget);
                        furtherParent.add(callTreeNode);
                        furtherDecisions.add(decision);
                        continue;
                    }
                    callTreeNode.properties.put("inlined", "false");
                    if (decision != null) {
                        callTreeNode.properties.putAll(decision.getTarget().getDebugProperties(decision));
                    }
                    graph.notInlined.nodes.add(callTreeNode);
                }
                for (int i = 0; i < furtherTargets.size(); ++i) {
                    CallTree.build((RootCallTarget)furtherTargets.get(i), (CallTreeNode)furtherParent.get(i), (TruffleInlining)furtherDecisions.get(i), graph);
                }
            }
        }

        CallTreeNode makeCallTreeNode(CallTarget source) {
            CallTreeNode callTreeNode = new CallTreeNode(source, this.nodes.size());
            this.nodes.add(callTreeNode);
            return callTreeNode;
        }
    }

    static class ASTDumpStructure
    implements GraphStructure<AST, ASTNode, ASTNodeClass, List<ASTEdge>>,
    GraphBlocks<AST, ASTBlock, ASTNode> {
        ASTDumpStructure() {
        }

        @Override
        public AST graph(AST currentGraph, Object obj) {
            return obj instanceof AST ? (AST)obj : null;
        }

        @Override
        public Iterable<? extends ASTNode> nodes(AST graph) {
            return graph.nodes;
        }

        @Override
        public int nodesCount(AST graph) {
            return graph.nodes.size();
        }

        @Override
        public int nodeId(ASTNode node) {
            return node.id;
        }

        @Override
        public boolean nodeHasPredecessor(ASTNode node) {
            return false;
        }

        @Override
        public void nodeProperties(AST graph, ASTNode node, Map<String, ? super Object> properties) {
            properties.putAll(node.properties);
        }

        @Override
        public ASTNode node(Object obj) {
            return obj instanceof ASTNode ? (ASTNode)obj : null;
        }

        @Override
        public ASTNodeClass nodeClass(Object obj) {
            return obj instanceof ASTNodeClass ? (ASTNodeClass)obj : null;
        }

        @Override
        public ASTNodeClass classForNode(ASTNode node) {
            return node.nodeClass;
        }

        @Override
        public String nameTemplate(ASTNodeClass nodeClass) {
            return "{p#label}";
        }

        @Override
        public Object nodeClassType(ASTNodeClass nodeClass) {
            return nodeClass.node.source.getClass();
        }

        @Override
        public List<ASTEdge> portInputs(ASTNodeClass nodeClass) {
            return Collections.emptyList();
        }

        @Override
        public List<ASTEdge> portOutputs(ASTNodeClass nodeClass) {
            return nodeClass.node.edges;
        }

        @Override
        public int portSize(List<ASTEdge> port) {
            return port.size();
        }

        @Override
        public boolean edgeDirect(List<ASTEdge> port, int index) {
            return true;
        }

        @Override
        public String edgeName(List<ASTEdge> port, int index) {
            return port.get((int)index).label;
        }

        @Override
        public Object edgeType(List<ASTEdge> port, int index) {
            return EdgeType.EDGE_TYPE;
        }

        @Override
        public Collection<? extends ASTNode> edgeNodes(AST graph, ASTNode node, List<ASTEdge> port, int index) {
            ArrayList<ASTNode> singleton = new ArrayList<ASTNode>(1);
            singleton.add(port.get((int)index).node);
            return singleton;
        }

        @Override
        public Collection<? extends ASTBlock> blocks(AST graph) {
            return graph.blocks;
        }

        @Override
        public int blockId(ASTBlock block) {
            return block.id;
        }

        @Override
        public Collection<? extends ASTNode> blockNodes(AST info, ASTBlock block) {
            return block.nodes;
        }

        @Override
        public Collection<? extends ASTBlock> blockSuccessors(ASTBlock block) {
            return block.successors;
        }
    }

    static class ASTBlock {
        final int id;
        final List<ASTBlock> successors = new ArrayList<ASTBlock>();
        final List<ASTNode> nodes = new ArrayList<ASTNode>();

        ASTBlock(int id) {
            this.id = id;
        }
    }

    static class ASTNodeClass {
        final ASTNode node;

        ASTNodeClass(ASTNode node) {
            this.node = node;
        }
    }

    static enum EdgeType {
        EDGE_TYPE;

    }

    static class ASTEdge {
        final ASTNode node;
        final String label;

        ASTEdge(ASTNode node, String label) {
            this.node = node;
            this.label = label;
        }
    }

    static class ASTNode {
        Node source;
        List<ASTEdge> edges = new ArrayList<ASTEdge>();
        final int id;
        Map<String, ? super Object> properties = new HashMap<String, Object>();
        ASTNodeClass nodeClass;

        ASTNode(Node source, int id) {
            this.source = source;
            this.id = id;
            this.setNewClass();
            ASTNode.setBasicProperties(this.properties, source);
            TruffleTreeDumper.readNodeProperties(this, source);
            TruffleTreeDumper.copyDebugProperties(this, source);
        }

        private static void setBasicProperties(Map<String, ? super Object> properties, Node source) {
            String className = ASTNode.className(source.getClass());
            properties.put("label", ASTNode.dropNodeSuffix(className));
            properties.put("cost", source.getCost());
            NodeInfo nodeInfo = source.getClass().getAnnotation(NodeInfo.class);
            if (nodeInfo != null && !nodeInfo.shortName().isEmpty()) {
                properties.put("shortName", nodeInfo.shortName());
            }
            if (Introspection.isIntrospectable((Node)source)) {
                List specializations = Introspection.getSpecializations((Node)source);
                for (Introspection.SpecializationInfo specialization : specializations) {
                    String methodName = specialization.getMethodName();
                    properties.put(methodName + ".isActive", (Object)specialization.isActive());
                    properties.put(methodName + ".isExcluded", (Object)specialization.isExcluded());
                    properties.put(methodName + ".instances", (Object)specialization.getInstances());
                    for (int i = 0; i < specialization.getInstances(); ++i) {
                        List cachedData = specialization.getCachedData(i);
                        for (Object o : cachedData) {
                            properties.put(methodName + "-cachedData[" + i + "]", o);
                        }
                    }
                }
            }
        }

        static String className(Class<?> clazz) {
            String name = clazz.getName();
            return name.substring(name.lastIndexOf(46) + 1);
        }

        private static String dropNodeSuffix(String className) {
            return className.replaceFirst("Node$", "");
        }

        void setNewClass() {
            this.nodeClass = new ASTNodeClass(this);
        }
    }

    static class AST {
        final ASTNode root;
        final List<ASTNode> nodes = new ArrayList<ASTNode>();
        final List<ASTBlock> blocks = new ArrayList<ASTBlock>();

        AST(RootCallTarget target) {
            ASTBlock astBlock = this.makeASTBlock();
            RootNode rootNode = target.getRootNode();
            this.root = this.makeASTNode((Node)rootNode);
            astBlock.nodes.add(this.root);
            AST.traverseNodes((Node)rootNode, this.root, this, null, astBlock);
        }

        ASTNode makeASTNode(Node source) {
            ASTNode astNode = new ASTNode(source, this.nodes.size());
            this.nodes.add(astNode);
            return astNode;
        }

        ASTNode findASTNode(Node source) {
            for (ASTNode node : this.nodes) {
                if (node.source != source) continue;
                return node;
            }
            return null;
        }

        ASTBlock makeASTBlock() {
            ASTBlock astBlock = new ASTBlock(this.blocks.size());
            this.blocks.add(astBlock);
            return astBlock;
        }

        void inline(TruffleInlining inliningDecisions) {
            AST.traverseSeenNodes(this.root.source, this.root, this, inliningDecisions, this.blocks.get(0));
        }

        private static void traverseSeenNodes(Node parent, ASTNode astParent, AST ast, TruffleInlining inliningDecisions, ASTBlock currentBlock) {
            for (Map.Entry entry : TruffleTreeDumper.findNamedNodeChildren(parent).entrySet()) {
                String label = (String)entry.getKey();
                Node node = (Node)entry.getValue();
                ASTNode seenAstNode = ast.findASTNode(node);
                if (seenAstNode == null) {
                    ASTNode astNode = ast.makeASTNode(node);
                    currentBlock.nodes.add(astNode);
                    astParent.edges.add(new ASTEdge(astNode, label));
                    AST.handleCallNodes(ast, inliningDecisions, node, astNode, currentBlock);
                    AST.traverseSeenNodes(node, astNode, ast, inliningDecisions, currentBlock);
                    continue;
                }
                AST.handleCallNodes(ast, inliningDecisions, node, seenAstNode, currentBlock);
                AST.traverseSeenNodes(node, seenAstNode, ast, inliningDecisions, currentBlock);
            }
        }

        private static void traverseNodes(Node parent, ASTNode astParent, AST ast, TruffleInlining inliningDecisions, ASTBlock currentBlock) {
            for (Map.Entry entry : TruffleTreeDumper.findNamedNodeChildren(parent).entrySet()) {
                String label = (String)entry.getKey();
                Node node = (Node)entry.getValue();
                ASTNode astNode = ast.makeASTNode(node);
                currentBlock.nodes.add(astNode);
                astParent.edges.add(new ASTEdge(astNode, label));
                AST.handleCallNodes(ast, inliningDecisions, node, astNode, currentBlock);
                AST.traverseNodes(node, astNode, ast, inliningDecisions, currentBlock);
            }
        }

        private static void handleCallNodes(AST ast, TruffleInlining inliningDecisions, Node node, ASTNode astNode, ASTBlock currentBlock) {
            TruffleInliningDecision decision;
            DirectCallNode callNode;
            CallTarget inlinedCallTarget;
            if (astNode.edges.size() > 0) {
                return;
            }
            if (inliningDecisions != null && node instanceof DirectCallNode && (inlinedCallTarget = (callNode = (DirectCallNode)node).getCurrentCallTarget()) instanceof OptimizedCallTarget && callNode instanceof OptimizedDirectCallNode && (decision = inliningDecisions.findByCall((OptimizedDirectCallNode)callNode)) != null && decision.shouldInline()) {
                RootNode targetRootNode = ((OptimizedCallTarget)inlinedCallTarget).getRootNode();
                ASTNode astTargetRootNode = ast.makeASTNode((Node)targetRootNode);
                astNode.edges.add(new ASTEdge(astTargetRootNode, inlinedCallTarget.toString()));
                astNode.setNewClass();
                ASTBlock newBlock = ast.makeASTBlock();
                if (currentBlock != null) {
                    currentBlock.successors.add(newBlock);
                }
                newBlock.nodes.add(astTargetRootNode);
                AST.traverseNodes((Node)targetRootNode, astTargetRootNode, ast, decision, newBlock);
            }
        }
    }
}

