/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.RuntimeOptionsCache;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptions;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;

final class TruffleSplittingStrategy {
    private static final Set<OptimizedCallTarget> waste = Collections.synchronizedSet(new HashSet());
    private static final int LEGACY_RECURSIVE_SPLIT_DEPTH = 2;
    private static final int RECURSIVE_SPLIT_DEPTH = 3;

    TruffleSplittingStrategy() {
    }

    static void beforeCall(OptimizedDirectCallNode call) {
        EngineData engineData = call.getCurrentCallTarget().engineData;
        if (engineData.options.isTraceSplittingSummary() && call.getCurrentCallTarget().getCompilationProfile().getCallCount() == 0) {
            engineData.reporter.totalExecutedNodeCount += call.getCurrentCallTarget().getUninitializedNodeCount();
        }
        if (engineData.options.isLegacySplitting()) {
            if (call.getCallCount() == 2 && TruffleSplittingStrategy.legacyShouldSplit(call, engineData)) {
                engineData.splitCount += call.getCurrentCallTarget().getUninitializedNodeCount();
                TruffleSplittingStrategy.doSplit(engineData, call);
            }
            return;
        }
        if (TruffleSplittingStrategy.shouldSplit(engineData.options, call)) {
            engineData.splitCount += call.getCallTarget().getUninitializedNodeCount();
            TruffleSplittingStrategy.doSplit(engineData, call);
        }
    }

    private static EngineData getEngineData(OptimizedDirectCallNode callNode) {
        return GraalTVMCI.getEngineData(callNode.getCallTarget().getRootNode());
    }

    private static void doSplit(EngineData engineData, OptimizedDirectCallNode call) {
        RuntimeOptionsCache options = engineData.options;
        if (options.isTraceSplittingSummary()) {
            TruffleSplittingStrategy.calculateSplitWasteImpl(call.getCurrentCallTarget());
        }
        call.split();
        if (options.isTraceSplittingSummary()) {
            engineData.reporter.splitNodeCount += call.getCurrentCallTarget().getUninitializedNodeCount();
            ++engineData.reporter.splitCount;
            engineData.reporter.splitTargets.put(call.getCallTarget(), engineData.reporter.splitTargets.getOrDefault(call.getCallTarget(), 0) + 1);
        }
    }

    private static boolean shouldSplit(RuntimeOptionsCache options, OptimizedDirectCallNode call) {
        OptimizedCallTarget callTarget = call.getCurrentCallTarget();
        if (!callTarget.isNeedsSplit()) {
            return false;
        }
        EngineData engineData = TruffleSplittingStrategy.getEngineData(call);
        if (!TruffleSplittingStrategy.canSplit(options, call) || TruffleSplittingStrategy.isRecursiveSplit(call, 3) || engineData.splitCount + call.getCallTarget().getUninitializedNodeCount() >= engineData.splitLimit) {
            return false;
        }
        return callTarget.getUninitializedNodeCount() <= options.getSplittingMaxCalleeSize();
    }

    static void forceSplitting(OptimizedDirectCallNode call) {
        EngineData engineData = TruffleSplittingStrategy.getEngineData(call);
        RuntimeOptionsCache options = engineData.options;
        if (options.isLegacySplitting() || options.isSplittingAllowForcedSplits()) {
            if (!TruffleSplittingStrategy.canSplit(options, call) || TruffleSplittingStrategy.isRecursiveSplit(call, 2)) {
                return;
            }
            engineData.splitCount += call.getCurrentCallTarget().getUninitializedNodeCount();
            TruffleSplittingStrategy.doSplit(engineData, call);
            if (options.isTraceSplittingSummary()) {
                ++engineData.reporter.forcedSplitCount;
            }
        }
    }

    private static boolean canSplit(RuntimeOptionsCache options, OptimizedDirectCallNode call) {
        if (call.isCallTargetCloned()) {
            return false;
        }
        if (!options.isSplitting()) {
            return false;
        }
        return call.isCallTargetCloningAllowed();
    }

    private static boolean legacyShouldSplit(OptimizedDirectCallNode call, EngineData engineData) {
        if (((Boolean)SharedTruffleRuntimeOptions.TruffleMultiTier.getValue(TruffleRuntimeOptions.getOptions())).booleanValue()) {
            return false;
        }
        if (engineData.splitCount + call.getCurrentCallTarget().getUninitializedNodeCount() > engineData.splitLimit) {
            return false;
        }
        if (!TruffleSplittingStrategy.canSplit(engineData.options, call)) {
            return false;
        }
        OptimizedCallTarget callTarget = call.getCallTarget();
        int nodeCount = callTarget.getUninitializedNodeCount();
        if (nodeCount > engineData.options.getSplittingMaxCalleeSize()) {
            return false;
        }
        RootNode rootNode = call.getRootNode();
        if (rootNode == null) {
            return false;
        }
        OptimizedCallTarget root = (OptimizedCallTarget)rootNode.getCallTarget();
        if (root == callTarget || root != null && root.getSourceCallTarget() == callTarget) {
            return false;
        }
        if (TruffleSplittingStrategy.isRecursiveSplit(call, 2)) {
            return false;
        }
        if (TruffleSplittingStrategy.isMaxSingleCall(call)) {
            return true;
        }
        return TruffleSplittingStrategy.countPolymorphic(call) >= 1;
    }

    private static boolean isRecursiveSplit(OptimizedDirectCallNode call, int allowedDepth) {
        OptimizedCallTarget splitCandidateTarget = call.getCallTarget();
        RootNode rootNode = call.getRootNode();
        if (rootNode == null) {
            return false;
        }
        OptimizedCallTarget callRootTarget = (OptimizedCallTarget)rootNode.getCallTarget();
        if (callRootTarget == null) {
            return false;
        }
        OptimizedCallTarget callSourceTarget = callRootTarget.getSourceCallTarget();
        int depth = 0;
        while (callSourceTarget != null) {
            RootNode splitCallSiteRootNode;
            if (callSourceTarget == splitCandidateTarget && ++depth == allowedDepth) {
                return true;
            }
            OptimizedDirectCallNode splitCallSite = callRootTarget.getCallSiteForSplit();
            if (splitCallSite == null || (splitCallSiteRootNode = splitCallSite.getRootNode()) == null || (callRootTarget = (OptimizedCallTarget)splitCallSiteRootNode.getCallTarget()) == null) break;
            callSourceTarget = callRootTarget.getSourceCallTarget();
        }
        return false;
    }

    private static boolean isMaxSingleCall(OptimizedDirectCallNode call) {
        return NodeUtil.countNodes((Node)call.getCallTarget().getRootNode(), (NodeUtil.NodeCountFilter)new NodeUtil.NodeCountFilter(){

            public boolean isCounted(Node node) {
                return node instanceof DirectCallNode;
            }
        }) <= 1;
    }

    private static int countPolymorphic(OptimizedDirectCallNode call) {
        return NodeUtil.countNodes((Node)call.getCallTarget().getRootNode(), (NodeUtil.NodeCountFilter)new NodeUtil.NodeCountFilter(){

            public boolean isCounted(Node node) {
                NodeCost cost = node.getCost();
                boolean polymorphic = cost == NodeCost.POLYMORPHIC || cost == NodeCost.MEGAMORPHIC;
                return polymorphic;
            }
        });
    }

    static void newTargetCreated(RootCallTarget target) {
        OptimizedCallTarget callTarget = (OptimizedCallTarget)target;
        EngineData engineData = callTarget.engineData;
        RuntimeOptionsCache runtimeOptionsCache = engineData.options;
        if (runtimeOptionsCache.isSplitting()) {
            int newLimit = (int)((double)engineData.splitLimit + runtimeOptionsCache.getSplittingGrowthLimit() * (double)callTarget.getUninitializedNodeCount());
            engineData.splitLimit = Math.min(newLimit, runtimeOptionsCache.getSplittingMaxNumberOfSplitNodes());
        }
        if (runtimeOptionsCache.isTraceSplittingSummary()) {
            engineData.reporter.totalCreatedNodeCount += callTarget.getUninitializedNodeCount();
        }
    }

    private static void calculateSplitWasteImpl(OptimizedCallTarget callTarget) {
        List callNodes = NodeUtil.findAllNodeInstances((Node)callTarget.getRootNode(), OptimizedDirectCallNode.class);
        callNodes.removeIf(callNode -> !callNode.isCallTargetCloned());
        for (OptimizedDirectCallNode node : callNodes) {
            OptimizedCallTarget clonedCallTarget = node.getClonedCallTarget();
            if (!waste.add(clonedCallTarget)) continue;
            EngineData engineData = clonedCallTarget.engineData;
            ++engineData.reporter.wastedTargetCount;
            engineData.reporter.wastedNodeCount += clonedCallTarget.getUninitializedNodeCount();
            TruffleSplittingStrategy.calculateSplitWasteImpl(clonedCallTarget);
        }
    }

    static void newPolymorphicSpecialize(Node node, EngineData engineData) {
        if (engineData.options.isTraceSplittingSummary()) {
            Map<Class<? extends Node>, Integer> polymorphicNodes = engineData.reporter.polymorphicNodes;
            Class<?> aClass = node.getClass();
            polymorphicNodes.put(aClass, polymorphicNodes.getOrDefault(aClass, 0) + 1);
        }
    }

    static void newDirectCallNodeCreated(OptimizedDirectCallNode directCallNode) {
        OptimizedCallTarget callTarget = directCallNode.getCallTarget();
        if (callTarget.engineData.options.isLegacySplitting()) {
            return;
        }
        callTarget.addKnownCallNode(directCallNode);
    }

    static class SplitStatisticsReporter
    extends Thread {
        final Map<Class<? extends Node>, Integer> polymorphicNodes = new HashMap<Class<? extends Node>, Integer>();
        final Map<OptimizedCallTarget, Integer> splitTargets = new HashMap<OptimizedCallTarget, Integer>();
        private final EngineData engineData;
        int splitCount;
        int forcedSplitCount;
        int splitNodeCount;
        int totalExecutedNodeCount;
        int totalCreatedNodeCount;
        int wastedNodeCount;
        int wastedTargetCount;
        static final String D_FORMAT = "[truffle] %-40s: %10d";
        static final String D_LONG_FORMAT = "[truffle] %-120s: %10d";
        static final String P_FORMAT = "[truffle] %-40s: %9.2f%%";
        static final String DELIMITER_FORMAT = "%n[truffle] --- %s";

        SplitStatisticsReporter(EngineData engineData) {
            this.engineData = engineData;
            if (engineData.options.isTraceSplittingSummary()) {
                Runtime.getRuntime().addShutdownHook(this);
            }
        }

        @Override
        public void run() {
            GraalTruffleRuntime rt = GraalTruffleRuntime.getRuntime();
            rt.log(String.format(D_FORMAT, "Split count", this.engineData.splitCount));
            rt.log(String.format(D_FORMAT, "Split limit", this.engineData.splitLimit));
            rt.log(String.format(D_FORMAT, "Splits", this.splitCount));
            rt.log(String.format(D_FORMAT, "Forced splits", this.forcedSplitCount));
            rt.log(String.format(D_FORMAT, "Nodes created through splitting", this.splitNodeCount));
            rt.log(String.format(D_FORMAT, "Nodes created without splitting", this.totalCreatedNodeCount));
            rt.log(String.format(P_FORMAT, "Increase in nodes", (double)this.splitNodeCount * 100.0 / (double)this.totalCreatedNodeCount));
            rt.log(String.format(D_FORMAT, "Split nodes wasted", this.wastedNodeCount));
            rt.log(String.format(P_FORMAT, "Percent of split nodes wasted", (double)this.wastedNodeCount * 100.0 / (double)this.splitNodeCount));
            rt.log(String.format(D_FORMAT, "Targets wasted due to splitting", this.wastedTargetCount));
            rt.log(String.format(D_FORMAT, "Total nodes executed", this.totalExecutedNodeCount));
            rt.log(String.format(DELIMITER_FORMAT, "SPLIT TARGETS"));
            for (Map.Entry<OptimizedCallTarget, Integer> entry : SplitStatisticsReporter.sortByIntegerValue(this.splitTargets).entrySet()) {
                rt.log(String.format(D_FORMAT, entry.getKey(), entry.getValue()));
            }
            rt.log(String.format(DELIMITER_FORMAT, "NODES"));
            for (Map.Entry<Object, Integer> entry : SplitStatisticsReporter.sortByIntegerValue(this.polymorphicNodes).entrySet()) {
                rt.log(String.format(D_LONG_FORMAT, entry.getKey(), entry.getValue()));
            }
        }

        public static <K, T> Map<K, Integer> sortByIntegerValue(Map<K, Integer> map) {
            ArrayList<Map.Entry<K, Integer>> list = new ArrayList<Map.Entry<K, Integer>>(map.entrySet());
            list.sort((x, y) -> ((Integer)y.getValue()).compareTo((Integer)x.getValue()));
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : list) {
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }
}

