/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.common.NativeImageReinitialize;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.truffle.common.SharedTruffleOptions;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptionValuesImpl;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.SharedTruffleRuntimeOptionsOptionDescriptors;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

@SharedTruffleOptions(name="SharedTruffleRuntimeOptions", runtime=true)
public final class TruffleRuntimeOptions {
    @NativeImageReinitialize
    private static volatile OptionValuesImpl optionValues;

    private TruffleRuntimeOptions() {
        throw new IllegalStateException("No instance allowed.");
    }

    private static OptionValuesImpl getInitialOptions() {
        OptionValuesImpl result = optionValues;
        if (result == null) {
            EconomicMap valuesMap = EconomicMap.create();
            SharedTruffleRuntimeOptionsOptionDescriptors descriptors = new SharedTruffleRuntimeOptionsOptionDescriptors();
            for (Map.Entry<String, Object> e : TruffleCompilerRuntime.getRuntime().getOptions().entrySet()) {
                OptionDescriptor descriptor = descriptors.get(e.getKey());
                OptionKey k = descriptor != null ? descriptor.getKey() : null;
                if (k == null) continue;
                valuesMap.put((Object)k, e.getValue());
            }
            optionValues = result = new OptionValuesImpl(descriptors, (UnmodifiableEconomicMap<OptionKey<?>, Object>)valuesMap);
        }
        return result;
    }

    public static OptionValues getOptions() {
        TruffleRuntimeOptionsOverrideScope scope = Lazy.overrideScope.get();
        return scope != null ? scope.options : TruffleRuntimeOptions.getInitialOptions();
    }

    public static OptionValues getCurrentOptionOverrides() {
        TruffleRuntimeOptionsOverrideScope scope = Lazy.overrideScope.get();
        return scope != null ? scope.options : null;
    }

    public static Map<String, Object> getOptionsForCompiler() {
        OptionValues values = TruffleRuntimeOptions.getOptions();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OptionDescriptor desc : values.getDescriptors()) {
            OptionKey key = desc.getKey();
            if (!values.hasBeenSet(key)) continue;
            map.put(desc.getName(), values.get(key));
        }
        return map;
    }

    public static <T> T getValue(OptionKey<T> key) {
        return (T)key.getValue(TruffleRuntimeOptions.getOptions());
    }

    public static TruffleRuntimeOptionsOverrideScope overrideOptions(OptionValues values) {
        return new TruffleRuntimeOptionsOverrideScope((UnmodifiableEconomicMap<OptionKey<?>, Object>)TruffleRuntimeOptions.asEconomicMap(values));
    }

    public static TruffleRuntimeOptionsOverrideScope overrideOptions(OptionKey<?> key1, Object value1, Object ... extraOverrides) {
        EconomicMap map = EconomicMap.create();
        map.put(key1, value1);
        if ((extraOverrides.length & 1) == 1) {
            throw new IllegalArgumentException("extraOverrides.length must be even: " + extraOverrides.length);
        }
        for (int i = 0; i < extraOverrides.length; i += 2) {
            map.put((Object)((OptionKey)extraOverrides[i]), extraOverrides[i + 1]);
        }
        return new TruffleRuntimeOptionsOverrideScope((UnmodifiableEconomicMap<OptionKey<?>, Object>)map);
    }

    private static EconomicMap<OptionKey<?>, Object> asEconomicMap(OptionValues values) {
        EconomicMap map = EconomicMap.create();
        for (OptionDescriptor desc : values.getDescriptors()) {
            OptionKey key = desc.getKey();
            if (!values.hasBeenSet(key)) continue;
            map.put((Object)key, values.get(key));
        }
        return map;
    }

    public static boolean areTruffleCompilationExceptionsFatal(OptimizedCallTarget target) {
        boolean compilationExceptionsAreFatal = target.getOptionValue(PolyglotCompilerOptions.CompilationExceptionsAreFatal);
        boolean performanceWarningsAreFatal = target.getOptionValue(PolyglotCompilerOptions.PerformanceWarningsAreFatal);
        return compilationExceptionsAreFatal || performanceWarningsAreFatal;
    }

    public static class TruffleRuntimeOptionsOverrideScope
    implements AutoCloseable {
        private final TruffleRuntimeOptionsOverrideScope outer = Lazy.overrideScope.get();
        private final OptionValuesImpl options;

        TruffleRuntimeOptionsOverrideScope(UnmodifiableEconomicMap<OptionKey<?>, Object> overrides) {
            this.options = new OptionValuesImpl(this.outer == null ? TruffleRuntimeOptions.getInitialOptions() : this.outer.options, overrides);
            Lazy.overrideScope.set(this);
        }

        @Override
        public void close() {
            Lazy.overrideScope.set(this.outer);
        }
    }

    static class Lazy {
        static final ThreadLocal<TruffleRuntimeOptionsOverrideScope> overrideScope = new ThreadLocal();

        Lazy() {
        }
    }
}

