/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerOptions;
import org.graalvm.compiler.truffle.runtime.DefaultInliningPolicy;
import org.graalvm.compiler.truffle.runtime.NoInliningPolicy;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.TruffleInliningProfile;
import org.graalvm.options.OptionKey;

public interface TruffleInliningPolicy {
    public boolean isAllowed(TruffleInliningProfile var1, int var2, CompilerOptions var3);

    public double calculateScore(TruffleInliningProfile var1);

    public static TruffleInliningPolicy getInliningPolicy() {
        return new DefaultInliningPolicy();
    }

    public static TruffleInliningPolicy getNoInliningPolicy() {
        return new NoInliningPolicy();
    }

    public static enum FailedReason {
        REASON_RECURSION("number of recursions > ", PolyglotCompilerOptions.InliningRecursionDepth),
        REASON_MAXIMUM_NODE_COUNT("deepNodeCount * callSites > ", PolyglotCompilerOptions.InliningNodeBudget),
        REASON_MAXIMUM_TOTAL_NODE_COUNT("totalNodeCount > ", PolyglotCompilerOptions.InliningNodeBudget);

        private final String start;
        private final OptionKey<Integer> option;

        private FailedReason(String start, OptionKey<Integer> option) {
            this.start = start;
            this.option = option;
        }

        String format(OptimizedCallTarget target) {
            return this.start + target.getOptionValue(this.option);
        }
    }
}

