/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleInliningProfile;

public final class TruffleInliningDecision
extends TruffleInlining
implements Comparable<TruffleInliningDecision>,
TruffleInliningPlan.Decision {
    private final OptimizedCallTarget target;
    private final TruffleInliningProfile profile;
    private boolean inline;

    public TruffleInliningDecision(OptimizedCallTarget target, TruffleInliningProfile profile, List<TruffleInliningDecision> children) {
        super(children);
        this.target = target;
        this.profile = profile;
    }

    @Override
    public String getTargetName() {
        return this.target.toString();
    }

    public OptimizedCallTarget getTarget() {
        return this.target;
    }

    void setInline(boolean inline) {
        this.inline = inline;
    }

    @Override
    public boolean shouldInline() {
        return this.inline;
    }

    public TruffleInliningProfile getProfile() {
        return this.profile;
    }

    @Override
    public int compareTo(TruffleInliningDecision o) {
        return Double.compare(o.getProfile().getScore(), this.getProfile().getScore());
    }

    public boolean isSameAs(TruffleInliningDecision other) {
        if (this.getTarget() != other.getTarget()) {
            return false;
        }
        if (this.shouldInline() != other.shouldInline()) {
            return false;
        }
        if (!this.shouldInline()) {
            assert (!other.shouldInline());
            return true;
        }
        Iterator<TruffleInliningDecision> i1 = this.iterator();
        Iterator<TruffleInliningDecision> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().isSameAs(i2.next())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public String toString() {
        return String.format("TruffleInliningDecision(callNode=%s, inline=%b)", this.profile.getCallNode(), this.inline);
    }

    @Override
    public boolean isTargetStable() {
        return this.target == this.getProfile().getCallNode().getCurrentCallTarget();
    }

    @Override
    public JavaConstant getNodeRewritingAssumption() {
        return OptimizedCallTarget.runtime().forObject(this.target.getNodeRewritingAssumption());
    }
}

