/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.Option;
import java.util.Map;
import jdk.vm.ci.common.NativeImageReinitialize;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.runtime.OptionValuesImpl;
import org.graalvm.compiler.truffle.runtime.TruffleDebugOptionsOptionDescriptors;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionType;
import org.graalvm.options.OptionValues;

final class TruffleDebugOptions {
    @NativeImageReinitialize
    private static volatile OptionValuesImpl optionValues;
    @Option(help="", category=OptionCategory.INTERNAL)
    public static final OptionKey<PrintGraphTarget> PrintGraph;
    @Option(help="", category=OptionCategory.INTERNAL)
    public static final OptionKey<Boolean> PrintTruffleTrees;

    private TruffleDebugOptions() {
        throw new IllegalStateException("No instance allowed.");
    }

    static <T> T getValue(OptionKey<T> key) {
        OptionValues values = TruffleDebugOptions.getOptions();
        if (values.hasBeenSet(key)) {
            return (T)values.get(key);
        }
        return (T)key.getDefaultValue();
    }

    static OptionValues getOptions() {
        OptionValuesImpl result = optionValues;
        if (result == null) {
            EconomicMap valuesMap = EconomicMap.create();
            TruffleDebugOptionsOptionDescriptors descriptors = new TruffleDebugOptionsOptionDescriptors();
            for (Map.Entry<String, Object> e : TruffleCompilerRuntime.getRuntime().getOptions().entrySet()) {
                OptionDescriptor descriptor = descriptors.get(e.getKey());
                OptionKey k = descriptor != null ? descriptor.getKey() : null;
                if (k == null) continue;
                if (e.getKey().equals("PrintGraph")) {
                    valuesMap.put((Object)k, (Object)PrintGraphTarget.translate(e.getValue()));
                    continue;
                }
                valuesMap.put((Object)k, e.getValue());
            }
            optionValues = result = new OptionValuesImpl(descriptors, (UnmodifiableEconomicMap<OptionKey<?>, Object>)valuesMap);
        }
        return result;
    }

    static {
        PrintGraph = new OptionKey((Object)PrintGraphTarget.File, PrintGraphTarget.getOptionType());
        PrintTruffleTrees = new OptionKey((Object)true);
    }

    public static enum PrintGraphTarget {
        File,
        Network,
        Disable;


        static PrintGraphTarget translate(Object value) {
            return PrintGraphTarget.valueOf(String.valueOf(value));
        }

        static OptionType<PrintGraphTarget> getOptionType() {
            return new OptionType(PrintGraphTarget.class.getSimpleName(), PrintGraphTarget::valueOf);
        }
    }
}

