/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

public class RuntimeOptionsCache {
    private final boolean legacySplitting;
    private final boolean splitting;
    private final boolean splittingAllowForcedSplits;
    private final boolean splittingDumpDecisions;
    private final boolean splittingTraceEvents;
    private final boolean traceSplittingSummary;
    private final int splittingMaxCalleeSize;
    private final int splittingMaxPropagationDepth;
    private final double splittingGrowthLimit;
    private final int splittingMaxNumberOfSplitNodes;

    public RuntimeOptionsCache(OptionValues options) {
        this.splitting = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.Splitting) != false && PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.Mode) != PolyglotCompilerOptions.EngineModeEnum.LATENCY;
        this.legacySplitting = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.LegacySplitting);
        this.splittingAllowForcedSplits = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.SplittingAllowForcedSplits);
        this.splittingDumpDecisions = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.SplittingDumpDecisions);
        this.splittingMaxCalleeSize = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.SplittingMaxCalleeSize);
        this.splittingMaxPropagationDepth = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.SplittingMaxPropagationDepth);
        this.splittingTraceEvents = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.SplittingTraceEvents);
        this.traceSplittingSummary = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.TraceSplittingSummary);
        this.splittingGrowthLimit = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.SplittingGrowthLimit);
        this.splittingMaxNumberOfSplitNodes = PolyglotCompilerOptions.getValue(options, PolyglotCompilerOptions.SplittingMaxNumberOfSplitNodes);
    }

    boolean isSplittingDumpDecisions() {
        return this.splittingDumpDecisions;
    }

    boolean isLegacySplitting() {
        return this.legacySplitting;
    }

    boolean isSplittingAllowForcedSplits() {
        return this.splittingAllowForcedSplits;
    }

    boolean isSplitting() {
        return this.splitting;
    }

    boolean isSplittingTraceEvents() {
        return this.splittingTraceEvents;
    }

    boolean isTraceSplittingSummary() {
        return this.traceSplittingSummary;
    }

    int getSplittingMaxCalleeSize() {
        return this.splittingMaxCalleeSize;
    }

    int getSplittingMaxPropagationDepth() {
        return this.splittingMaxPropagationDepth;
    }

    double getSplittingGrowthLimit() {
        return this.splittingGrowthLimit;
    }

    int getSplittingMaxNumberOfSplitNodes() {
        return this.splittingMaxNumberOfSplitNodes;
    }
}

