/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public final class OptionValuesImpl
implements OptionValues {
    private static final Object NULL = new Object();
    private final OptionDescriptors descriptors;
    private final EconomicMap<OptionKey<?>, Object> values;

    public OptionValuesImpl(OptionDescriptors descriptors, UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
        this.descriptors = descriptors;
        this.values = EconomicMap.create();
        UnmodifiableMapCursor cursor = values.getEntries();
        while (cursor.advance()) {
            this.values.put(cursor.getKey(), OptionValuesImpl.maskNull(cursor.getValue()));
        }
    }

    OptionValuesImpl(OptionValuesImpl owner, UnmodifiableEconomicMap<OptionKey<?>, Object> overrides) {
        this.descriptors = owner.descriptors;
        this.values = EconomicMap.create();
        MapCursor cursor = owner.values.getEntries();
        while (cursor.advance()) {
            this.values.put(cursor.getKey(), OptionValuesImpl.maskNull(cursor.getValue()));
        }
        cursor = overrides.getEntries();
        while (cursor.advance()) {
            this.values.put(cursor.getKey(), OptionValuesImpl.maskNull(cursor.getValue()));
        }
    }

    private <T> boolean contains(OptionKey<T> optionKey) {
        for (OptionDescriptor descriptor : this.descriptors) {
            if (descriptor.getKey() != optionKey) continue;
            return true;
        }
        return false;
    }

    public OptionDescriptors getDescriptors() {
        return this.descriptors;
    }

    @CompilerDirectives.TruffleBoundary
    public <T> void set(OptionKey<T> optionKey, T value) {
        assert (this.contains(optionKey));
        this.values.put(optionKey, OptionValuesImpl.maskNull(value));
    }

    @CompilerDirectives.TruffleBoundary
    public <T> T get(OptionKey<T> optionKey) {
        assert (this.contains(optionKey));
        Object value = this.values.get(optionKey);
        if (value == null) {
            value = optionKey.getDefaultValue();
        }
        return (T)OptionValuesImpl.unmaskNull(value);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean hasBeenSet(OptionKey<?> optionKey) {
        assert (this.contains(optionKey));
        return this.values.containsKey(optionKey);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean hasSetOptions() {
        return !this.values.isEmpty();
    }

    private static Object maskNull(Object value) {
        return value == null ? NULL : value;
    }

    private static Object unmaskNull(Object value) {
        return value == NULL ? null : value;
    }
}

