/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;

public final class OptimizedLoopNode
extends LoopNode {
    @Node.Child
    private RepeatingNode repeatingNode;

    public OptimizedLoopNode(RepeatingNode repeatingNode) {
        this.repeatingNode = repeatingNode;
    }

    public RepeatingNode getRepeatingNode() {
        return this.repeatingNode;
    }

    public void executeLoop(VirtualFrame frame) {
        this.execute(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        int loopCount = 0;
        try {
            Object status;
            while ((status = this.repeatingNode.executeRepeatingWithValue(frame)) == RepeatingNode.CONTINUE_LOOP_STATUS) {
                if (!CompilerDirectives.inInterpreter()) continue;
                ++loopCount;
            }
            Object object = status;
            return object;
        }
        finally {
            if (CompilerDirectives.inInterpreter()) {
                OptimizedLoopNode.reportLoopCount((Node)this, (int)loopCount);
            }
        }
    }

    static LoopNode create(RepeatingNode repeatingNode) {
        return new OptimizedLoopNode(repeatingNode);
    }
}

