/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.FrameWithoutBoxing;
import org.graalvm.compiler.truffle.runtime.GraalCompilerDirectives;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedCompilationProfile;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.OptimizedOSRLoopNode;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.PolymorphicSpecializeDump;
import org.graalvm.compiler.truffle.runtime.SuppressFBWarnings;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public abstract class OptimizedCallTarget
implements CompilableTruffleAST,
RootCallTarget,
ReplaceObserver {
    private static final String NODE_REWRITING_ASSUMPTION_NAME = "nodeRewritingAssumption";
    static final String CALL_BOUNDARY_METHOD_NAME = "callProxy";
    static final String CALL_INLINED_METHOD_NAME = "call";
    private final RootNode rootNode;
    final EngineData engineData;
    @CompilerDirectives.CompilationFinal
    protected volatile OptimizedCompilationProfile compilationProfile;
    private final OptimizedCallTarget sourceCallTarget;
    private volatile RootNode uninitializedRootNode;
    private volatile int cachedNonTrivialNodeCount = -1;
    private volatile SpeculationLog speculationLog;
    private volatile int callSitesKnown;
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, SpeculationLog> SPECULATION_LOG_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, SpeculationLog.class, "speculationLog");
    private volatile CancellableCompileTask compilationTask;
    private volatile Assumption nodeRewritingAssumption;
    private static final AtomicReferenceFieldUpdater<OptimizedCallTarget, Assumption> NODE_REWRITING_ASSUMPTION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(OptimizedCallTarget.class, Assumption.class, "nodeRewritingAssumption");
    private volatile OptimizedDirectCallNode callSiteForSplit;
    @CompilerDirectives.CompilationFinal
    private volatile String nameCache;
    private final int uninitializedNodeCount;
    private final List<WeakReference<OptimizedDirectCallNode>> knownCallNodes;
    private boolean needsSplit;
    private static final String SPLIT_LOG_FORMAT = "[truffle] [poly-event] %-70s %s";

    public OptimizedCallTarget(OptimizedCallTarget sourceCallTarget, RootNode rootNode) {
        assert (sourceCallTarget == null || sourceCallTarget.sourceCallTarget == null) : "Cannot create a clone of a cloned CallTarget";
        this.sourceCallTarget = sourceCallTarget;
        this.speculationLog = sourceCallTarget != null ? sourceCallTarget.getSpeculationLog() : null;
        this.rootNode = rootNode;
        GraalTVMCI tvmci = OptimizedCallTarget.runtime().getTvmci();
        this.engineData = GraalTVMCI.getEngineData(rootNode);
        this.uninitializedNodeCount = !(rootNode instanceof OptimizedOSRLoopNode.OSRRootNode) ? tvmci.adoptChildrenAndCount(this.rootNode) : -1;
        this.knownCallNodes = this.engineData.options.isLegacySplitting() ? null : new ArrayList(1);
        tvmci.setCallTarget(rootNode, this);
    }

    protected static boolean inInlinedCode() {
        return false;
    }

    public Assumption getNodeRewritingAssumption() {
        Assumption assumption = this.nodeRewritingAssumption;
        if (assumption == null) {
            assumption = this.initializeNodeRewritingAssumption();
        }
        return assumption;
    }

    private Assumption initializeNodeRewritingAssumption() {
        Assumption newAssumption = OptimizedCallTarget.runtime().createAssumption(this.getOptionValue(PolyglotCompilerOptions.TraceAssumptions) == false ? NODE_REWRITING_ASSUMPTION_NAME : "nodeRewritingAssumption of " + this.rootNode);
        if (NODE_REWRITING_ASSUMPTION_UPDATER.compareAndSet(this, null, newAssumption)) {
            return newAssumption;
        }
        return Objects.requireNonNull(this.nodeRewritingAssumption);
    }

    private void invalidateNodeRewritingAssumption() {
        Assumption oldAssumption = NODE_REWRITING_ASSUMPTION_UPDATER.getAndUpdate(this, new UnaryOperator<Assumption>(){

            @Override
            public Assumption apply(Assumption prev) {
                return prev == null ? null : OptimizedCallTarget.runtime().createAssumption(prev.getName());
            }
        });
        if (oldAssumption != null) {
            oldAssumption.invalidate();
        }
    }

    public final RootNode getRootNode() {
        return this.rootNode;
    }

    public final OptimizedCompilationProfile getCompilationProfile() {
        OptimizedCompilationProfile profile = this.compilationProfile;
        if (profile != null) {
            return profile;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.initialize();
    }

    public final void resetCompilationProfile() {
        this.compilationProfile = this.createCompilationProfile();
    }

    protected List<OptimizedAssumption> getProfiledTypesAssumptions() {
        return this.getCompilationProfile().getProfiledTypesAssumptions();
    }

    protected Class<?>[] getProfiledArgumentTypes() {
        return this.getCompilationProfile().getProfiledArgumentTypes();
    }

    protected Class<?> getProfiledReturnType() {
        return this.getCompilationProfile().getProfiledReturnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object call(Object ... args) {
        Node encapsulatingNode = NodeUtil.pushEncapsulatingNode(null);
        try {
            Object object = this.callIndirect(encapsulatingNode, args);
            return object;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)encapsulatingNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object callIndirect(Node location, Object ... args) {
        try {
            OptimizedCompilationProfile profile = this.compilationProfile;
            if (profile != null) {
                profile.profileIndirectCall();
            }
            Object object = this.doInvoke(args);
            return object;
        }
        finally {
            assert (OptimizedCallTarget.keepAlive(location));
        }
    }

    public final Object callDirect(Node location, Object ... args) {
        try {
            this.getCompilationProfile().profileDirectCall(args);
            try {
                Object result = this.doInvoke(args);
                if (CompilerDirectives.inCompiledCode()) {
                    result = this.compilationProfile.injectReturnValueProfile(result);
                }
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                throw OptimizedCallTarget.rethrow(this.compilationProfile.profileExceptionType(t));
            }
        }
        finally {
            assert (OptimizedCallTarget.keepAlive(location));
        }
    }

    private static boolean keepAlive(Object o) {
        return true;
    }

    public final Object callOSR(Object ... args) {
        return this.doInvoke(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object callInlined(Node location, Object ... arguments) {
        try {
            this.getCompilationProfile().profileInlinedCall();
            Object object = this.callProxy(OptimizedCallTarget.createFrame(this.getRootNode().getFrameDescriptor(), arguments));
            return object;
        }
        finally {
            assert (OptimizedCallTarget.keepAlive(location));
        }
    }

    public final Object callInlinedAgnostic(Object ... arguments) {
        this.getCompilationProfile().profileInlinedCall();
        return this.callProxy(OptimizedCallTarget.createFrame(this.getRootNode().getFrameDescriptor(), arguments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object callInlinedForced(Node location, Object ... arguments) {
        try {
            this.getCompilationProfile().profileInlinedCall();
            Object object = this.callProxy(OptimizedCallTarget.createFrame(this.getRootNode().getFrameDescriptor(), arguments));
            return object;
        }
        finally {
            assert (OptimizedCallTarget.keepAlive(location));
        }
    }

    protected Object doInvoke(Object[] args) {
        return this.callBoundary(args);
    }

    @TruffleCallBoundary
    protected final Object callBoundary(Object[] args) {
        if (CompilerDirectives.inInterpreter()) {
            if (this.isValid()) {
                OptimizedCallTarget.runtime().bypassedInstalledCode();
            }
            if (this.getCompilationProfile().interpreterCall(this)) {
                return this.doInvoke(args);
            }
        }
        return this.callRoot(args);
    }

    protected final Object callRoot(Object[] originalArguments) {
        OptimizedCompilationProfile profile = this.compilationProfile;
        if (GraalCompilerDirectives.inFirstTier() && profile != null) {
            profile.firstTierCall(this);
        }
        Object[] args = originalArguments;
        if (CompilerDirectives.inCompiledCode() && profile != null) {
            args = profile.injectArgumentProfile(originalArguments);
        }
        Object result = this.callProxy(OptimizedCallTarget.createFrame(this.getRootNode().getFrameDescriptor(), args));
        if (profile != null) {
            profile.profileReturnValue(result);
        }
        return result;
    }

    protected final Object callProxy(VirtualFrame frame) {
        boolean inCompiled = CompilerDirectives.inCompilationRoot();
        try {
            Object object = this.getRootNode().execute(frame);
            return object;
        }
        catch (ControlFlowException t) {
            throw OptimizedCallTarget.rethrow(this.getCompilationProfile().profileExceptionType(t));
        }
        catch (Throwable t) {
            Throwable profiledT = this.getCompilationProfile().profileExceptionType(t);
            OptimizedCallTarget.runtime().getTvmci().onThrowable(null, this, profiledT, (Frame)frame);
            throw OptimizedCallTarget.rethrow(profiledT);
        }
        finally {
            assert (frame != null && this != null);
            if (CompilerDirectives.inInterpreter() && inCompiled) {
                if (!this.isValid()) {
                    this.getCompilationProfile().reportInvalidated();
                }
                this.notifyDeoptimized(frame);
            }
        }
    }

    private void notifyDeoptimized(VirtualFrame frame) {
        OptimizedCallTarget.runtime().getListener().onCompilationDeoptimized(this, (Frame)frame);
    }

    static GraalTruffleRuntime runtime() {
        return (GraalTruffleRuntime)Truffle.getRuntime();
    }

    private synchronized OptimizedCompilationProfile initialize() {
        OptimizedCompilationProfile profile = this.compilationProfile;
        if (profile == null) {
            GraalTVMCI tvmci = OptimizedCallTarget.runtime().getTvmci();
            if (this.sourceCallTarget == null && this.rootNode.isCloningAllowed() && !tvmci.isCloneUninitializedSupported(this.rootNode)) {
                this.uninitializedRootNode = (RootNode)NodeUtil.cloneNode((Node)this.rootNode);
            }
            tvmci.onFirstExecution(this);
            this.compilationProfile = profile = this.createCompilationProfile();
        }
        return profile;
    }

    public final OptionValues getOptionValues() {
        return this.engineData.engineOptions;
    }

    public <T> T getOptionValue(OptionKey<T> key) {
        return PolyglotCompilerOptions.getValue(this.getOptionValues(), key);
    }

    private OptimizedCompilationProfile createCompilationProfile() {
        return OptimizedCompilationProfile.create(this.getOptionValues());
    }

    @Deprecated
    public final boolean compile() {
        return this.compile(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compile(boolean lastTierCompilation) {
        if (!this.needsCompile(lastTierCompilation)) {
            return true;
        }
        if (!this.isCompiling()) {
            if (!OptimizedCallTarget.runtime().acceptForCompilation(this.getRootNode())) {
                this.getCompilationProfile().reportCompilationIgnored();
                return false;
            }
            CancellableCompileTask task = null;
            OptimizedCallTarget optimizedCallTarget = this;
            synchronized (optimizedCallTarget) {
                if (!this.needsCompile(lastTierCompilation)) {
                    return true;
                }
                if (this.compilationProfile == null) {
                    this.initialize();
                }
                if (!this.isCompiling()) {
                    try {
                        this.compilationTask = task = OptimizedCallTarget.runtime().submitForCompilation(this, lastTierCompilation);
                    }
                    catch (RejectedExecutionException e) {
                        return false;
                    }
                }
            }
            if (task != null) {
                boolean allowBackgroundCompilation = this.getOptionValue(PolyglotCompilerOptions.PerformanceWarningsAreFatal) == false && this.getOptionValue(PolyglotCompilerOptions.CompilationExceptionsAreThrown) == false;
                boolean mayBeAsynchronous = allowBackgroundCompilation && this.getOptionValue(PolyglotCompilerOptions.BackgroundCompilation) != false;
                OptimizedCallTarget.runtime().finishCompilation(this, task, mayBeAsynchronous);
                return !mayBeAsynchronous;
            }
        }
        return false;
    }

    private boolean needsCompile(boolean isLastTierCompilation) {
        return !this.isValid() || isLastTierCompilation && !this.isValidLastTier();
    }

    public final boolean isCompiling() {
        return this.getCompilationTask() != null;
    }

    public abstract long getCodeAddress();

    public abstract boolean isValid();

    public abstract boolean isValidLastTier();

    public void invalidate(Object source, CharSequence reason) {
        this.cachedNonTrivialNodeCount = -1;
        if (this.isValid()) {
            this.invalidateCode();
            OptimizedCallTarget.runtime().getListener().onCompilationInvalidated(this, source, reason);
        }
        OptimizedCallTarget.runtime().cancelInstalledTask(this, source, reason);
    }

    OptimizedCallTarget cloneUninitialized() {
        RootNode clonedRoot;
        GraalTVMCI tvmci;
        assert (this.sourceCallTarget == null);
        if (this.compilationProfile == null) {
            this.initialize();
        }
        if ((tvmci = OptimizedCallTarget.runtime().getTvmci()).isCloneUninitializedSupported(this.rootNode)) {
            assert (this.uninitializedRootNode == null);
            clonedRoot = tvmci.cloneUninitialized(this.rootNode);
        } else {
            clonedRoot = (RootNode)NodeUtil.cloneNode((Node)this.uninitializedRootNode);
        }
        return OptimizedCallTarget.runtime().createClonedCallTarget(clonedRoot, this);
    }

    public SpeculationLog getSpeculationLog() {
        if (this.speculationLog == null) {
            SPECULATION_LOG_UPDATER.compareAndSet(this, null, ((GraalTruffleRuntime)Truffle.getRuntime()).createSpeculationLog());
        }
        return this.speculationLog;
    }

    void setSpeculationLog(SpeculationLog speculationLog) {
        this.speculationLog = speculationLog;
    }

    @Override
    public JavaConstant asJavaConstant() {
        return GraalTruffleRuntime.getRuntime().forObject(this);
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    @Override
    public void cancelInstalledTask() {
        OptimizedCallTarget.runtime().cancelInstalledTask(this, null, "got inlined. callsite count: " + this.getKnownCallSiteCount());
    }

    @Override
    public boolean isSameOrSplit(CompilableTruffleAST ast) {
        if (!(ast instanceof OptimizedCallTarget)) {
            return false;
        }
        OptimizedCallTarget other = (OptimizedCallTarget)ast;
        return this == other || this == other.sourceCallTarget || other == this.sourceCallTarget || this.sourceCallTarget != null && other.sourceCallTarget != null && this.sourceCallTarget == other.sourceCallTarget;
    }

    boolean cancelInstalledTask(Node source, CharSequence reason) {
        return OptimizedCallTarget.runtime().cancelInstalledTask(this, source, reason);
    }

    @Override
    public void onCompilationFailed(Supplier<String> reasonAndStackTrace, boolean bailout, boolean permanentBailout) {
        if (!bailout || permanentBailout) {
            this.compilationProfile.reportCompilationFailure();
            if (this.getOptionValue(PolyglotCompilerOptions.CompilationExceptionsAreThrown).booleanValue()) {
                InternalError error = new InternalError(reasonAndStackTrace.get());
                throw new OptimizationFailedException((Throwable)error, (RootCallTarget)this);
            }
            boolean truffleCompilationExceptionsAreFatal = TruffleRuntimeOptions.areTruffleCompilationExceptionsFatal(this);
            if (this.getOptionValue(PolyglotCompilerOptions.CompilationExceptionsArePrinted).booleanValue() || truffleCompilationExceptionsAreFatal) {
                OptimizedCallTarget.log(reasonAndStackTrace.get());
                if (truffleCompilationExceptionsAreFatal) {
                    OptimizedCallTarget.log("Exiting VM due to " + (this.getOptionValue(PolyglotCompilerOptions.CompilationExceptionsAreFatal) != false ? "TruffleCompilationExceptionsAreFatal" : "TrufflePerformanceWarningsAreFatal") + "=true");
                    System.exit(-1);
                }
            }
        }
    }

    public static final void log(String message) {
        OptimizedCallTarget.runtime().log(message);
    }

    @Override
    public final int getKnownCallSiteCount() {
        return this.callSitesKnown;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="All increments and decrements are synchronized.")
    final synchronized void incrementKnownCallSites() {
        ++this.callSitesKnown;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="All increments and decrements are synchronized.")
    final synchronized void decrementKnownCallSites() {
        --this.callSitesKnown;
    }

    public final OptimizedCallTarget getSourceCallTarget() {
        return this.sourceCallTarget;
    }

    @Override
    public String getName() {
        String result = this.nameCache;
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nameCache = result = this.rootNode.toString();
        }
        return result;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        String superString = this.rootNode.toString();
        if (this.isValid()) {
            superString = superString + " <opt>";
        }
        if (this.sourceCallTarget != null) {
            superString = superString + " <split-" + Integer.toHexString(this.hashCode()) + ">";
        }
        return superString;
    }

    static Object[] castArrayFixedLength(Object[] args, int length) {
        return args;
    }

    static <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return (T)value;
    }

    public static VirtualFrame createFrame(FrameDescriptor descriptor, Object[] args) {
        return new FrameWithoutBoxing(descriptor, args);
    }

    final void onLoopCount(int count) {
        this.getCompilationProfile().reportLoopCount(count);
    }

    public boolean nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        CompilerAsserts.neverPartOfCompilation();
        this.invalidate(newNode, reason);
        this.invalidateNodeRewritingAssumption();
        OptimizedCompilationProfile profile = this.compilationProfile;
        if (profile != null) {
            profile.reportNodeReplaced();
            if (this.cancelInstalledTask(newNode, reason)) {
                profile.reportInvalidated();
            }
        }
        return false;
    }

    public void accept(NodeVisitor visitor, TruffleInlining inlingDecision) {
        if (inlingDecision != null) {
            inlingDecision.accept(this, visitor);
        } else {
            this.getRootNode().accept(visitor);
        }
    }

    public Iterable<Node> nodeIterable(TruffleInlining inliningDecision) {
        Iterator<Node> iterator = this.nodeIterator(inliningDecision);
        return () -> iterator;
    }

    public Iterator<Node> nodeIterator(TruffleInlining inliningDecision) {
        Iterator iterator = inliningDecision != null ? inliningDecision.makeNodeIterator(this) : NodeUtil.makeRecursiveIterator((Node)this.getRootNode());
        return iterator;
    }

    @Override
    public final int getNonTrivialNodeCount() {
        if (this.cachedNonTrivialNodeCount == -1) {
            this.cachedNonTrivialNodeCount = OptimizedCallTarget.calculateNonTrivialNodes((Node)this.getRootNode());
        }
        return this.cachedNonTrivialNodeCount;
    }

    @Override
    public int getCallCount() {
        OptimizedCompilationProfile profile = this.compilationProfile;
        return profile == null ? 0 : profile.getCallCount();
    }

    public static int calculateNonTrivialNodes(Node node) {
        NonTrivialNodeCountVisitor visitor = new NonTrivialNodeCountVisitor();
        node.accept((NodeVisitor)visitor);
        return visitor.nodeCount;
    }

    public Map<String, Object> getDebugProperties(TruffleInlining inlining) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        GraalTruffleRuntimeListener.addASTSizeProperty(this, inlining, properties);
        properties.putAll(this.getCompilationProfile().getDebugProperties());
        return properties;
    }

    @Override
    public TruffleCallNode[] getCallNodes() {
        final ArrayList callNodes = new ArrayList();
        this.getRootNode().accept(new NodeVisitor(){

            public boolean visit(Node node) {
                if (node instanceof OptimizedDirectCallNode) {
                    callNodes.add((OptimizedDirectCallNode)node);
                }
                return true;
            }
        });
        return callNodes.toArray(new TruffleCallNode[0]);
    }

    public CompilerOptions getCompilerOptions() {
        CompilerOptions options = this.rootNode.getCompilerOptions();
        if (options != null) {
            return options;
        }
        return DefaultCompilerOptions.INSTANCE;
    }

    public void setCallSiteForSplit(OptimizedDirectCallNode callSiteForSplit) {
        if (this.sourceCallTarget == null) {
            throw new IllegalStateException("Attempting to set a split call site on a target that is not a split!");
        }
        this.callSiteForSplit = callSiteForSplit;
    }

    public OptimizedDirectCallNode getCallSiteForSplit() {
        return this.callSiteForSplit;
    }

    int getUninitializedNodeCount() {
        assert (this.uninitializedNodeCount >= 0);
        return this.uninitializedNodeCount;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    CancellableCompileTask getCompilationTask() {
        return this.compilationTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCompilationTask() {
        OptimizedCallTarget optimizedCallTarget = this;
        synchronized (optimizedCallTarget) {
            assert (this.compilationTask != null);
            this.compilationTask = null;
        }
    }

    synchronized void addKnownCallNode(OptimizedDirectCallNode directCallNode) {
        if (this.knownCallNodes.size() < 100) {
            this.knownCallNodes.add(new WeakReference<OptimizedDirectCallNode>(directCallNode));
        }
    }

    synchronized void removeKnownCallSite(final OptimizedDirectCallNode callNodeToRemove) {
        this.knownCallNodes.removeIf(new Predicate<WeakReference<OptimizedDirectCallNode>>(){

            @Override
            public boolean test(WeakReference<OptimizedDirectCallNode> nodeWeakReference) {
                return nodeWeakReference.get() == callNodeToRemove || nodeWeakReference.get() == null;
            }
        });
    }

    boolean isNeedsSplit() {
        return this.needsSplit;
    }

    void polymorphicSpecialize(Node source) {
        assert (!this.engineData.options.isLegacySplitting());
        ArrayList<Node> toDump = null;
        if (this.engineData.options.isSplittingDumpDecisions()) {
            toDump = new ArrayList<Node>();
            OptimizedCallTarget.pullOutParentChain(source, toDump);
        }
        this.logPolymorphicEvent(0, "Polymorphic event! Source:", source);
        this.maybeSetNeedsSplit(0, toDump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeSetNeedsSplit(int depth, List<Node> toDump) {
        OptimizedDirectCallNode onlyCaller;
        int numberOfKnownCallNodes;
        OptimizedCallTarget optimizedCallTarget = this;
        synchronized (optimizedCallTarget) {
            numberOfKnownCallNodes = this.knownCallNodes.size();
            onlyCaller = numberOfKnownCallNodes == 1 ? (OptimizedDirectCallNode)this.knownCallNodes.get(0).get() : null;
        }
        if (depth > this.engineData.options.getSplittingMaxPropagationDepth() || this.needsSplit || numberOfKnownCallNodes == 0 || this.compilationProfile != null && this.compilationProfile.getCallCount() == 1) {
            this.logEarlyReturn(depth, numberOfKnownCallNodes);
            return this.needsSplit;
        }
        if (numberOfKnownCallNodes == 1) {
            RootNode callerRootNode;
            if (onlyCaller != null && (callerRootNode = onlyCaller.getRootNode()) != null && callerRootNode.getCallTarget() != null) {
                OptimizedCallTarget callerTarget = (OptimizedCallTarget)callerRootNode.getCallTarget();
                if (this.engineData.options.isSplittingDumpDecisions()) {
                    OptimizedCallTarget.pullOutParentChain((Node)onlyCaller, toDump);
                }
                this.logPolymorphicEvent(depth, "One caller! Analysing parent.");
                if (callerTarget.maybeSetNeedsSplit(depth + 1, toDump)) {
                    this.logPolymorphicEvent(depth, "Set needs split to true via parent");
                    this.needsSplit = true;
                }
            }
        } else {
            this.logPolymorphicEvent(depth, "Set needs split to true");
            this.needsSplit = true;
            this.maybeDump(toDump);
        }
        this.logPolymorphicEvent(depth, "Return:", this.needsSplit);
        return this.needsSplit;
    }

    private void logEarlyReturn(int depth, int numberOfKnownCallNodes) {
        if (this.engineData.options.isSplittingTraceEvents()) {
            this.logPolymorphicEvent(depth, "Early return: " + this.needsSplit + " callCount: " + this.compilationProfile.getCallCount() + ", numberOfKnownCallNodes: " + numberOfKnownCallNodes);
        }
    }

    private void logPolymorphicEvent(int depth, String message) {
        this.logPolymorphicEvent(depth, message, null);
    }

    private void logPolymorphicEvent(int depth, String message, Object arg) {
        if (this.engineData.options.isSplittingTraceEvents()) {
            String indent = new String(new char[depth]).replace("\u0000", "  ");
            String argString = arg == null ? "" : " " + arg;
            OptimizedCallTarget.log(String.format(SPLIT_LOG_FORMAT, indent + message + argString, this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeDump(List<Node> toDump) {
        if (this.engineData.options.isSplittingDumpDecisions()) {
            ArrayList<OptimizedDirectCallNode> callers = new ArrayList<OptimizedDirectCallNode>();
            OptimizedCallTarget optimizedCallTarget = this;
            synchronized (optimizedCallTarget) {
                for (WeakReference<OptimizedDirectCallNode> nodeRef : this.knownCallNodes) {
                    if (nodeRef.get() == null) continue;
                    callers.add((OptimizedDirectCallNode)nodeRef.get());
                }
            }
            PolymorphicSpecializeDump.dumpPolymorphicSpecialize(toDump, callers);
        }
    }

    private static void pullOutParentChain(Node node, List<Node> toDump) {
        Node rootNode = node;
        while (rootNode.getParent() != null) {
            toDump.add(rootNode);
            rootNode = rootNode.getParent();
        }
        toDump.add(rootNode);
    }

    static class OptimizedCallInlined
    extends Accessor.CallInlined {
        OptimizedCallInlined() {
        }

        public Object call(Node callNode, CallTarget target, Object ... arguments) {
            try {
                return ((OptimizedCallTarget)target).callInlinedForced(callNode, arguments);
            }
            catch (Throwable t) {
                OptimizedCallTarget.runtime().getTvmci().onThrowable(callNode, (OptimizedCallTarget)target, t, null);
                throw OptimizedCallTarget.rethrow(t);
            }
        }
    }

    static class OptimizedCallProfiled
    extends Accessor.CallProfiled {
        OptimizedCallProfiled() {
        }

        public Object call(CallTarget target, Object ... args) {
            OptimizedCallTarget castTarget = (OptimizedCallTarget)target;
            assert (castTarget.compilationProfile != null && castTarget.compilationProfile.isValidArgumentProfile(args)) : "Invalid argument profile. UnsafeCalls need to explicity initialize the profile.";
            return castTarget.doInvoke(args);
        }
    }

    private static final class NonTrivialNodeCountVisitor
    implements NodeVisitor {
        public int nodeCount;

        private NonTrivialNodeCountVisitor() {
        }

        public boolean visit(Node node) {
            if (!node.getCost().isTrivial()) {
                ++this.nodeCount;
            }
            return true;
        }
    }
}

