/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.AbstractAssumption;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

public final class OptimizedAssumption
extends AbstractAssumption
implements JavaKind.FormatWithToString {
    private Entry dependencies;
    private int size;
    private int sizeAfterLastRemove;

    public OptimizedAssumption(String name) {
        super(name);
    }

    public void check() throws InvalidAssumptionException {
        if (!this.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new InvalidAssumptionException();
        }
    }

    public void invalidate() {
        if (this.isValid) {
            this.invalidateImpl("");
        }
    }

    public void invalidate(String message) {
        if (this.isValid) {
            this.invalidateImpl(message);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void invalidateImpl(String message) {
        if (!this.isValid) {
            return;
        }
        OptionValues engineOptions = null;
        boolean logStackTrace = false;
        Entry e = this.dependencies;
        while (e != null) {
            OptimizedAssumptionDependency dependency = e.awaitDependency();
            if (dependency != null) {
                OptimizedCallTarget callTarget = this.invalidateWithReason(dependency, "assumption invalidated");
                if (engineOptions == null) {
                    engineOptions = callTarget != null ? callTarget.getOptionValues() : GraalTVMCI.getEngineData(null).engineOptions;
                }
                if (PolyglotCompilerOptions.getValue(engineOptions, PolyglotCompilerOptions.TraceAssumptions).booleanValue()) {
                    logStackTrace = true;
                    this.logInvalidatedDependency(dependency, message);
                }
                if (callTarget != null) {
                    callTarget.getCompilationProfile().reportInvalidated();
                }
            }
            e = e.next;
        }
        this.dependencies = null;
        this.size = 0;
        this.sizeAfterLastRemove = 0;
        this.isValid = false;
        if (logStackTrace) {
            OptimizedAssumption.logStackTrace(engineOptions);
        }
    }

    private void removeInvalidEntries() {
        Entry last = null;
        Entry e = this.dependencies;
        this.dependencies = null;
        while (e != null) {
            if (e.isValid()) {
                if (last == null) {
                    this.dependencies = e;
                } else {
                    last.next = e;
                }
                last = e;
            } else {
                --this.size;
            }
            e = e.next;
        }
        if (last != null) {
            last.next = null;
        }
        this.sizeAfterLastRemove = this.size;
    }

    public synchronized void removeInvalidDependencies() {
        this.removeInvalidEntries();
    }

    public synchronized int countDependencies() {
        return this.size;
    }

    public synchronized Consumer<OptimizedAssumptionDependency> registerDependency() {
        if (this.isValid) {
            if (this.size >= 2 * this.sizeAfterLastRemove) {
                this.removeInvalidEntries();
            }
            Entry e = new Entry();
            e.next = this.dependencies;
            this.dependencies = e;
            ++this.size;
            return e;
        }
        return null;
    }

    private OptimizedCallTarget invalidateWithReason(OptimizedAssumptionDependency dependency, String reason) {
        if (dependency.getCompilable() != null) {
            OptimizedCallTarget callTarget = (OptimizedCallTarget)dependency.getCompilable();
            callTarget.invalidate((Object)this, reason);
            return callTarget;
        }
        dependency.invalidate();
        return null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void logInvalidatedDependency(OptimizedAssumptionDependency dependency, String message) {
        StringBuilder sb = new StringBuilder("assumption '").append(this.name).append("' invalidated installed code '").append(dependency);
        if (message != null && !message.isEmpty()) {
            sb.append("' with message '").append(message);
        }
        GraalTruffleRuntime.getRuntime().log(sb.toString());
    }

    private static void logStackTrace(OptionValues engineOptions) {
        boolean skip = true;
        int limit = PolyglotCompilerOptions.getValue(engineOptions, PolyglotCompilerOptions.TraceStackTraceLimit);
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StringBuilder strb = new StringBuilder();
        String sep = "";
        for (int i = 1; i < stackTrace.length && i < 1 + limit; ++i) {
            strb.append(sep).append("  ").append(stackTrace[i].toString());
            sep = "\n";
        }
        if (stackTrace.length > 1 + limit) {
            strb.append("\n    ...");
        }
        GraalTruffleRuntime.getRuntime().log(strb.toString());
    }

    static class Entry
    implements Consumer<OptimizedAssumptionDependency> {
        OptimizedAssumptionDependency dependency;
        WeakReference<OptimizedAssumptionDependency> weakDependency;
        Entry next;

        Entry() {
        }

        @Override
        public synchronized void accept(OptimizedAssumptionDependency dep) {
            if (dep == null || dep.soleExecutionEntryPoint()) {
                this.weakDependency = new WeakReference<OptimizedAssumptionDependency>(dep);
            } else {
                this.dependency = dep;
            }
            this.notifyAll();
        }

        synchronized OptimizedAssumptionDependency awaitDependency() {
            while (this.dependency == null && this.weakDependency == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.dependency != null) {
                return this.dependency;
            }
            return (OptimizedAssumptionDependency)this.weakDependency.get();
        }

        synchronized boolean isValid() {
            if (this.dependency != null) {
                return this.dependency.isValid();
            }
            if (this.weakDependency != null) {
                OptimizedAssumptionDependency dep = (OptimizedAssumptionDependency)this.weakDependency.get();
                return dep != null && dep.isValid();
            }
            return true;
        }

        public synchronized String toString() {
            if (this.dependency != null) {
                return String.format("%x[%s]", this.hashCode(), this.dependency);
            }
            if (this.weakDependency != null) {
                OptimizedAssumptionDependency dep = (OptimizedAssumptionDependency)this.weakDependency.get();
                return String.format("%x[%s]", this.hashCode(), dep);
            }
            return String.format("%x", this.hashCode());
        }
    }
}

