/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.VoidGraphStructure;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.graphio.GraphOutput;

final class GraalTestTVMCI
extends TVMCI.Test<GraalTestContext, OptimizedCallTarget> {
    private final GraalTruffleRuntime truffleRuntime;

    GraalTestTVMCI(GraalTruffleRuntime truffleRuntime) {
        this.truffleRuntime = truffleRuntime;
    }

    protected GraalTestContext createTestContext(String testName) {
        Map<String, Object> optionsMap = TruffleRuntimeOptions.getOptionsForCompiler();
        TruffleDebugContext debugContext = this.truffleRuntime.getTruffleCompiler().openDebugContext(optionsMap, null);
        return new GraalTestContext(testName, debugContext);
    }

    public OptimizedCallTarget createTestCallTarget(GraalTestContext testContext, RootNode testNode) {
        return (OptimizedCallTarget)this.truffleRuntime.createCallTarget(testNode);
    }

    public void finishWarmup(GraalTestContext testContext, OptimizedCallTarget callTarget) {
        this.truffleRuntime.doCompile(callTarget, new CancellableCompileTask(true));
    }

    static final class GraalTestContext
    implements Closeable {
        private final TruffleDebugContext debug;
        private final GraphOutput<Void, ?> output;

        private static GraphOutput<Void, ?> beginGroup(TruffleDebugContext debug, String testName) {
            block3: {
                GraphOutput<Void, ?> output = null;
                try {
                    if (debug.isDumpEnabled()) {
                        output = debug.buildOutput(GraphOutput.newBuilder(VoidGraphStructure.INSTANCE).protocolVersion(6, 0));
                        output.beginGroup(null, testName, testName, null, 0, debug.getVersionProperties());
                        return output;
                    }
                }
                catch (IOException e) {
                    if (output == null) break block3;
                    output.close();
                }
            }
            return null;
        }

        private GraalTestContext(String testName, TruffleDebugContext debug) {
            this.debug = debug;
            this.output = GraalTestContext.beginGroup(this.debug, testName);
        }

        @Override
        public void close() throws IOException {
            block6: {
                try {
                    if (this.output == null) break block6;
                    try {
                        this.output.endGroup();
                    }
                    finally {
                        this.output.close();
                    }
                }
                finally {
                    this.debug.close();
                }
            }
        }
    }
}

