/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.TruffleRuntimeOptions;
import org.graalvm.options.OptionValues;

public class BackgroundCompileQueue {
    private final AtomicLong idCounter = new AtomicLong();
    private volatile ExecutorService compilationExecutorService;
    private boolean shutdown = false;

    private synchronized ExecutorService getExecutorService(OptimizedCallTarget callTarget) {
        int availableProcessors;
        if (this.compilationExecutorService != null) {
            return this.compilationExecutorService;
        }
        if (this.shutdown) {
            throw new RejectedExecutionException("The BackgroundCompileQueue is shutdown");
        }
        int threads = callTarget.getOptionValue(PolyglotCompilerOptions.CompilerThreads);
        if (threads == 0 && (availableProcessors = Runtime.getRuntime().availableProcessors()) >= 4) {
            threads = 2;
        }
        threads = Math.max(1, threads);
        TruffleCompilerThreadFactory factory = new TruffleCompilerThreadFactory("TruffleCompilerThread");
        this.compilationExecutorService = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue(), factory){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new RequestFutureTask<T>(runnable, value);
            }
        };
        return this.compilationExecutorService;
    }

    public CancellableCompileTask submitCompilationRequest(GraalTruffleRuntime runtime, OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) throws RejectedExecutionException {
        OptionValues optionOverrides = TruffleRuntimeOptions.getCurrentOptionOverrides();
        CancellableCompileTask cancellable = new CancellableCompileTask(lastTierCompilation);
        Request request = new Request(runtime, optionOverrides, optimizedCallTarget, cancellable);
        cancellable.setFuture(this.getExecutorService(optimizedCallTarget).submit(request));
        return cancellable;
    }

    public int getQueueSize() {
        ExecutorService threadPool = this.compilationExecutorService;
        if (threadPool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)threadPool).getQueue().size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAndAwaitTermination(long timeout) {
        ExecutorService threadPool;
        BackgroundCompileQueue backgroundCompileQueue = this;
        synchronized (backgroundCompileQueue) {
            threadPool = this.compilationExecutorService;
            if (threadPool == null) {
                this.shutdown = true;
                return;
            }
        }
        threadPool.shutdownNow();
        try {
            threadPool.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not terminate compiler threads. Check if there are runaway compilations that don't handle Thread#interrupt.", e);
        }
    }

    private static final class TruffleCompilerThreadFactory
    implements ThreadFactory {
        private final String namePrefix;

        TruffleCompilerThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r){

                @Override
                public void run() {
                    this.setContextClassLoader(this.getClass().getClassLoader());
                    super.run();
                }
            };
            t.setName(this.namePrefix + "-" + t.getId());
            t.setPriority(10);
            t.setDaemon(true);
            return t;
        }
    }

    public class RequestFutureTask<V>
    extends FutureTask<V>
    implements Comparable<Runnable> {
        private final Request request;

        public RequestFutureTask(Runnable runnable, V result) {
            super(runnable, result);
            this.request = (Request)runnable;
        }

        @Override
        public int compareTo(Runnable that) {
            if (that instanceof RequestFutureTask) {
                return this.request.compareTo(((RequestFutureTask)that).request);
            }
            return this.request.compareTo((Request)that);
        }

        @Override
        public String toString() {
            return "Future(" + this.request + ")";
        }
    }

    public class Request
    implements Runnable,
    Comparable<Request> {
        private final long id;
        private final GraalTruffleRuntime runtime;
        private final OptionValues optionOverrides;
        private final WeakReference<OptimizedCallTarget> weakCallTarget;
        private final TruffleCompilationTask task;
        private final boolean isFirstTier;

        public Request(GraalTruffleRuntime runtime, OptionValues optionOverrides, OptimizedCallTarget callTarget, TruffleCompilationTask task) {
            this.id = BackgroundCompileQueue.this.idCounter.getAndIncrement();
            this.runtime = runtime;
            this.optionOverrides = optionOverrides;
            this.weakCallTarget = new WeakReference<OptimizedCallTarget>(callTarget);
            this.task = task;
            this.isFirstTier = !task.isLastTier();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OptimizedCallTarget callTarget = (OptimizedCallTarget)this.weakCallTarget.get();
            if (callTarget != null) {
                try (TruffleRuntimeOptions.TruffleRuntimeOptionsOverrideScope scope = this.optionOverrides != null ? TruffleRuntimeOptions.overrideOptions(this.optionOverrides) : null;){
                    if (!this.task.isCancelled()) {
                        this.runtime.doCompile(callTarget, this.task);
                    }
                }
                finally {
                    callTarget.resetCompilationTask();
                }
            }
        }

        @Override
        public int compareTo(Request that) {
            if (this.isFirstTier != that.isFirstTier) {
                return this.isFirstTier ? -1 : 1;
            }
            return (int)(this.id - that.id);
        }

        public String toString() {
            return "Request(lo: " + this.isFirstTier + ", id: " + this.id + ", " + this.weakCallTarget + ")";
        }
    }
}

