/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.truffle.common.CallNodeProvider;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.nodes.IsInlinedNode;

final class GraphManager {
    private final PartialEvaluator partialEvaluator;
    private final StructuredGraph rootIR;
    private final CallNodeProvider callNodeProvider;
    private final EconomicMap<ResolvedJavaMethod, EncodedGraph> graphCacheForInlining = EconomicMap.create();
    private final EconomicMap<CompilableTruffleAST, Entry> irCache = EconomicMap.create();

    GraphManager(StructuredGraph ir, PartialEvaluator partialEvaluator, CallNodeProvider callNodeProvider) {
        this.partialEvaluator = partialEvaluator;
        this.rootIR = ir;
        this.callNodeProvider = callNodeProvider;
    }

    private static void handleInlinedNodes(StructuredGraph ir, UnmodifiableEconomicMap<Node, Node> duplicates) {
        for (IsInlinedNode isInlinedNode : ir.getNodes(IsInlinedNode.TYPE)) {
            IsInlinedNode duplicate = (IsInlinedNode)duplicates.get((Object)isInlinedNode);
            if (duplicate == null) continue;
            duplicate.inlined();
        }
    }

    Entry get(CompilableTruffleAST truffleAST) {
        Entry entry = (Entry)this.irCache.get((Object)truffleAST);
        if (entry == null) {
            Cancellable cancellable = this.rootIR.getCancellable();
            SpeculationLog log = this.rootIR.getSpeculationLog();
            DebugContext debug = this.rootIR.getDebug();
            StructuredGraph.AllowAssumptions allowAssumptions = this.rootIR.getAssumptions() != null ? StructuredGraph.AllowAssumptions.YES : StructuredGraph.AllowAssumptions.NO;
            CompilationIdentifier id = this.rootIR.compilationId();
            PEAgnosticInlineInvokePlugin plugin = new PEAgnosticInlineInvokePlugin(this.callNodeProvider, this.partialEvaluator.getCallDirectMethod(), this.partialEvaluator.getCallBoundary());
            StructuredGraph graph = this.partialEvaluator.createGraphForInlining(debug, truffleAST, this.callNodeProvider, plugin, allowAssumptions, id, log, cancellable, this.graphCacheForInlining);
            EconomicMap<TruffleCallNode, Invoke> truffleCallNodeToInvoke = plugin.getTruffleCallNodeToInvoke();
            entry = new Entry(graph, truffleCallNodeToInvoke);
            this.irCache.put((Object)truffleAST, (Object)entry);
        }
        return entry;
    }

    EconomicMap<TruffleCallNode, Invoke> peRoot(CompilableTruffleAST truffleAST) {
        PEAgnosticInlineInvokePlugin plugin = new PEAgnosticInlineInvokePlugin(this.callNodeProvider, this.partialEvaluator.getCallDirectMethod(), this.partialEvaluator.getCallBoundary());
        this.partialEvaluator.parseRootGraphForInlining(truffleAST, this.rootIR, this.callNodeProvider, plugin, this.graphCacheForInlining);
        return plugin.getTruffleCallNodeToInvoke();
    }

    UnmodifiableEconomicMap<Node, Node> doInline(Invoke invoke, StructuredGraph ir, CompilableTruffleAST truffleAST) {
        UnmodifiableEconomicMap<Node, Node> duplicates = InliningUtil.inline(invoke, ir, true, this.partialEvaluator.inlineRootForCallTargetAgnostic(truffleAST), "cost-benefit analysis", "AgnosticInliningPhase");
        GraphManager.handleInlinedNodes(ir, duplicates);
        return duplicates;
    }

    private static class PEAgnosticInlineInvokePlugin
    extends PartialEvaluator.PEInlineInvokePlugin {
        private final EconomicMap<TruffleCallNode, Invoke> truffleCallNodeToInvoke;
        private final CallNodeProvider callNodeProvider;
        private final ResolvedJavaMethod callTargetCallDirect;
        private final ResolvedJavaMethod callBoundary;
        private JavaConstant lastDirectCallNode;

        PEAgnosticInlineInvokePlugin(CallNodeProvider callNodeProvider, ResolvedJavaMethod callTargetCallDirect, ResolvedJavaMethod callBoundary) {
            this.callTargetCallDirect = callTargetCallDirect;
            this.callBoundary = callBoundary;
            this.truffleCallNodeToInvoke = EconomicMap.create();
            this.callNodeProvider = callNodeProvider;
        }

        @Override
        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            InlineInvokePlugin.InlineInfo inlineInfo = super.shouldInlineInvoke(builder, original, arguments);
            if (original.equals(this.callTargetCallDirect)) {
                ValueNode arg0 = arguments[1];
                if (!arg0.isConstant()) {
                    GraalError.shouldNotReachHere("The direct call node does not resolve to a constant!");
                }
                this.lastDirectCallNode = (JavaConstant)arg0.asConstant();
            }
            return inlineInfo;
        }

        @Override
        public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod original, Invoke invoke) {
            if (original.equals(this.callBoundary)) {
                if (this.lastDirectCallNode == null) {
                    return;
                }
                TruffleCallNode truffleCallNode = this.callNodeProvider.findCallNode(this.lastDirectCallNode);
                this.truffleCallNodeToInvoke.put((Object)truffleCallNode, (Object)invoke);
                this.lastDirectCallNode = null;
            }
        }

        public EconomicMap<TruffleCallNode, Invoke> getTruffleCallNodeToInvoke() {
            return this.truffleCallNodeToInvoke;
        }
    }

    static class Entry {
        final StructuredGraph graph;
        final EconomicMap<TruffleCallNode, Invoke> truffleCallNodeToInvoke;

        Entry(StructuredGraph graph, EconomicMap<TruffleCallNode, Invoke> truffleCallNodeToInvoke) {
            this.graph = graph;
            this.truffleCallNodeToInvoke = truffleCallNodeToInvoke;
        }
    }
}

