/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.debug;

import java.util.LinkedHashMap;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.GraalCompilerOptions;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;

public final class TraceCompilationFailureListener
implements TruffleCompilerListener {
    public static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }

    @Override
    public void onGraalTierFinished(CompilableTruffleAST compilable, TruffleCompilerListener.GraphInfo graph) {
    }

    @Override
    public void onTruffleTierFinished(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graph) {
    }

    @Override
    public void onSuccess(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo) {
    }

    @Override
    public void onFailure(CompilableTruffleAST compilable, String reason, boolean bailout, boolean permanentBailout) {
        if (TraceCompilationFailureListener.isPermanentFailure(bailout, permanentBailout) || TraceCompilationFailureListener.bailoutActionIsPrintOrGreater()) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("Reason", reason);
            TruffleCompilerRuntime.getRuntime().logEvent(0, "opt fail", compilable.toString(), properties);
        }
    }

    private static boolean bailoutActionIsPrintOrGreater() {
        OptionValues options = TruffleCompilerOptions.getOptions();
        return GraalCompilerOptions.CompilationBailoutAsFailure.getValue(options) != false && ((CompilationWrapper.ExceptionAction)((Object)GraalCompilerOptions.CompilationFailureAction.getValue(options))).ordinal() >= CompilationWrapper.ExceptionAction.Print.ordinal();
    }
}

