/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationPrinter;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.GraalCompiler;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompilationRequestIdentifier;
import org.graalvm.compiler.core.common.RetryableBailoutException;
import org.graalvm.compiler.core.common.util.CompilationAlarm;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.MemUseTrackerKey;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleCompilationIdentifier;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.compiler.TruffleDebugContextImpl;
import org.graalvm.compiler.truffle.compiler.debug.TraceCompilationFailureListener;
import org.graalvm.compiler.truffle.compiler.nodes.TruffleAssumption;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentPhase;

public abstract class TruffleCompilerImpl
implements TruffleCompiler {
    protected final Providers lastTierProviders;
    protected final Suites lastTierSuites;
    protected final GraphBuilderConfiguration config;
    protected final LIRSuites lastTierLirSuites;
    protected final Providers firstTierProviders;
    protected final Suites firstTierSuites;
    protected final LIRSuites firstTierLirSuites;
    protected final PartialEvaluator partialEvaluator;
    protected final Backend backend;
    protected final SnippetReflectionProvider snippetReflection;
    protected final TrufflePostCodeInstallationTaskFactory codeInstallationTaskFactory;
    public static final OptimisticOptimizations Optimizations = OptimisticOptimizations.ALL.remove(OptimisticOptimizations.Optimization.UseExceptionProbability, OptimisticOptimizations.Optimization.RemoveNeverExecutedCode, OptimisticOptimizations.Optimization.UseTypeCheckedInlining, OptimisticOptimizations.Optimization.UseTypeCheckHints);
    public static final TimerKey PartialEvaluationTime = DebugContext.timer("PartialEvaluationTime");
    public static final TimerKey CompilationTime = DebugContext.timer("CompilationTime");
    public static final TimerKey CodeInstallationTime = DebugContext.timer("CodeInstallation");
    public static final MemUseTrackerKey PartialEvaluationMemUse = DebugContext.memUseTracker("TrufflePartialEvaluationMemUse");
    public static final MemUseTrackerKey CompilationMemUse = DebugContext.memUseTracker("TruffleCompilationMemUse");
    public static final MemUseTrackerKey CodeInstallationMemUse = DebugContext.memUseTracker("TruffleCodeInstallationMemUse");

    public TruffleCompilerImpl(TruffleCompilerRuntime runtime, GraphBuilderConfiguration.Plugins plugins, Suites lastTierSuites, LIRSuites lastTierLirSuites, Backend backend, Suites firstTierSuites, LIRSuites firstTierLirSuites, Providers firstTierProviders, SnippetReflectionProvider snippetReflection) {
        this.backend = backend;
        this.snippetReflection = snippetReflection;
        this.lastTierProviders = backend.getProviders();
        this.lastTierSuites = lastTierSuites;
        this.lastTierLirSuites = lastTierLirSuites;
        this.codeInstallationTaskFactory = new TrufflePostCodeInstallationTaskFactory();
        backend.addCodeInstallationTask(this.codeInstallationTaskFactory);
        ResolvedJavaType[] skippedExceptionTypes = this.getSkippedExceptionTypes(runtime);
        boolean needSourcePositions = TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleEnableInfopoints) != false || TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleInstrumentBranches) != false || TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleInstrumentBoundaries) != false;
        GraphBuilderConfiguration baseConfig = GraphBuilderConfiguration.getDefault(new GraphBuilderConfiguration.Plugins(plugins)).withNodeSourcePosition(needSourcePositions);
        this.config = baseConfig.withSkippedExceptionTypes(skippedExceptionTypes).withOmitAssertions(TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleExcludeAssertions)).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.ExplicitOnly);
        this.partialEvaluator = this.createPartialEvaluator();
        this.firstTierProviders = firstTierProviders;
        this.firstTierSuites = firstTierSuites;
        this.firstTierLirSuites = firstTierLirSuites;
    }

    private ResolvedJavaType[] getSkippedExceptionTypes(TruffleCompilerRuntime runtime) {
        MetaAccessProvider metaAccess = this.lastTierProviders.getMetaAccess();
        ResolvedJavaType[] head = metaAccess.lookupJavaTypes(new Class[]{ArithmeticException.class, IllegalArgumentException.class, VirtualMachineError.class, IndexOutOfBoundsException.class, ClassCastException.class, BufferUnderflowException.class, BufferOverflowException.class});
        ResolvedJavaType[] tail = new ResolvedJavaType[]{runtime.resolveType(metaAccess, "com.oracle.truffle.api.nodes.UnexpectedResultException"), runtime.resolveType(metaAccess, "com.oracle.truffle.api.nodes.SlowPathException")};
        ResolvedJavaType[] skippedExceptionTypes = new ResolvedJavaType[head.length + tail.length];
        System.arraycopy(head, 0, skippedExceptionTypes, 0, head.length);
        System.arraycopy(tail, 0, skippedExceptionTypes, head.length, tail.length);
        return skippedExceptionTypes;
    }

    public Backend getBackend() {
        return this.backend;
    }

    protected abstract PartialEvaluator createPartialEvaluator();

    public abstract TruffleCompilationIdentifier createCompilationIdentifier(CompilableTruffleAST var1);

    protected abstract DebugContext createDebugContext(OptionValues var1, CompilationIdentifier var2, CompilableTruffleAST var3, PrintStream var4);

    @Override
    public final TruffleCompilation openCompilation(CompilableTruffleAST compilable) {
        return this.createCompilationIdentifier(compilable);
    }

    @Override
    public final TruffleDebugContext openDebugContext(Map<String, Object> options, TruffleCompilation compilation) {
        try (TruffleCompilerOptions.TruffleOptionsOverrideScope optionsScope = TruffleCompilerOptions.overrideOptions(options);){
            DebugContext debugContext;
            OptionValues optionValues = optionsScope.getOptions();
            if (compilation == null) {
                debugContext = DebugContext.create(optionValues, DebugHandlersFactory.LOADER);
            } else {
                TruffleCompilationIdentifier ident = TruffleCompilerImpl.asTruffleCompilationIdentifier(compilation);
                CompilableTruffleAST compilable = ident.getCompilable();
                debugContext = this.createDebugContext(optionValues, ident, compilable, DebugContext.DEFAULT_LOG_STREAM);
            }
            TruffleDebugContextImpl truffleDebugContextImpl = new TruffleDebugContextImpl(debugContext);
            return truffleDebugContextImpl;
        }
    }

    private static TruffleCompilationIdentifier asTruffleCompilationIdentifier(TruffleCompilation compilation) {
        if (compilation == null || compilation instanceof TruffleCompilationIdentifier) {
            return (TruffleCompilationIdentifier)compilation;
        }
        throw new IllegalArgumentException("The compilation must be instanceof " + TruffleCompilationIdentifier.class.getSimpleName() + ", got: " + compilation.getClass());
    }

    @Override
    public final void doCompile(TruffleDebugContext truffleDebug, TruffleCompilation compilation, Map<String, Object> optionsMap, TruffleInliningPlan inliningPlan, TruffleCompilationTask task, TruffleCompilerListener inListener) {
        block53: {
            Objects.requireNonNull(compilation, "Compilation must be non null.");
            try (TruffleCompilerOptions.TruffleOptionsOverrideScope optionsScope = TruffleCompilerOptions.overrideOptions(optionsMap);){
                TruffleCompilationIdentifier compilationId = TruffleCompilerImpl.asTruffleCompilationIdentifier(compilation);
                CompilableTruffleAST compilable = compilationId.getCompilable();
                OptionValues optionValues = optionsScope.getOptions();
                boolean usingCallersDebug = truffleDebug instanceof TruffleDebugContextImpl;
                if (usingCallersDebug) {
                    DebugContext callerDebug = ((TruffleDebugContextImpl)truffleDebug).debugContext;
                    try (DebugContext.Scope s = TruffleCompilerImpl.maybeOpenTruffleScope(compilable, callerDebug);){
                        this.actuallyCompile(inliningPlan, task, inListener, compilationId, compilable, callerDebug);
                        break block53;
                    }
                    catch (Throwable e) {
                        TruffleCompilerImpl.notifyCompilableOfFailure(compilable, e);
                    }
                    break block53;
                }
                try (DebugContext graalDebug = this.createDebugContext(optionValues, compilationId, compilable, DebugContext.DEFAULT_LOG_STREAM);
                     DebugContext.Scope s = TruffleCompilerImpl.maybeOpenTruffleScope(compilable, graalDebug);){
                    this.actuallyCompile(inliningPlan, task, inListener, compilationId, compilable, graalDebug);
                }
                catch (Throwable e) {
                    TruffleCompilerImpl.notifyCompilableOfFailure(compilable, e);
                }
            }
        }
    }

    private void actuallyCompile(TruffleInliningPlan inliningPlan, TruffleCompilationTask task, TruffleCompilerListener inListener, TruffleCompilationIdentifier compilationId, CompilableTruffleAST compilable, DebugContext graalDebug) {
        TruffleCompilerListenerPair listener = inListener == null ? null : new TruffleCompilerListenerPair(new TraceCompilationFailureListener(), inListener);
        TruffleCompilationWrapper truffleCompilationWrapper = new TruffleCompilationWrapper(this.getDebugOutputDirectory(), this.getCompilationProblemsPerAction(), compilable, task == null ? null : new CancellableTruffleCompilationTask(task), inliningPlan, compilationId, listener);
        truffleCompilationWrapper.run(graalDebug);
    }

    private static DebugContext.Scope maybeOpenTruffleScope(CompilableTruffleAST compilable, DebugContext debug) throws Throwable {
        if (debug.getCurrentScopeName().endsWith(".Truffle")) {
            return null;
        }
        return debug.scope((Object)"Truffle", new TruffleDebugJavaMethod(compilable));
    }

    private static void notifyCompilableOfFailure(CompilableTruffleAST compilable, final Throwable e) {
        BailoutException bailout = e instanceof BailoutException ? (BailoutException)e : null;
        boolean permanentBailout = bailout != null ? bailout.isPermanent() : false;
        Supplier<String> reasonAndStackTrace = new Supplier<String>(){

            @Override
            public String get() {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                return sw.toString();
            }
        };
        compilable.onCompilationFailed(reasonAndStackTrace, bailout != null, permanentBailout);
    }

    @Override
    public void shutdown() {
        InstrumentPhase.Instrumentation ins = this.partialEvaluator.instrumentation;
        if (ins != null) {
            OptionValues options = TruffleCompilerOptions.getOptions();
            if (TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleInstrumentBranches).booleanValue() || TruffleCompilerOptions.getValue(TruffleCompilerOptions.TruffleInstrumentBoundaries).booleanValue()) {
                ins.dumpAccessTable(options);
            }
        }
    }

    protected abstract DiagnosticsOutputDirectory getDebugOutputDirectory();

    protected abstract Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction();

    public void compileAST(DebugContext debug, CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, CompilationIdentifier compilationId, CancellableTruffleCompilationTask task, TruffleCompilerListener listener) {
        CompilationPrinter printer = CompilationPrinter.begin(debug.getOptions(), compilationId, new TruffleDebugJavaMethod(compilable), -1);
        StructuredGraph graph = null;
        try (CompilationAlarm alarm = CompilationAlarm.trackCompilationPeriod(debug.getOptions());){
            PhaseSuite<HighTierContext> graphBuilderSuite = this.createGraphBuilderSuite();
            SpeculationLog speculationLog = compilable.getCompilationSpeculationLog();
            if (speculationLog != null) {
                speculationLog.collectFailedSpeculations();
            }
            try (DebugCloseable a = PartialEvaluationTime.start(debug);
                 DebugCloseable c = PartialEvaluationMemUse.start(debug);){
                graph = this.partialEvaluator.createGraph(debug, compilable, inliningPlan, StructuredGraph.AllowAssumptions.YES, compilationId, speculationLog, task);
            }
            if (task != null && task.isCancelled()) {
                return;
            }
            if (listener != null) {
                listener.onTruffleTierFinished(compilable, inliningPlan, new GraphInfoImpl(graph));
            }
            String compilationName = compilable.toString() + (task != null && task.isFirstTier() ? "#1" : "#2");
            CompilationResult compilationResult = this.compilePEGraph(graph, compilationName, graphBuilderSuite, compilable, CompilationRequestIdentifier.asCompilationRequest(compilationId), listener, task);
            if (listener != null) {
                listener.onSuccess(compilable, inliningPlan, new GraphInfoImpl(graph), new CompilationResultInfoImpl(compilationResult));
            }
            printer.finish(compilationResult);
        }
        catch (Throwable t) {
            if (listener != null) {
                BailoutException bailout = t instanceof BailoutException ? (BailoutException)t : null;
                boolean permanentBailout = bailout != null ? bailout.isPermanent() : false;
                listener.onFailure(compilable, t.toString(), bailout != null, permanentBailout);
            }
            throw t;
        }
    }

    public CompilationResult compilePEGraph(StructuredGraph graph, String name, PhaseSuite<HighTierContext> graphBuilderSuite, CompilableTruffleAST compilable, CompilationRequest compilationRequest, TruffleCompilerListener listener, TruffleCompilationTask task) {
        Throwable throwable;
        Throwable throwable2;
        DebugCloseable a;
        DebugContext debug = graph.getDebug();
        try (DebugContext.Scope s = debug.scope("TruffleFinal");){
            debug.dump(1, graph, "After TruffleTier");
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        CompilationResult result = null;
        try {
            a = CompilationTime.start(debug);
            throwable2 = null;
            try {
                throwable = null;
                try (DebugContext.Scope s = debug.scope("TruffleGraal.GraalCompiler", graph, this.lastTierProviders.getCodeCache());
                     DebugCloseable c2 = CompilationMemUse.start(debug);){
                    Suites selectedSuites = this.lastTierSuites;
                    LIRSuites selectedLirSuites = this.lastTierLirSuites;
                    Providers selectedProviders = this.lastTierProviders;
                    if (task != null && !task.isLastTier()) {
                        selectedSuites = this.firstTierSuites;
                        selectedLirSuites = this.firstTierLirSuites;
                        selectedProviders = this.firstTierProviders;
                    }
                    CompilationResult compilationResult = this.createCompilationResult(name, graph.compilationId(), compilable);
                    result = GraalCompiler.compileGraph(graph, graph.method(), selectedProviders, this.backend, graphBuilderSuite, Optimizations, graph.getProfilingInfo(), selectedSuites, selectedLirSuites, compilationResult, CompilationResultBuilderFactory.Default, false);
                }
                catch (Throwable c2) {
                    throwable = c2;
                    throw c2;
                }
            }
            catch (Throwable s) {
                throwable2 = s;
                throw s;
            }
            finally {
                if (a != null) {
                    if (throwable2 != null) {
                        try {
                            a.close();
                        }
                        catch (Throwable s) {
                            throwable2.addSuppressed(s);
                        }
                    } else {
                        a.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        if (listener != null) {
            listener.onGraalTierFinished(compilable, new GraphInfoImpl(graph));
        }
        try {
            a = CodeInstallationTime.start(debug);
            throwable2 = null;
            try {
                throwable = null;
                try (DebugCloseable c = CodeInstallationMemUse.start(debug);){
                    InstalledCode installedCode = this.createInstalledCode(compilable);
                    assert (graph.getSpeculationLog() == result.getSpeculationLog());
                    this.backend.createInstalledCode(debug, graph.method(), compilationRequest, result, installedCode, false);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                if (a != null) {
                    if (throwable2 != null) {
                        try {
                            a.close();
                        }
                        catch (Throwable throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                    } else {
                        a.close();
                    }
                }
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return result;
    }

    protected abstract InstalledCode createInstalledCode(CompilableTruffleAST var1);

    protected boolean soleExecutionEntryPoint(InstalledCode installedCode) {
        return true;
    }

    protected void exitHostVM(int status) {
        System.exit(status);
    }

    protected abstract CompilationResult createCompilationResult(String var1, CompilationIdentifier var2, CompilableTruffleAST var3);

    public abstract PhaseSuite<HighTierContext> createGraphBuilderSuite();

    public PartialEvaluator getPartialEvaluator() {
        return this.partialEvaluator;
    }

    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        return this.snippetReflection.asObject(CompilableTruffleAST.class, constant);
    }

    protected CompilableTruffleAST getCompilable(CompilationResult result) {
        return null;
    }

    protected void afterCodeInstallation(CompilationResult result, InstalledCode installedCode) {
    }

    public final SnippetReflectionProvider getSnippetReflection() {
        return this.snippetReflection;
    }

    private static final class TruffleCompilerListenerPair
    implements TruffleCompilerListener {
        private final TruffleCompilerListener first;
        private final TruffleCompilerListener second;

        TruffleCompilerListenerPair(TruffleCompilerListener first, TruffleCompilerListener second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void onGraalTierFinished(CompilableTruffleAST compilable, TruffleCompilerListener.GraphInfo graph) {
            this.first.onGraalTierFinished(compilable, graph);
            this.second.onGraalTierFinished(compilable, graph);
        }

        @Override
        public void onTruffleTierFinished(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graph) {
            this.first.onTruffleTierFinished(compilable, inliningPlan, graph);
            this.second.onTruffleTierFinished(compilable, inliningPlan, graph);
        }

        @Override
        public void onSuccess(CompilableTruffleAST compilable, TruffleInliningPlan inliningPlan, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo) {
            this.first.onSuccess(compilable, inliningPlan, graphInfo, compilationResultInfo);
            this.second.onSuccess(compilable, inliningPlan, graphInfo, compilationResultInfo);
        }

        @Override
        public void onFailure(CompilableTruffleAST compilable, String reason, boolean bailout, boolean permanentBailout) {
            this.first.onFailure(compilable, reason, bailout, permanentBailout);
            this.second.onFailure(compilable, reason, bailout, permanentBailout);
        }
    }

    static final class CancellableTruffleCompilationTask
    implements TruffleCompilationTask,
    Cancellable {
        private final TruffleCompilationTask delegate;

        CancellableTruffleCompilationTask(TruffleCompilationTask delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isLastTier() {
            return this.delegate.isLastTier();
        }
    }

    private class TrufflePostCodeInstallationTaskFactory
    extends Backend.CodeInstallationTaskFactory {
        private TrufflePostCodeInstallationTaskFactory() {
        }

        @Override
        public Backend.CodeInstallationTask create() {
            return new TruffleCodeInstallationTask();
        }
    }

    private final class TruffleCodeInstallationTask
    extends Backend.CodeInstallationTask {
        private final List<Consumer<OptimizedAssumptionDependency>> optimizedAssumptions = new ArrayList<Consumer<OptimizedAssumptionDependency>>();

        private TruffleCodeInstallationTask() {
        }

        @Override
        public void preProcess(CompilationResult result) {
            if (result == null || result.getAssumptions() == null) {
                return;
            }
            TruffleCompilerRuntime runtime = TruffleCompilerRuntime.getRuntime();
            ArrayList<Assumptions.Assumption> newAssumptions = new ArrayList<Assumptions.Assumption>();
            for (Assumptions.Assumption assumption : result.getAssumptions()) {
                if (assumption != null && assumption instanceof TruffleAssumption) {
                    TruffleAssumption truffleAssumption = (TruffleAssumption)assumption;
                    Consumer<OptimizedAssumptionDependency> dep = runtime.registerOptimizedAssumptionDependency(truffleAssumption.getAssumption());
                    if (dep == null) {
                        this.notifyAssumptions(null);
                        throw new RetryableBailoutException("Assumption invalidated while compiling code: %s", new Object[]{truffleAssumption});
                    }
                    this.optimizedAssumptions.add(dep);
                    continue;
                }
                newAssumptions.add(assumption);
            }
            result.setAssumptions(newAssumptions.toArray(new Assumptions.Assumption[newAssumptions.size()]));
        }

        @Override
        public void postProcess(CompilationResult compilationResult, final InstalledCode installedCode) {
            TruffleCompilerImpl.this.afterCodeInstallation(compilationResult, installedCode);
            if (!this.optimizedAssumptions.isEmpty()) {
                CompilableTruffleAST compilable;
                OptimizedAssumptionDependency dependency = installedCode instanceof OptimizedAssumptionDependency ? (OptimizedAssumptionDependency)installedCode : (installedCode instanceof OptimizedAssumptionDependency.Access ? ((OptimizedAssumptionDependency.Access)installedCode).getDependency() : ((compilable = TruffleCompilerImpl.this.getCompilable(compilationResult)) instanceof OptimizedAssumptionDependency ? (OptimizedAssumptionDependency)((Object)compilable) : new OptimizedAssumptionDependency(){

                    @Override
                    public void invalidate() {
                        installedCode.invalidate();
                    }

                    @Override
                    public boolean isValid() {
                        return installedCode.isValid();
                    }

                    @Override
                    public boolean soleExecutionEntryPoint() {
                        return TruffleCompilerImpl.this.soleExecutionEntryPoint(installedCode);
                    }

                    public String toString() {
                        return installedCode.toString();
                    }
                }));
                this.notifyAssumptions(dependency);
            }
        }

        @Override
        public void installFailed(Throwable t) {
            this.notifyAssumptions(null);
        }

        private void notifyAssumptions(OptimizedAssumptionDependency dependency) {
            ArrayList<Throwable> errors = null;
            for (Consumer<OptimizedAssumptionDependency> entry : this.optimizedAssumptions) {
                try {
                    entry.accept(dependency);
                }
                catch (Throwable t) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(t);
                }
            }
            if (errors != null) {
                StringBuilder sb = new StringBuilder("There were errors while notifying assumptions:");
                for (Throwable e : errors) {
                    sb.append(System.lineSeparator()).append("  ").append(e);
                }
                throw new RetryableBailoutException(sb.toString());
            }
        }
    }

    private final class TruffleCompilationWrapper
    extends CompilationWrapper<Void> {
        private final CompilableTruffleAST compilable;
        private final TruffleInliningPlan inliningPlan;
        private final CancellableTruffleCompilationTask task;
        private final TruffleCompilerListener listener;
        private final CompilationIdentifier compilationId;

        private TruffleCompilationWrapper(DiagnosticsOutputDirectory outputDirectory, Map<CompilationWrapper.ExceptionAction, Integer> problemsHandledPerAction, CompilableTruffleAST optimizedCallTarget, CancellableTruffleCompilationTask task, TruffleInliningPlan inliningPlan, CompilationIdentifier compilationId, TruffleCompilerListener listener) {
            super(outputDirectory, problemsHandledPerAction);
            this.compilable = optimizedCallTarget;
            this.inliningPlan = inliningPlan;
            this.task = task;
            this.listener = listener;
            this.compilationId = compilationId;
        }

        @Override
        public String toString() {
            return this.compilable.toString();
        }

        @Override
        protected CompilationWrapper.ExceptionAction lookupAction(OptionValues options, Throwable cause) {
            if ((!(cause instanceof BailoutException) || ((BailoutException)cause).isPermanent()) && TruffleCompilerOptions.areTruffleCompilationExceptionsFatal()) {
                return CompilationWrapper.ExceptionAction.Diagnose;
            }
            return super.lookupAction(options, cause);
        }

        @Override
        protected DebugContext createRetryDebugContext(DebugContext initialDebug, OptionValues options, PrintStream logStream) {
            return TruffleCompilerImpl.this.createDebugContext(options, this.compilationId, this.compilable, logStream);
        }

        @Override
        protected void exitHostVM(int status) {
            TruffleCompilerImpl.this.exitHostVM(status);
        }

        @Override
        protected Void handleException(Throwable t) {
            TruffleCompilerImpl.notifyCompilableOfFailure(this.compilable, t);
            return null;
        }

        @Override
        protected Void performCompilation(DebugContext debug) {
            TruffleCompilerImpl.this.compileAST(debug, this.compilable, this.inliningPlan, this.compilationId, this.task, this.listener);
            return null;
        }
    }

    static class CompilationResultInfoImpl
    implements TruffleCompilerListener.CompilationResultInfo {
        private final CompilationResult compResult;

        CompilationResultInfoImpl(CompilationResult compResult) {
            this.compResult = compResult;
        }

        @Override
        public int getTargetCodeSize() {
            return this.compResult.getTargetCodeSize();
        }

        @Override
        public int getTotalFrameSize() {
            return this.compResult.getTotalFrameSize();
        }

        @Override
        public int getExceptionHandlersCount() {
            return this.compResult.getExceptionHandlers().size();
        }

        @Override
        public int getInfopointsCount() {
            return this.compResult.getInfopoints().size();
        }

        @Override
        public String[] getInfopoints() {
            List<Infopoint> infopoints = this.compResult.getInfopoints();
            String[] res = new String[infopoints.size()];
            int i = 0;
            for (Infopoint infopoint : infopoints) {
                res[i++] = infopoint.reason.toString();
            }
            return res;
        }

        @Override
        public int getMarksCount() {
            return this.compResult.getMarks().size();
        }

        @Override
        public int getDataPatchesCount() {
            return this.compResult.getDataPatches().size();
        }
    }

    static class GraphInfoImpl
    implements TruffleCompilerListener.GraphInfo {
        private final StructuredGraph graph;

        GraphInfoImpl(StructuredGraph graph) {
            this.graph = graph;
        }

        @Override
        public int getNodeCount() {
            return this.graph.getNodeCount();
        }

        @Override
        public String[] getNodeTypes(boolean simpleNames) {
            String[] res = new String[this.graph.getNodeCount()];
            int i = 0;
            for (Node node : this.graph.getNodes()) {
                res[i++] = simpleNames ? node.getClass().getSimpleName() : node.getClass().getName();
            }
            return res;
        }
    }
}

