/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common.hotspot.libgraal;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.graalvm.compiler.truffle.common.CallNodeProvider;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpotRepeated;

@Repeatable(value=SVMToHotSpotRepeated.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface SVMToHotSpot {
    public Id value();

    public static enum Id {
        AsCompilableTruffleAST(CompilableTruffleAST.class, HotSpotTruffleCompilerRuntime.class, Long.TYPE),
        AsJavaConstant(Long.TYPE, CompilableTruffleAST.class),
        CallNodeHashCode(Integer.TYPE, TruffleCallNode.class),
        CancelInstalledTask(Void.TYPE, CompilableTruffleAST.class),
        CompilableToString(String.class, CompilableTruffleAST.class),
        ConsumeOptimizedAssumptionDependency(Void.TYPE, Consumer.class, OptimizedAssumptionDependency.class),
        CreateException(Throwable.class, String.class),
        CreateInliningPlan(TruffleInliningPlan.class, HotSpotTruffleCompilerRuntime.class, CompilableTruffleAST.class, TruffleCompilationTask.class),
        CreateStringSupplier(Supplier.class, Long.TYPE),
        FindCallNode(TruffleCallNode.class, CallNodeProvider.class, Long.TYPE),
        FindDecision(TruffleInliningPlan.Decision.class, TruffleInliningPlan.class, Long.TYPE),
        GetCallCount(Integer.TYPE, TruffleCallNode.class),
        GetCallNodes(TruffleCallNode[].class, CompilableTruffleAST.class),
        GetCallTargetForCallNode(Long.TYPE, HotSpotTruffleCompilerRuntime.class, Long.TYPE),
        GetCompilableCallCount(Integer.TYPE, CompilableTruffleAST.class),
        GetCompilableName(String.class, CompilableTruffleAST.class),
        GetConstantFieldInfo(Integer.TYPE, HotSpotTruffleCompilerRuntime.class, Long.TYPE, Boolean.TYPE, Integer.TYPE),
        GetCurrentCallTarget(CompilableTruffleAST.class, TruffleCallNode.class),
        GetDescription(String.class, TruffleSourceLanguagePosition.class),
        GetFailedSpeculationsAddress(Long.TYPE, CompilableTruffleAST.class),
        GetFrameSlotKindTagForJavaKind(Integer.TYPE, HotSpotTruffleCompilerRuntime.class, Integer.TYPE),
        GetFrameSlotKindTagsCount(Integer.TYPE, HotSpotTruffleCompilerRuntime.class),
        GetInlineKind(Integer.TYPE, HotSpotTruffleCompilerRuntime.class, Long.TYPE, Boolean.TYPE),
        GetJavaKindForFrameSlotKind(Integer.TYPE, HotSpotTruffleCompilerRuntime.class, Integer.TYPE),
        GetKnownCallSiteCount(Integer.TYPE, CompilableTruffleAST.class),
        GetLanguage(String.class, TruffleSourceLanguagePosition.class),
        GetLineNumber(Integer.TYPE, TruffleSourceLanguagePosition.class),
        GetLoopExplosionKind(Integer.TYPE, HotSpotTruffleCompilerRuntime.class, Long.TYPE),
        GetNodeRewritingAssumption(Long.TYPE, TruffleInliningPlan.Decision.class),
        GetNonTrivialNodeCount(Integer.TYPE, CompilableTruffleAST.class),
        GetOffsetEnd(Integer.TYPE, TruffleSourceLanguagePosition.class),
        GetOffsetStart(Integer.TYPE, TruffleSourceLanguagePosition.class),
        GetPosition(TruffleSourceLanguagePosition.class, TruffleInliningPlan.class, Long.TYPE),
        GetStackTrace(StackTraceElement[].class, Throwable.class),
        GetStackTraceElementClassName(String.class, StackTraceElement.class),
        GetStackTraceElementFileName(String.class, StackTraceElement.class),
        GetStackTraceElementLineNumber(Integer.TYPE, StackTraceElement.class),
        GetStackTraceElementMethodName(String.class, StackTraceElement.class),
        GetSuppliedString(String.class, Supplier.class),
        GetTargetName(String.class, TruffleInliningPlan.Decision.class),
        GetThrowableMessage(String.class, Throwable.class),
        GetTruffleCallBoundaryMethods(long[].class, HotSpotTruffleCompilerRuntime.class),
        GetURI(String.class, TruffleSourceLanguagePosition.class),
        IsCancelled(Boolean.TYPE, TruffleCompilationTask.class),
        IsInliningForced(Boolean.TYPE, TruffleCallNode.class),
        IsLastTier(Boolean.TYPE, TruffleCompilationTask.class),
        IsSameOrSplit(Boolean.TYPE, CompilableTruffleAST.class, CompilableTruffleAST.class),
        IsTargetStable(Boolean.TYPE, TruffleInliningPlan.Decision.class),
        IsTruffleBoundary(Boolean.TYPE, HotSpotTruffleCompilerRuntime.class, Long.TYPE),
        IsValueType(Boolean.TYPE, HotSpotTruffleCompilerRuntime.class, Long.TYPE),
        Log(Void.TYPE, HotSpotTruffleCompilerRuntime.class, String.class),
        OnCodeInstallation(Void.TYPE, HotSpotTruffleCompilerRuntime.class, CompilableTruffleAST.class, Long.TYPE),
        OnCompilationFailed(Void.TYPE, CompilableTruffleAST.class, Supplier.class, Boolean.TYPE, Boolean.TYPE),
        OnFailure(Void.TYPE, TruffleCompilerListener.class, CompilableTruffleAST.class, String.class, Boolean.TYPE, Boolean.TYPE),
        OnGraalTierFinished(Void.TYPE, TruffleCompilerListener.class, CompilableTruffleAST.class, Long.TYPE),
        OnSuccess(Void.TYPE, TruffleCompilerListener.class, CompilableTruffleAST.class, TruffleInliningPlan.class, Long.TYPE, Long.TYPE),
        OnTruffleTierFinished(Void.TYPE, TruffleCompilerListener.class, CompilableTruffleAST.class, TruffleInliningPlan.class, Long.TYPE),
        RegisterOptimizedAssumptionDependency(Consumer.class, HotSpotTruffleCompilerRuntime.class, Long.TYPE),
        ShouldInline(Boolean.TYPE, TruffleInliningPlan.Decision.class),
        UpdateStackTrace(Throwable.class, Throwable.class, String[].class);

        private final String signature;
        private final String methodName;
        private final Class<?> returnType;
        private final Class<?>[] parameterTypes;

        public String getSignature() {
            return this.signature;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.methodName + this.signature;
        }

        private Id(Class<?> returnType, Class<?> ... parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            StringBuilder builder = new StringBuilder("(");
            for (Class<?> type : parameterTypes) {
                Id.encodeType(type, builder);
            }
            builder.append(")");
            Id.encodeType(returnType, builder);
            this.signature = builder.toString();
            this.methodName = Character.toLowerCase(this.name().charAt(0)) + this.name().substring(1);
        }

        private static void encodeType(Class<?> type, StringBuilder buf) {
            String desc;
            if (type == Boolean.TYPE) {
                desc = "Z";
            } else if (type == Byte.TYPE) {
                desc = "B";
            } else if (type == Character.TYPE) {
                desc = "C";
            } else if (type == Short.TYPE) {
                desc = "S";
            } else if (type == Integer.TYPE) {
                desc = "I";
            } else if (type == Long.TYPE) {
                desc = "J";
            } else if (type == Float.TYPE) {
                desc = "F";
            } else if (type == Double.TYPE) {
                desc = "D";
            } else if (type == Void.TYPE) {
                desc = "V";
            } else {
                if (type.isArray()) {
                    buf.append('[');
                    Id.encodeType(type.getComponentType(), buf);
                    return;
                }
                desc = "L" + type.getName().replace('.', '/') + ";";
            }
            buf.append(desc);
        }
    }
}

