/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, cyclesRationale="add+cmp", size=NodeSize.SIZE_2)
public abstract class IntegerExactArithmeticSplitNode
extends ControlSplitNode
implements Simplifiable,
LIRLowerable {
    public static final NodeClass<IntegerExactArithmeticSplitNode> TYPE = NodeClass.create(IntegerExactArithmeticSplitNode.class);
    @Node.Successor
    AbstractBeginNode next;
    @Node.Successor
    AbstractBeginNode overflowSuccessor;
    @Node.Input
    ValueNode x;
    @Node.Input
    ValueNode y;

    protected IntegerExactArithmeticSplitNode(NodeClass<? extends IntegerExactArithmeticSplitNode> c, Stamp stamp, ValueNode x, ValueNode y, AbstractBeginNode next, AbstractBeginNode overflowSuccessor) {
        super((NodeClass<? extends ControlSplitNode>)c, stamp);
        this.x = x;
        this.y = y;
        this.overflowSuccessor = overflowSuccessor;
        this.next = next;
    }

    @Override
    public AbstractBeginNode getPrimarySuccessor() {
        return this.next;
    }

    @Override
    public double probability(AbstractBeginNode successor) {
        return successor == this.next ? 1.0 : 0.0;
    }

    @Override
    public boolean setProbability(AbstractBeginNode successor, double value) {
        return false;
    }

    public AbstractBeginNode getNext() {
        return this.next;
    }

    public AbstractBeginNode getOverflowSuccessor() {
        return this.overflowSuccessor;
    }

    public void setNext(AbstractBeginNode next) {
        this.updatePredecessor(this.next, next);
        this.next = next;
    }

    public void setOverflowSuccessor(AbstractBeginNode overflowSuccessor) {
        this.updatePredecessor(this.overflowSuccessor, overflowSuccessor);
        this.overflowSuccessor = overflowSuccessor;
    }

    public ValueNode getX() {
        return this.x;
    }

    public ValueNode getY() {
        return this.y;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.setResult(this, this.generateArithmetic(generator));
        generator.emitOverflowCheckBranch(this.getOverflowSuccessor(), this.getNext(), this.stamp, this.probability(this.getOverflowSuccessor()));
    }

    protected abstract Value generateArithmetic(NodeLIRBuilderTool var1);

    @Override
    public int getSuccessorCount() {
        return 2;
    }
}

