/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class ReverseBytesNode
extends UnaryNode
implements LIRLowerable {
    public static final NodeClass<ReverseBytesNode> TYPE = NodeClass.create(ReverseBytesNode.class);

    public ReverseBytesNode(ValueNode value) {
        super(TYPE, StampFactory.forKind(value.getStackKind()), value);
        assert (this.getStackKind() == JavaKind.Int || this.getStackKind() == JavaKind.Long);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        if (this.getStackKind() == JavaKind.Int) {
            long mask = CodeUtil.mask((int)JavaKind.Int.getBitCount());
            return IntegerStamp.stampForMask(valueStamp.getBits(), (long)Integer.reverseBytes((int)valueStamp.downMask()) & mask, (long)Integer.reverseBytes((int)valueStamp.upMask()) & mask);
        }
        if (this.getStackKind() == JavaKind.Long) {
            return IntegerStamp.stampForMask(valueStamp.getBits(), Long.reverseBytes(valueStamp.downMask()), Long.reverseBytes(valueStamp.upMask()));
        }
        return this.stamp(NodeView.DEFAULT);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isConstant()) {
            JavaConstant c = forValue.asJavaConstant();
            long reversed = this.getStackKind() == JavaKind.Int ? (long)Integer.reverseBytes(c.asInt()) : Long.reverseBytes(c.asLong());
            return ConstantNode.forIntegerKind(this.getStackKind(), reversed);
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Variable result = gen.getLIRGeneratorTool().emitByteSwap(gen.operand(this.getValue()));
        gen.setResult(this, (Value)result);
    }
}

