/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.GuardLoweringPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.common.RemoveValueProxyPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate", size=NodeSize.SIZE_UNKNOWN, sizeRationale="If this node is not optimized away it will be lowered to a call, which we cannot estimate")
public abstract class MacroNode
extends FixedWithNextNode
implements Lowerable,
Invokable {
    public static final NodeClass<MacroNode> TYPE = NodeClass.create(MacroNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    protected final int bci;
    protected final ResolvedJavaMethod targetMethod;
    protected final CallTargetNode.InvokeKind invokeKind;
    protected final StampPair returnStamp;

    protected MacroNode(NodeClass<? extends MacroNode> c, CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
        super((NodeClass<? extends FixedWithNextNode>)c, returnStamp != null ? returnStamp.getTrustedStamp() : null);
        this.assertArgumentCount(targetMethod, arguments);
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.bci = bci;
        this.targetMethod = targetMethod;
        this.returnStamp = returnStamp;
        this.invokeKind = invokeKind;
        assert (!BytecodeFrame.isPlaceholderBci((int)bci));
    }

    protected void assertArgumentCount(ResolvedJavaMethod method, ValueNode ... args) {
        assert (method.getSignature().getParameterCount(!method.isStatic()) == args.length);
    }

    public ValueNode getArgument(int i) {
        return (ValueNode)this.arguments.get(i);
    }

    public int getArgumentCount() {
        return this.arguments.size();
    }

    public ValueNode[] toArgumentArray() {
        return this.arguments.toArray((A[])new ValueNode[0]);
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public ResolvedJavaMethod getTargetMethod() {
        return this.targetMethod;
    }

    protected FrameState stateAfter() {
        return null;
    }

    @Override
    protected void afterClone(Node other) {
        this.updateInliningLogAfterClone(other);
    }

    @Override
    public FixedNode asFixedNode() {
        return this;
    }

    protected StructuredGraph getLoweredSnippetGraph(LoweringTool tool) {
        return null;
    }

    protected StructuredGraph lowerReplacement(StructuredGraph replacementGraph, LoweringTool tool) {
        StructuredGraph.GuardsStage guardsStage;
        CoreProviders c = tool.getProviders();
        if (!this.graph().hasValueProxies()) {
            new RemoveValueProxyPhase().apply(replacementGraph);
        }
        if (!(guardsStage = this.graph().getGuardsStage()).allowsFloatingGuards()) {
            new GuardLoweringPhase().apply(replacementGraph, null);
            if (guardsStage.areFrameStatesAtDeopts()) {
                new FrameStateAssignmentPhase().apply(replacementGraph);
            }
        }
        DebugContext debug = replacementGraph.getDebug();
        try (DebugContext.Scope s = debug.scope((Object)"LoweringSnippetTemplate", replacementGraph);){
            new LoweringPhase(CanonicalizerPhase.create(), tool.getLoweringStage()).apply(replacementGraph, c);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
        return replacementGraph;
    }

    @Override
    public void lower(LoweringTool tool) {
        StructuredGraph replacementGraph = this.getLoweredSnippetGraph(tool);
        InvokeNode invoke = this.replaceWithInvoke();
        assert (invoke.verify());
        if (replacementGraph != null) {
            ValueNode nonNullReceiver;
            if (!this.targetMethod.isStatic() && (nonNullReceiver = InliningUtil.nonNullReceiver(invoke)) instanceof Lowerable) {
                ((Lowerable)((Object)nonNullReceiver)).lower(tool);
            }
            InliningUtil.inline(invoke, replacementGraph, false, this.targetMethod, "Replace with graph.", "LoweringPhase");
            replacementGraph.getDebug().dump(4, (Object)this.graph(), "After inlining replacement %s", replacementGraph);
        } else {
            if (BytecodeFrame.isPlaceholderBci((int)invoke.bci())) {
                throw new GraalError("%s: cannot lower to invoke with placeholder BCI: %s", this.graph(), this);
            }
            if (invoke.stateAfter() == null) {
                ResolvedJavaMethod method = this.graph().method();
                if (!(Services.IS_IN_NATIVE_IMAGE || method.getAnnotation(MethodSubstitution.class) == null && method.getAnnotation(Snippet.class) == null)) {
                    throw new GraalError("%s macro created for call to %s in %s must be lowerable to a snippet or intrinsic graph. Maybe a macro node is not needed for this method in the current JDK?", this.getClass().getSimpleName(), this.targetMethod.format("%h.%n(%p)"), this.graph());
                }
                throw new GraalError("%s: cannot lower to invoke without state: %s", this.graph(), this);
            }
            invoke.lower(tool);
        }
    }

    public InvokeNode replaceWithInvoke() {
        try (DebugCloseable context = this.withNodeSourcePosition();){
            InvokeNode invoke = this.createInvoke();
            this.graph().replaceFixedWithFixed(this, invoke);
            InvokeNode invokeNode = invoke;
            return invokeNode;
        }
    }

    public LocationIdentity getLocationIdentity() {
        return LocationIdentity.any();
    }

    protected InvokeNode createInvoke() {
        MethodCallTargetNode callTarget = this.graph().add(new MethodCallTargetNode(this.invokeKind, this.targetMethod, this.arguments.toArray((A[])new ValueNode[this.arguments.size()]), this.returnStamp, null));
        InvokeNode invoke = this.graph().add(new InvokeNode((CallTargetNode)callTarget, this.bci, this.getLocationIdentity()));
        if (this.stateAfter() != null) {
            invoke.setStateAfter(this.stateAfter().duplicate());
            if (this.getStackKind() != JavaKind.Void) {
                invoke.stateAfter().replaceFirstInput(this, invoke);
            }
        }
        return invoke;
    }
}

