/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.Collections;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.replacements.nodes.MacroStateSplitNode;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_8)
public abstract class BasicObjectCloneNode
extends MacroStateSplitNode
implements VirtualizableAllocation,
ArrayLengthProvider {
    public static final NodeClass<BasicObjectCloneNode> TYPE = NodeClass.create(BasicObjectCloneNode.class);

    public BasicObjectCloneNode(NodeClass<? extends MacroNode> c, CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, int bci, StampPair returnStamp, ValueNode ... arguments) {
        super(c, invokeKind, targetMethod, bci, returnStamp, arguments);
        this.updateStamp(this.computeStamp(this.getObject()));
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.stamp.improveWith(this.computeStamp(this.getObject())));
    }

    protected Stamp computeStamp(ValueNode object) {
        Stamp objectStamp = object.stamp(NodeView.DEFAULT);
        if (objectStamp instanceof ObjectStamp) {
            objectStamp = objectStamp.join(StampFactory.objectNonNull());
        }
        return objectStamp;
    }

    public ValueNode getObject() {
        return (ValueNode)this.arguments.get(0);
    }

    protected ResolvedJavaType getConcreteType(Stamp forStamp) {
        if (!(forStamp instanceof ObjectStamp)) {
            return null;
        }
        ObjectStamp objectStamp = (ObjectStamp)forStamp;
        if (objectStamp.type() == null) {
            return null;
        }
        if (objectStamp.isExactType()) {
            return objectStamp.type().isCloneableWithAllocation() ? objectStamp.type() : null;
        }
        if (objectStamp.type().isArray()) {
            return objectStamp.type();
        }
        return null;
    }

    protected LoadFieldNode genLoadFieldNode(Assumptions assumptions, ValueNode originalAlias, ResolvedJavaField field) {
        return LoadFieldNode.create(assumptions, originalAlias, field);
    }

    protected LoadIndexedNode genLoadIndexedNode(Assumptions assumptions, ValueNode originalAlias, ValueNode index, JavaKind elementKind) {
        return new LoadIndexedNode(assumptions, originalAlias, index, null, elementKind);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode originalAlias = tool.getAlias(this.getObject());
        if (originalAlias instanceof VirtualObjectNode) {
            VirtualObjectNode originalVirtual = (VirtualObjectNode)originalAlias;
            if (originalVirtual.type().isCloneableWithAllocation()) {
                ValueNode[] newEntryState = new ValueNode[originalVirtual.entryCount()];
                for (int i = 0; i < newEntryState.length; ++i) {
                    newEntryState[i] = tool.getEntry(originalVirtual, i);
                }
                VirtualObjectNode newVirtual = originalVirtual.duplicate();
                tool.createVirtualObject(newVirtual, newEntryState, Collections.emptyList(), false);
                tool.replaceWithVirtual(newVirtual);
            }
        } else {
            ResolvedJavaType type = this.getConcreteType(originalAlias.stamp(NodeView.DEFAULT));
            if (type == null) {
                return;
            }
            if (!type.isArray()) {
                VirtualInstanceNode newVirtual = this.createVirtualInstanceNode(type, true);
                ResolvedJavaField[] fields = newVirtual.getFields();
                ValueNode[] state = new ValueNode[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    LoadFieldNode load = this.genLoadFieldNode(this.graph().getAssumptions(), originalAlias, fields[i]);
                    state[i] = load;
                    tool.addNode(load);
                }
                tool.createVirtualObject(newVirtual, state, Collections.emptyList(), false);
                tool.replaceWithVirtual(newVirtual);
            } else {
                ValueNode length = this.findLength(ArrayLengthProvider.FindLengthMode.SEARCH_ONLY, tool.getConstantReflection());
                if (length == null) {
                    return;
                }
                ValueNode lengthAlias = tool.getAlias(length);
                if (!lengthAlias.isConstant()) {
                    return;
                }
                int constantLength = lengthAlias.asJavaConstant().asInt();
                if (constantLength >= 0 && constantLength <= tool.getMaximumEntryCount()) {
                    ValueNode[] state = new ValueNode[constantLength];
                    ResolvedJavaType componentType = type.getComponentType();
                    for (int i = 0; i < constantLength; ++i) {
                        ConstantNode index = ConstantNode.forInt(i);
                        LoadIndexedNode load = this.genLoadIndexedNode(this.graph().getAssumptions(), originalAlias, index, componentType.getJavaKind());
                        state[i] = load;
                        tool.addNode(index);
                        tool.addNode(load);
                    }
                    VirtualArrayNode virtualObject = new VirtualArrayNode(componentType, constantLength);
                    tool.createVirtualObject(virtualObject, state, Collections.emptyList(), false);
                    tool.replaceWithVirtual(virtualObject);
                }
            }
        }
    }

    protected VirtualInstanceNode createVirtualInstanceNode(ResolvedJavaType type, boolean hasIdentity) {
        return new VirtualInstanceNode(type, hasIdentity);
    }

    @Override
    public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        return GraphUtil.arrayLength(this.getObject(), mode, constantReflection);
    }
}

