/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.MemoryNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_64)
public class BasicArrayCopyNode
extends AbstractMemoryCheckpoint
implements Virtualizable,
MemoryCheckpoint.Single,
MemoryAccess,
Lowerable,
DeoptimizingNode.DeoptDuring {
    public static final NodeClass<BasicArrayCopyNode> TYPE = NodeClass.create(BasicArrayCopyNode.class);
    static final int SRC_ARG = 0;
    static final int SRC_POS_ARG = 1;
    static final int DEST_ARG = 2;
    static final int DEST_POS_ARG = 3;
    static final int LENGTH_ARG = 4;
    @Node.Input
    NodeInputList<ValueNode> args;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateDuring;
    @Node.OptionalInput(value=InputType.Memory)
    protected MemoryNode lastLocationAccess;
    protected JavaKind elementKind;
    protected int bci;

    public BasicArrayCopyNode(NodeClass<? extends AbstractMemoryCheckpoint> type, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind, int bci) {
        super(type, StampFactory.forKind(JavaKind.Void));
        this.bci = bci;
        this.args = new NodeInputList((Node)this, (Node[])new ValueNode[]{src, srcPos, dest, destPos, length});
        this.elementKind = elementKind != JavaKind.Illegal ? elementKind : null;
    }

    public BasicArrayCopyNode(NodeClass<? extends AbstractMemoryCheckpoint> type, ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind) {
        this(type, src, srcPos, dest, destPos, length, elementKind, -6);
    }

    public ValueNode getSource() {
        return (ValueNode)this.args.get(0);
    }

    public ValueNode getSourcePosition() {
        return (ValueNode)this.args.get(1);
    }

    public ValueNode getDestination() {
        return (ValueNode)this.args.get(2);
    }

    public ValueNode getDestinationPosition() {
        return (ValueNode)this.args.get(3);
    }

    public ValueNode getLength() {
        return (ValueNode)this.args.get(4);
    }

    public int getBci() {
        return this.bci;
    }

    public JavaKind getElementKind() {
        return this.elementKind;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        if (this.elementKind != null) {
            return NamedLocationIdentity.getArrayLocation(this.elementKind);
        }
        return LocationIdentity.any();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.getLocationIdentity();
    }

    @Override
    public MemoryNode getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryNode lla) {
        this.updateUsagesInterface(this.lastLocationAccess, lla);
        this.lastLocationAccess = lla;
    }

    @Override
    public void lower(LoweringTool tool) {
        tool.getLowerer().lower(this, tool);
    }

    private static boolean checkBounds(int position, int length, VirtualObjectNode virtualObject) {
        assert (length >= 0);
        return position >= 0 && position <= virtualObject.entryCount() - length;
    }

    private static boolean checkEntryTypes(int srcPos, int length, VirtualObjectNode src, ResolvedJavaType destComponentType, VirtualizerTool tool) {
        if (destComponentType.getJavaKind() == JavaKind.Object && !destComponentType.isJavaLangObject()) {
            for (int i = 0; i < length; ++i) {
                ValueNode entry = tool.getEntry(src, srcPos + i);
                ResolvedJavaType type = StampTool.typeOrNull(entry);
                if (type != null && destComponentType.isAssignableFrom(type)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isExact() {
        ResolvedJavaType srcType = StampTool.typeOrNull(this.getSource().stamp(NodeView.DEFAULT));
        ResolvedJavaType destType = StampTool.typeOrNull(this.getDestination().stamp(NodeView.DEFAULT));
        if (srcType == null || !srcType.isArray() || destType == null || !destType.isArray()) {
            return false;
        }
        if (srcType.getComponentType().getJavaKind().isPrimitive() && destType.getComponentType().equals(srcType.getComponentType()) || this.getSource() == this.getDestination()) {
            return true;
        }
        return StampTool.isExactType(this.getDestination().stamp(NodeView.DEFAULT)) && destType != null && destType.isAssignableFrom(srcType);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode sourcePosition = tool.getAlias(this.getSourcePosition());
        ValueNode destinationPosition = tool.getAlias(this.getDestinationPosition());
        ValueNode replacedLength = tool.getAlias(this.getLength());
        if (sourcePosition.isConstant() && destinationPosition.isConstant() && replacedLength.isConstant()) {
            int srcPosInt = sourcePosition.asJavaConstant().asInt();
            int destPosInt = destinationPosition.asJavaConstant().asInt();
            int len = replacedLength.asJavaConstant().asInt();
            ValueNode destAlias = tool.getAlias(this.getDestination());
            if (destAlias instanceof VirtualArrayNode) {
                VirtualArrayNode destVirtual = (VirtualArrayNode)destAlias;
                if (len < 0 || !BasicArrayCopyNode.checkBounds(destPosInt, len, destVirtual)) {
                    return;
                }
                ValueNode srcAlias = tool.getAlias(this.getSource());
                if (srcAlias instanceof VirtualObjectNode) {
                    if (!(srcAlias instanceof VirtualArrayNode)) {
                        return;
                    }
                    VirtualArrayNode srcVirtual = (VirtualArrayNode)srcAlias;
                    if (destVirtual.componentType().getJavaKind() != srcVirtual.componentType().getJavaKind()) {
                        return;
                    }
                    if (!BasicArrayCopyNode.checkBounds(srcPosInt, len, srcVirtual)) {
                        return;
                    }
                    if (!BasicArrayCopyNode.checkEntryTypes(srcPosInt, len, srcVirtual, destVirtual.type().getComponentType(), tool)) {
                        return;
                    }
                    for (int i = 0; i < len; ++i) {
                        tool.setVirtualEntry(destVirtual, destPosInt + i, tool.getEntry(srcVirtual, srcPosInt + i));
                    }
                    tool.delete();
                    DebugContext debug = this.getDebug();
                    if (debug.isLogEnabled()) {
                        debug.log("virtualized arraycopy(%s, %d, %s, %d, %d)", this.getSource(), (Object)srcPosInt, (Object)this.getDestination(), (Object)destPosInt, (Object)len);
                    }
                } else {
                    ResolvedJavaType destComponentType;
                    ResolvedJavaType sourceType = StampTool.typeOrNull(srcAlias);
                    if (sourceType == null || !sourceType.isArray()) {
                        return;
                    }
                    ResolvedJavaType sourceComponentType = sourceType.getComponentType();
                    if (!sourceComponentType.equals(destComponentType = destVirtual.type().getComponentType())) {
                        return;
                    }
                    for (int i = 0; i < len; ++i) {
                        LoadIndexedNode load = new LoadIndexedNode(this.graph().getAssumptions(), srcAlias, ConstantNode.forInt(i + srcPosInt, this.graph()), null, destComponentType.getJavaKind());
                        load.setNodeSourcePosition(this.getNodeSourcePosition());
                        tool.addNode(load);
                        tool.setVirtualEntry(destVirtual, destPosInt + i, load);
                    }
                    tool.delete();
                }
            }
        }
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public void computeStateDuring(FrameState currentStateAfter) {
        FrameState newStateDuring = currentStateAfter.duplicateModifiedDuringCall(this.getBci(), this.asNode().getStackKind());
        this.setStateDuring(newStateDuring);
    }
}

