/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public final class AssertionNode
extends FixedWithNextNode
implements Lowerable,
Canonicalizable,
LIRLowerable {
    public static final NodeClass<AssertionNode> TYPE = NodeClass.create(AssertionNode.class);
    @Node.Input
    ValueNode condition;
    protected final boolean compileTimeAssertion;
    protected final String message;

    public AssertionNode(boolean compileTimeAssertion, ValueNode condition, String message, Object arg1, Object arg2) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.condition = condition;
        this.compileTimeAssertion = compileTimeAssertion;
        this.message = message + arg1 + arg2;
    }

    public ValueNode condition() {
        return this.condition;
    }

    public String message() {
        return this.message;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.condition.isConstant() && this.condition.asJavaConstant().asInt() != 0) {
            return null;
        }
        return this;
    }

    @Override
    public void lower(LoweringTool tool) {
        if (!this.compileTimeAssertion) {
            if (GraalOptions.ImmutableCode.getValue(this.getOptions()).booleanValue()) {
                this.graph().removeFixed(this);
            } else {
                tool.getLowerer().lower(this, tool);
            }
        }
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        assert (this.compileTimeAssertion);
        if (GraalOptions.ImmutableCode.getValue(this.getOptions()).booleanValue()) {
            return;
        }
        if (this.condition.isConstant()) {
            if (this.condition.asJavaConstant().asInt() == 0) {
                throw new GraalError("%s: failed compile-time assertion: %s", this, this.message);
            }
        } else {
            throw new GraalError("%s: failed compile-time assertion (value %s): %s", this, this.condition, this.message);
        }
    }

    @Node.NodeIntrinsic
    public static native void assertion(@Node.ConstantNodeParameter boolean var0, boolean var1, @Node.ConstantNodeParameter String var2, @Node.ConstantNodeParameter Object var3, @Node.ConstantNodeParameter Object var4);

    public static void assertion(@Node.ConstantNodeParameter boolean compileTimeAssertion, boolean condition, @Node.ConstantNodeParameter String message) {
        AssertionNode.assertion(compileTimeAssertion, condition, message, "", "");
    }

    public static void assertion(@Node.ConstantNodeParameter boolean compileTimeAssertion, boolean condition, @Node.ConstantNodeParameter String message, @Node.ConstantNodeParameter Object arg1) {
        AssertionNode.assertion(compileTimeAssertion, condition, message, arg1, "");
    }
}

