/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class ArrayRegionEqualsNode
extends FixedWithNextNode
implements LIRLowerable,
MemoryAccess {
    public static final NodeClass<ArrayRegionEqualsNode> TYPE = NodeClass.create(ArrayRegionEqualsNode.class);
    private final JavaKind kind1;
    private final JavaKind kind2;
    @Node.Input
    private ValueNode array1;
    @Node.Input
    private ValueNode array2;
    @Node.Input
    private ValueNode length;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryNode lastLocationAccess;

    public ArrayRegionEqualsNode(ValueNode array1, ValueNode array2, ValueNode length, @Node.ConstantNodeParameter JavaKind kind1, @Node.ConstantNodeParameter JavaKind kind2) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        this.kind1 = kind1;
        this.kind2 = kind2;
        this.array1 = array1;
        this.array2 = array2;
        this.length = length;
    }

    public static boolean regionEquals(Pointer array1, Pointer array2, int length, @Node.ConstantNodeParameter JavaKind kind) {
        return ArrayRegionEqualsNode.regionEquals(array1, array2, length, kind, kind);
    }

    @Node.NodeIntrinsic
    public static native boolean regionEquals(Pointer var0, Pointer var1, int var2, @Node.ConstantNodeParameter JavaKind var3, @Node.ConstantNodeParameter JavaKind var4);

    public JavaKind getKind1() {
        return this.kind1;
    }

    public JavaKind getKind2() {
        return this.kind2;
    }

    public ValueNode getLength() {
        return this.length;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length));
            gen.setResult(this, (Value)result);
            return;
        }
        Variable result = this.kind1 == this.kind2 ? gen.getLIRGeneratorTool().emitArrayEquals(this.kind1, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length), true) : gen.getLIRGeneratorTool().emitArrayEquals(this.kind1, this.kind2, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length), true);
        gen.setResult(this, (Value)result);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.kind1 != this.kind2 ? LocationIdentity.ANY_LOCATION : NamedLocationIdentity.getArrayLocation(this.kind1);
    }

    @Override
    public MemoryNode getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryNode lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }
}

