/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class ArrayEqualsNode
extends FixedWithNextNode
implements LIRLowerable,
Canonicalizable,
Virtualizable,
MemoryAccess {
    public static final NodeClass<ArrayEqualsNode> TYPE = NodeClass.create(ArrayEqualsNode.class);
    protected final JavaKind kind;
    @Node.Input
    ValueNode array1;
    @Node.Input
    ValueNode array2;
    @Node.Input
    ValueNode length;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryNode lastLocationAccess;

    public ArrayEqualsNode(ValueNode array1, ValueNode array2, ValueNode length, @Node.ConstantNodeParameter JavaKind kind) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Boolean));
        this.kind = kind;
        this.array1 = array1;
        this.array2 = array2;
        this.length = length;
    }

    private static boolean isNaNFloat(JavaConstant constant) {
        JavaKind kind = constant.getJavaKind();
        return kind == JavaKind.Float && Float.isNaN(constant.asFloat()) || kind == JavaKind.Double && Double.isNaN(constant.asDouble());
    }

    private static boolean arrayEquals(ConstantReflectionProvider constantReflection, JavaConstant a, JavaConstant b, int len) {
        for (int i = 0; i < len; ++i) {
            JavaConstant bElem;
            JavaConstant aElem = constantReflection.readArrayElement(a, i);
            if (constantReflection.constantEquals((Constant)aElem, (Constant)(bElem = constantReflection.readArrayElement(b, i))).booleanValue() || ArrayEqualsNode.isNaNFloat(aElem) && ArrayEqualsNode.isNaNFloat(bElem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode a2;
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        ValueNode a1 = GraphUtil.unproxify(this.array1);
        if (a1 == (a2 = GraphUtil.unproxify(this.array2))) {
            return ConstantNode.forBoolean(true);
        }
        if (a1.isConstant() && a2.isConstant() && this.length.isConstant()) {
            ConstantNode c1 = (ConstantNode)a1;
            ConstantNode c2 = (ConstantNode)a2;
            if (c1.getStableDimension() >= 1 && c2.getStableDimension() >= 1) {
                boolean ret = ArrayEqualsNode.arrayEquals(tool.getConstantReflection(), c1.asJavaConstant(), c2.asJavaConstant(), this.length.asJavaConstant().asInt());
                return ConstantNode.forBoolean(ret);
            }
        }
        return this;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias2;
        ValueNode alias1 = tool.getAlias(this.array1);
        if (alias1 == (alias2 = tool.getAlias(this.array2))) {
            tool.replaceWithValue(ConstantNode.forBoolean(true, this.graph()));
        } else if (alias1 instanceof VirtualObjectNode && alias2 instanceof VirtualObjectNode) {
            VirtualObjectNode virtual1 = (VirtualObjectNode)alias1;
            VirtualObjectNode virtual2 = (VirtualObjectNode)alias2;
            if (virtual1.entryCount() == virtual2.entryCount()) {
                int entryCount = virtual1.entryCount();
                boolean allEqual = true;
                for (int i = 0; i < entryCount; ++i) {
                    ValueNode entry2;
                    ValueNode entry1 = tool.getEntry(virtual1, i);
                    if (entry1 != (entry2 = tool.getEntry(virtual2, i))) {
                        if (entry1 instanceof ConstantNode && entry2 instanceof ConstantNode) {
                            if (entry1.getStackKind() == JavaKind.Float && entry2.getStackKind() == JavaKind.Float) {
                                float value1 = ((JavaConstant)entry1.asConstant()).asFloat();
                                float value2 = ((JavaConstant)entry2.asConstant()).asFloat();
                                if (Float.floatToIntBits(value1) != Float.floatToIntBits(value2)) {
                                    allEqual = false;
                                }
                            } else if (entry1.getStackKind() == JavaKind.Double && entry2.getStackKind() == JavaKind.Double) {
                                double value1 = ((JavaConstant)entry1.asConstant()).asDouble();
                                double value2 = ((JavaConstant)entry2.asConstant()).asDouble();
                                if (Double.doubleToLongBits(value1) != Double.doubleToLongBits(value2)) {
                                    allEqual = false;
                                }
                            } else {
                                allEqual = false;
                            }
                        } else {
                            allEqual = false;
                        }
                    }
                    if (!entry1.stamp(NodeView.DEFAULT).alwaysDistinct(entry2.stamp(NodeView.DEFAULT))) continue;
                    tool.replaceWithValue(ConstantNode.forBoolean(false, this.graph()));
                    return;
                }
                if (allEqual) {
                    tool.replaceWithValue(ConstantNode.forBoolean(true, this.graph()));
                }
            }
        }
    }

    @Node.NodeIntrinsic
    public static native boolean equals(Object var0, Object var1, int var2, @Node.ConstantNodeParameter JavaKind var3);

    public static boolean equals(boolean[] array1, boolean[] array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Boolean);
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Byte);
    }

    public static boolean equals(char[] array1, char[] array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Char);
    }

    public static boolean equals(short[] array1, short[] array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Short);
    }

    public static boolean equals(int[] array1, int[] array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Int);
    }

    public static boolean equals(long[] array1, long[] array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Long);
    }

    public static boolean equals(float[] array1, float[] array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Float);
    }

    public static boolean equals(double[] array1, double[] array2, int length) {
        return ArrayEqualsNode.equals(array1, array2, length, JavaKind.Double);
    }

    public ValueNode getLength() {
        return this.length;
    }

    public JavaKind getKind() {
        return this.kind;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length));
            gen.setResult(this, (Value)result);
            return;
        }
        Variable result = gen.getLIRGeneratorTool().emitArrayEquals(this.kind, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length), false);
        gen.setResult(this, (Value)result);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(this.kind);
    }

    @Override
    public MemoryNode getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryNode lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }
}

