/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_1024, size=NodeSize.SIZE_1024)
public final class ArrayCompareToNode
extends FixedWithNextNode
implements LIRLowerable,
Canonicalizable,
Virtualizable,
MemoryAccess {
    public static final NodeClass<ArrayCompareToNode> TYPE = NodeClass.create(ArrayCompareToNode.class);
    protected final JavaKind kind1;
    protected final JavaKind kind2;
    @Node.Input
    ValueNode array1;
    @Node.Input
    ValueNode array2;
    @Node.Input
    ValueNode length1;
    @Node.Input
    ValueNode length2;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryNode lastLocationAccess;

    public ArrayCompareToNode(ValueNode array1, ValueNode array2, ValueNode length1, ValueNode length2, @Node.ConstantNodeParameter JavaKind kind1, @Node.ConstantNodeParameter JavaKind kind2) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.kind1 = kind1;
        this.kind2 = kind2;
        this.array1 = array1;
        this.array2 = array2;
        this.length1 = length1;
        this.length2 = length2;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode a2;
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        ValueNode a1 = GraphUtil.unproxify(this.array1);
        if (a1 == (a2 = GraphUtil.unproxify(this.array2))) {
            return ConstantNode.forInt(0);
        }
        return this;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias2;
        ValueNode alias1 = tool.getAlias(this.array1);
        if (alias1 == (alias2 = tool.getAlias(this.array2))) {
            tool.replaceWithValue(ConstantNode.forInt(0, this.graph()));
        }
    }

    @Node.NodeIntrinsic
    public static native int compareTo(Object var0, Object var1, int var2, int var3, @Node.ConstantNodeParameter JavaKind var4, @Node.ConstantNodeParameter JavaKind var5);

    public JavaKind getKind1() {
        return this.kind1;
    }

    public JavaKind getKind2() {
        return this.kind2;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        ForeignCallLinkage linkage;
        if (GraalOptions.UseGraalStubs.getValue(this.graph().getOptions()).booleanValue() && (linkage = gen.lookupGraalStub(this)) != null) {
            Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length1), gen.operand(this.length2));
            gen.setResult(this, (Value)result);
            return;
        }
        Variable result = gen.getLIRGeneratorTool().emitArrayCompareTo(this.kind1, this.kind2, gen.operand(this.array1), gen.operand(this.array2), gen.operand(this.length1), gen.operand(this.length2));
        gen.setResult(this, (Value)result);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return this.kind1 != this.kind2 ? LocationIdentity.ANY_LOCATION : NamedLocationIdentity.getArrayLocation(this.kind1);
    }

    @Override
    public MemoryNode getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryNode lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }
}

