/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecodeProvider;
import org.graalvm.compiler.replacements.classfile.ClassfileConstantPool;

abstract class ClassfileConstant {
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_MethodHandle = 15;
    public static final byte CONSTANT_MethodType = 16;
    public static final byte CONSTANT_Dynamic = 17;
    public static final byte CONSTANT_InvokeDynamic = 18;
    final byte tag;

    ClassfileConstant(byte tag) {
        this.tag = tag;
    }

    public void loadReferencedType(ClassfileConstantPool cp, int index, int opcode) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static ResolvedJavaMethod resolveMethod(ClassfileBytecodeProvider context, ResolvedJavaType c, String name, String descriptor, boolean isStatic) {
        ResolvedJavaMethod method = context.findMethod(c, name, descriptor, isStatic);
        if (method != null) {
            return method;
        }
        if (!c.isJavaLangObject() && !c.isInterface() && (method = ClassfileConstant.resolveMethod(context, c.getSuperclass(), name, descriptor, isStatic)) != null) {
            return method;
        }
        for (ResolvedJavaType i : c.getInterfaces()) {
            method = ClassfileConstant.resolveMethod(context, i, name, descriptor, isStatic);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    static ResolvedJavaField resolveField(ClassfileBytecodeProvider context, ResolvedJavaType c, String name, String fieldType, boolean isStatic) {
        ResolvedJavaField field = context.findField(c, name, fieldType, isStatic);
        if (field != null) {
            return field;
        }
        if (!c.isJavaLangObject() && !c.isInterface() && (field = ClassfileConstant.resolveField(context, c.getSuperclass(), name, fieldType, isStatic)) != null) {
            return field;
        }
        for (ResolvedJavaType i : c.getInterfaces()) {
            field = ClassfileConstant.resolveField(context, i, name, fieldType, isStatic);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    static class Unsupported
    extends ClassfileConstant {
        final String name;

        Unsupported(byte tag, String name) {
            super(tag);
            this.name = name;
        }

        @Override
        public void loadReferencedType(ClassfileConstantPool cp, int index, int opcode) {
            throw new GraalError("Resolution of " + this.name + " constant pool entries not supported by " + ClassfileBytecodeProvider.class.getSimpleName());
        }
    }

    static class Utf8
    extends ClassfileConstant {
        final String value;

        Utf8(String value) {
            super((byte)1);
            this.value = value;
        }
    }

    static class NameAndType
    extends ClassfileConstant {
        final int nameIndex;
        final int typeIndex;
        private String name;
        private String type;

        NameAndType(DataInputStream stream) throws IOException {
            super((byte)12);
            this.nameIndex = stream.readUnsignedShort();
            this.typeIndex = stream.readUnsignedShort();
        }

        public String getName(ClassfileConstantPool cp) {
            if (this.name == null) {
                this.name = cp.get(Utf8.class, (int)this.nameIndex).value;
            }
            return this.name;
        }

        public String getType(ClassfileConstantPool cp) {
            if (this.type == null) {
                this.type = cp.get(Utf8.class, (int)this.typeIndex).value;
            }
            return this.type;
        }
    }

    static class StringRef
    extends ClassfileConstant {
        final int stringIndex;
        JavaConstant value;

        StringRef(DataInputStream stream) throws IOException {
            super((byte)8);
            this.stringIndex = stream.readUnsignedShort();
        }

        JavaConstant getValue(ClassfileConstantPool pool) {
            if (this.value == null) {
                this.value = pool.context.snippetReflection.forObject(pool.lookupUtf8(this.stringIndex));
            }
            return this.value;
        }
    }

    static class Primitive
    extends ClassfileConstant {
        final JavaConstant value;

        Primitive(byte tag, JavaConstant value) {
            super(tag);
            this.value = value;
        }
    }

    static class FieldRef
    extends MemberRef {
        private ResolvedJavaField field;

        FieldRef(DataInputStream stream) throws IOException {
            super((byte)9, stream);
        }

        ResolvedJavaField resolve(ClassfileConstantPool cp, int opcode) {
            if (this.field == null) {
                ResolvedJavaType cls = cp.get(ClassRef.class, this.classIndex).resolve(cp);
                NameAndType nameAndType = cp.get(NameAndType.class, this.nameAndTypeIndex);
                String name = nameAndType.getName(cp);
                String type = nameAndType.getType(cp);
                assert (opcode == 180 || opcode == 178 || opcode == 181 || opcode == 179) : opcode;
                this.field = FieldRef.resolveField(cp.context, cls, name, type, opcode == 178 || opcode == 179);
                if (this.field == null) {
                    throw new NoSuchFieldError(cls.toJavaName() + "." + name + " " + type);
                }
            }
            return this.field;
        }
    }

    static class InterfaceMethodRef
    extends ExecutableRef {
        InterfaceMethodRef(DataInputStream stream) throws IOException {
            super((byte)11, stream);
        }
    }

    static class MethodRef
    extends ExecutableRef {
        MethodRef(DataInputStream stream) throws IOException {
            super((byte)10, stream);
        }
    }

    static class ExecutableRef
    extends MemberRef {
        private ResolvedJavaMethod method;

        ExecutableRef(byte tag, DataInputStream stream) throws IOException {
            super(tag, stream);
        }

        ResolvedJavaMethod resolve(ClassfileConstantPool cp, int opcode) {
            if (this.method == null) {
                ResolvedJavaType cls = cp.get(ClassRef.class, this.classIndex).resolve(cp);
                NameAndType nameAndType = cp.get(NameAndType.class, this.nameAndTypeIndex);
                String name = nameAndType.getName(cp);
                String type = nameAndType.getType(cp);
                if (opcode == 185) {
                    this.method = ExecutableRef.resolveMethod(cp.context, cls, name, type, false);
                    if (this.method == null) {
                        throw new NoSuchMethodError(cls.toJavaName() + "." + name + type);
                    }
                    if (!this.method.isPublic() || !this.method.getDeclaringClass().isInterface() && !this.method.getDeclaringClass().isJavaLangObject()) {
                        throw new IncompatibleClassChangeError("cannot invokeinterface " + this.method.format("%H.%n(%P)%R"));
                    }
                } else if (opcode == 182 || opcode == 183) {
                    this.method = ExecutableRef.resolveMethod(cp.context, cls, name, type, false);
                    if (this.method == null) {
                        throw new NoSuchMethodError(cls.toJavaName() + "." + name + type);
                    }
                } else {
                    assert (opcode == 184);
                    this.method = ExecutableRef.resolveMethod(cp.context, cls, name, type, true);
                    if (this.method == null) {
                        throw new NoSuchMethodError(cls.toJavaName() + "." + name + type);
                    }
                }
            }
            return this.method;
        }
    }

    static class MemberRef
    extends ClassfileConstant {
        final int classIndex;
        final int nameAndTypeIndex;

        MemberRef(byte tag, DataInputStream stream) throws IOException {
            super(tag);
            this.classIndex = stream.readUnsignedShort();
            this.nameAndTypeIndex = stream.readUnsignedShort();
        }

        @Override
        public void loadReferencedType(ClassfileConstantPool cp, int index, int opcode) {
            cp.get(ClassRef.class, this.classIndex).loadReferencedType(cp, this.classIndex, opcode);
        }
    }

    static class ClassRef
    extends ClassfileConstant {
        final int nameIndex;
        private ResolvedJavaType type;

        ClassRef(DataInputStream stream) throws IOException {
            super((byte)7);
            this.nameIndex = stream.readUnsignedShort();
        }

        @Override
        public void loadReferencedType(ClassfileConstantPool cp, int index, int opcode) {
            this.resolve(cp);
        }

        public ResolvedJavaType resolve(ClassfileConstantPool cp) throws GraalError {
            if (this.type == null) {
                String typeDescriptor = cp.get(Utf8.class, (int)this.nameIndex).value;
                ClassfileBytecodeProvider context = cp.context;
                this.type = context.metaAccess.lookupJavaType(context.resolveToClass(typeDescriptor));
            }
            return this.type;
        }
    }
}

