/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.StringUTF16Substitutions;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.amd64.AMD64StringUTF16CompressNode;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.word.Word;

@ClassSubstitution(className={"java.lang.StringUTF16"}, optional=true)
public class AMD64StringUTF16Substitutions {
    static final MetaAccessProvider INJECTED = null;

    @Fold
    static int byteArrayBaseOffset(@Fold.InjectedParameter MetaAccessProvider metaAccess) {
        return metaAccess.getArrayBaseOffset(JavaKind.Byte);
    }

    @Fold
    static int byteArrayIndexScale(@Fold.InjectedParameter MetaAccessProvider metaAccess) {
        return metaAccess.getArrayIndexScale(JavaKind.Byte);
    }

    @Fold
    static int charArrayBaseOffset(@Fold.InjectedParameter MetaAccessProvider metaAccess) {
        return metaAccess.getArrayBaseOffset(JavaKind.Char);
    }

    @Fold
    static int charArrayIndexScale(@Fold.InjectedParameter MetaAccessProvider metaAccess) {
        return metaAccess.getArrayIndexScale(JavaKind.Char);
    }

    public static int length(byte[] value) {
        return value.length >> 1;
    }

    @MethodSubstitution
    public static int compareTo(byte[] value, byte[] other) {
        return ArrayCompareToNode.compareTo(value, other, value.length, other.length, JavaKind.Char, JavaKind.Char);
    }

    @MethodSubstitution
    public static int compareToLatin1(byte[] value, byte[] other) {
        return ArrayCompareToNode.compareTo(other, value, other.length, value.length, JavaKind.Char, JavaKind.Byte);
    }

    @MethodSubstitution
    public static int indexOfCharUnsafe(byte[] value, int ch, int fromIndex, int max) {
        return AMD64ArrayIndexOf.indexOf1Char(value, max, fromIndex, (char)ch);
    }

    private static Word pointer(byte[] target) {
        return Word.objectToTrackedPointer(target).add(AMD64StringUTF16Substitutions.byteArrayBaseOffset(INJECTED));
    }

    private static Word charOffsetPointer(byte[] value, int offset) {
        return AMD64StringUTF16Substitutions.pointer(value).add(offset * AMD64StringUTF16Substitutions.charArrayIndexScale(INJECTED));
    }

    @MethodSubstitution
    public static int indexOfUnsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.runtimeAssert(fromIndex >= 0, "StringUTF16.indexOfUnsafe invalid args: fromIndex negative");
        ReplacementsUtil.runtimeAssert(targetCount > 0, "StringUTF16.indexOfUnsafe invalid args: targetCount <= 0");
        ReplacementsUtil.runtimeAssert(targetCount <= AMD64StringUTF16Substitutions.length(target), "StringUTF16.indexOfUnsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.runtimeAssert(sourceCount >= targetCount, "StringUTF16.indexOfUnsafe invalid args: sourceCount < targetCount");
        if (targetCount == 1) {
            return AMD64ArrayIndexOf.indexOf1Char(source, sourceCount, fromIndex, StringUTF16Substitutions.getChar(target, 0));
        }
        int haystackLength = sourceCount - (targetCount - 2);
        for (int offset = fromIndex; offset < haystackLength; ++offset) {
            int indexOfResult = AMD64ArrayIndexOf.indexOfTwoConsecutiveChars(source, haystackLength, offset, StringUTF16Substitutions.getChar(target, 0), StringUTF16Substitutions.getChar(target, 1));
            if (indexOfResult < 0) {
                return -1;
            }
            offset = indexOfResult;
            Word cmpSourcePointer = AMD64StringUTF16Substitutions.charOffsetPointer(source, offset);
            Word targetPointer = AMD64StringUTF16Substitutions.pointer(target);
            if (targetCount != 2 && !ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer, targetCount, JavaKind.Char)) continue;
            return offset;
        }
        return -1;
    }

    @MethodSubstitution
    public static int indexOfLatin1Unsafe(byte[] source, int sourceCount, byte[] target, int targetCount, int fromIndex) {
        ReplacementsUtil.runtimeAssert(fromIndex >= 0, "StringUTF16.indexOfLatin1Unsafe invalid args: fromIndex negative");
        ReplacementsUtil.runtimeAssert(targetCount > 0, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount <= 0");
        ReplacementsUtil.runtimeAssert(targetCount <= target.length, "StringUTF16.indexOfLatin1Unsafe invalid args: targetCount > length(target)");
        ReplacementsUtil.runtimeAssert(sourceCount >= targetCount, "StringUTF16.indexOfLatin1Unsafe invalid args: sourceCount < targetCount");
        if (targetCount == 1) {
            return AMD64ArrayIndexOf.indexOf1Char(source, sourceCount, fromIndex, (char)Byte.toUnsignedInt(target[0]));
        }
        int haystackLength = sourceCount - (targetCount - 2);
        for (int offset = fromIndex; offset < haystackLength; ++offset) {
            int indexOfResult = AMD64ArrayIndexOf.indexOfTwoConsecutiveChars(source, haystackLength, offset, (char)Byte.toUnsignedInt(target[0]), (char)Byte.toUnsignedInt(target[1]));
            if (indexOfResult < 0) {
                return -1;
            }
            offset = indexOfResult;
            Word cmpSourcePointer = AMD64StringUTF16Substitutions.charOffsetPointer(source, offset);
            Word targetPointer = AMD64StringUTF16Substitutions.pointer(target);
            if (targetCount != 2 && !ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer, targetCount, JavaKind.Char, JavaKind.Byte)) continue;
            return offset;
        }
        return -1;
    }

    @MethodSubstitution
    public static int compress(char[] src, int srcIndex, byte[] dest, int destIndex, int len) {
        AMD64StringUTF16Substitutions.checkLimits(src.length, srcIndex, dest.length, destIndex, len);
        Word srcPointer = Word.objectToTrackedPointer(src).add(AMD64StringUTF16Substitutions.charArrayBaseOffset(INJECTED)).add(srcIndex * AMD64StringUTF16Substitutions.charArrayIndexScale(INJECTED));
        Word destPointer = Word.objectToTrackedPointer(dest).add(AMD64StringUTF16Substitutions.byteArrayBaseOffset(INJECTED)).add(destIndex * AMD64StringUTF16Substitutions.byteArrayIndexScale(INJECTED));
        return AMD64StringUTF16CompressNode.compress(srcPointer, destPointer, len, JavaKind.Char);
    }

    @MethodSubstitution
    public static int compress(byte[] src, int srcIndex, byte[] dest, int destIndex, int len) {
        AMD64StringUTF16Substitutions.checkLimits(src.length >> 1, srcIndex, dest.length, destIndex, len);
        Word srcPointer = Word.objectToTrackedPointer(src).add(AMD64StringUTF16Substitutions.byteArrayBaseOffset(INJECTED)).add(srcIndex * 2 * AMD64StringUTF16Substitutions.byteArrayIndexScale(INJECTED));
        Word destPointer = Word.objectToTrackedPointer(dest).add(AMD64StringUTF16Substitutions.byteArrayBaseOffset(INJECTED)).add(destIndex * AMD64StringUTF16Substitutions.byteArrayIndexScale(INJECTED));
        return AMD64StringUTF16CompressNode.compress(srcPointer, destPointer, len, JavaKind.Byte);
    }

    private static void checkLimits(int srcLen, int srcIndex, int destLen, int destIndex, int len) {
        if (len < 0 || srcIndex < 0 || srcIndex + len > srcLen || destIndex < 0 || destIndex + len > destLen) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
    }
}

