/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.amd64.AMD64StringLatin1InflateNode;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.word.Word;

@ClassSubstitution(className={"java.lang.StringLatin1"}, optional=true)
public class AMD64StringLatin1Substitutions {
    static final MetaAccessProvider INJECTED = null;

    @Fold
    static int byteArrayBaseOffset(@Fold.InjectedParameter MetaAccessProvider metaAccess) {
        return metaAccess.getArrayBaseOffset(JavaKind.Byte);
    }

    @Fold
    static int byteArrayIndexScale(@Fold.InjectedParameter MetaAccessProvider metaAccess) {
        return metaAccess.getArrayIndexScale(JavaKind.Byte);
    }

    @Fold
    static int charArrayBaseOffset(@Fold.InjectedParameter MetaAccessProvider metaAccess) {
        return metaAccess.getArrayBaseOffset(JavaKind.Char);
    }

    @Fold
    static int charArrayIndexScale(@Fold.InjectedParameter MetaAccessProvider metaAccess) {
        return metaAccess.getArrayIndexScale(JavaKind.Char);
    }

    @MethodSubstitution
    public static int compareTo(byte[] value, byte[] other) {
        return ArrayCompareToNode.compareTo(value, other, value.length, other.length, JavaKind.Byte, JavaKind.Byte);
    }

    @MethodSubstitution
    public static int compareToUTF16(byte[] value, byte[] other) {
        return ArrayCompareToNode.compareTo(value, other, value.length, other.length, JavaKind.Byte, JavaKind.Char);
    }

    private static Word pointer(byte[] target) {
        return Word.objectToTrackedPointer(target).add(AMD64StringLatin1Substitutions.byteArrayBaseOffset(INJECTED));
    }

    private static Word byteOffsetPointer(byte[] source, int offset) {
        return AMD64StringLatin1Substitutions.pointer(source).add(offset * AMD64StringLatin1Substitutions.byteArrayIndexScale(INJECTED));
    }

    @MethodSubstitution
    public static int indexOf(byte[] value, int ch, int origFromIndex) {
        int fromIndex = origFromIndex;
        if (ch >>> 8 != 0) {
            return -1;
        }
        int length = value.length;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= length) {
            return -1;
        }
        return AMD64ArrayIndexOf.indexOf1Byte(value, length, fromIndex, (byte)ch);
    }

    @MethodSubstitution
    public static int indexOf(byte[] source, int sourceCount, byte[] target, int targetCount, int origFromIndex) {
        int fromIndex = origFromIndex;
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        if (sourceCount - fromIndex < targetCount) {
            return -1;
        }
        if (targetCount == 1) {
            return AMD64ArrayIndexOf.indexOf1Byte(source, sourceCount, fromIndex, target[0]);
        }
        int haystackLength = sourceCount - (targetCount - 2);
        for (int offset = fromIndex; offset < haystackLength; ++offset) {
            int indexOfResult = AMD64ArrayIndexOf.indexOfTwoConsecutiveBytes(source, haystackLength, offset, target[0], target[1]);
            if (indexOfResult < 0) {
                return -1;
            }
            offset = indexOfResult;
            Word cmpSourcePointer = AMD64StringLatin1Substitutions.byteOffsetPointer(source, offset);
            Word targetPointer = AMD64StringLatin1Substitutions.pointer(target);
            if (targetCount != 2 && !ArrayRegionEqualsNode.regionEquals(cmpSourcePointer, targetPointer, targetCount, JavaKind.Byte)) continue;
            return offset;
        }
        return -1;
    }

    @MethodSubstitution
    public static void inflate(byte[] src, int srcIndex, char[] dest, int destIndex, int len) {
        if (len < 0 || srcIndex < 0 || srcIndex + len > src.length || destIndex < 0 || destIndex + len > dest.length) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        Word srcPointer = Word.objectToTrackedPointer(src).add(AMD64StringLatin1Substitutions.byteArrayBaseOffset(INJECTED)).add(srcIndex * AMD64StringLatin1Substitutions.byteArrayIndexScale(INJECTED));
        Word destPointer = Word.objectToTrackedPointer(dest).add(AMD64StringLatin1Substitutions.charArrayBaseOffset(INJECTED)).add(destIndex * AMD64StringLatin1Substitutions.charArrayIndexScale(INJECTED));
        AMD64StringLatin1InflateNode.inflate(srcPointer, destPointer, len, JavaKind.Char);
    }

    @MethodSubstitution
    public static void inflate(byte[] src, int srcIndex, byte[] dest, int destIndex, int len) {
        if (len < 0 || srcIndex < 0 || srcIndex + len > src.length || destIndex < 0 || destIndex * 2 + len * 2 > dest.length) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
        }
        Word srcPointer = Word.objectToTrackedPointer(src).add(AMD64StringLatin1Substitutions.byteArrayBaseOffset(INJECTED)).add(srcIndex * AMD64StringLatin1Substitutions.byteArrayIndexScale(INJECTED));
        Word destPointer = Word.objectToTrackedPointer(dest).add(AMD64StringLatin1Substitutions.byteArrayBaseOffset(INJECTED)).add(destIndex * 2 * AMD64StringLatin1Substitutions.byteArrayIndexScale(INJECTED));
        AMD64StringLatin1InflateNode.inflate(srcPointer, destPointer, len, JavaKind.Byte);
    }
}

