/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.MemoryNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_512, cycles=NodeCycles.CYCLES_UNKNOWN)
public class AMD64ArrayIndexOfNode
extends FixedWithNextNode
implements LIRLowerable,
MemoryAccess {
    public static final NodeClass<AMD64ArrayIndexOfNode> TYPE = NodeClass.create(AMD64ArrayIndexOfNode.class);
    private final JavaKind arrayKind;
    private final JavaKind valueKind;
    private final boolean findTwoConsecutive;
    @Node.Input
    private ValueNode arrayPointer;
    @Node.Input
    private ValueNode arrayLength;
    @Node.Input
    private ValueNode fromIndex;
    @Node.Input
    private NodeInputList<ValueNode> searchValues;
    @Node.OptionalInput(value=InputType.Memory)
    private MemoryNode lastLocationAccess;

    public AMD64ArrayIndexOfNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, @Node.ConstantNodeParameter boolean findTwoConsecutive, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(JavaKind.Int));
        this.arrayKind = arrayKind;
        this.valueKind = valueKind;
        this.findTwoConsecutive = findTwoConsecutive;
        this.arrayPointer = arrayPointer;
        this.arrayLength = arrayLength;
        this.fromIndex = fromIndex;
        this.searchValues = new NodeInputList((Node)this, (Node[])searchValues);
    }

    public AMD64ArrayIndexOfNode(@Node.ConstantNodeParameter JavaKind arrayKind, @Node.ConstantNodeParameter JavaKind valueKind, ValueNode arrayPointer, ValueNode arrayLength, ValueNode fromIndex, ValueNode ... searchValues) {
        this(arrayKind, valueKind, false, arrayPointer, arrayLength, fromIndex, searchValues);
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.getArrayLocation(this.arrayKind);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Value[] searchValueOperands = new Value[this.searchValues.size()];
        for (int i = 0; i < this.searchValues.size(); ++i) {
            searchValueOperands[i] = gen.operand((Node)this.searchValues.get(i));
        }
        Variable result = gen.getLIRGeneratorTool().emitArrayIndexOf(this.arrayKind, this.valueKind, this.findTwoConsecutive, gen.operand(this.arrayPointer), gen.operand(this.arrayLength), gen.operand(this.fromIndex), searchValueOperands);
        gen.setResult(this, (Value)result);
    }

    @Override
    public MemoryNode getLastLocationAccess() {
        return this.lastLocationAccess;
    }

    @Override
    public void setLastLocationAccess(MemoryNode lla) {
        this.updateUsages(ValueNodeUtil.asNode(this.lastLocationAccess), ValueNodeUtil.asNode(lla));
        this.lastLocationAccess = lla;
    }

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6, byte var7);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6, byte var7, byte var8);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, byte var6, byte var7, byte var8, byte var9);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6, char var7);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6, char var7, char var8);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, char var6, char var7, char var8, char var9);

    @Node.NodeIntrinsic
    private static native int optimizedArrayIndexOf(@Node.ConstantNodeParameter JavaKind var0, @Node.ConstantNodeParameter JavaKind var1, @Node.ConstantNodeParameter boolean var2, Object var3, int var4, int var5, int var6);

    public static int indexOf(byte[] array, int arrayLength, int fromIndex, byte v1) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(byte[] array, int arrayLength, int fromIndex, byte v1, byte v2) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(byte[] array, int arrayLength, int fromIndex, byte v1, byte v2, byte v3) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(byte[] array, int arrayLength, int fromIndex, byte v1, byte v2, byte v3, byte v4) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Byte, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf(byte[] array, int arrayLength, int fromIndex, char v1) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(byte[] array, int arrayLength, int fromIndex, char v1, char v2) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(byte[] array, int arrayLength, int fromIndex, char v1, char v2, char v3) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(byte[] array, int arrayLength, int fromIndex, char v1, char v2, char v3, char v4) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf(char[] array, int arrayLength, int fromIndex, char v1) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1);
    }

    public static int indexOf(char[] array, int arrayLength, int fromIndex, char v1, char v2) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2);
    }

    public static int indexOf(char[] array, int arrayLength, int fromIndex, char v1, char v2, char v3) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3);
    }

    public static int indexOf(char[] array, int arrayLength, int fromIndex, char v1, char v2, char v3, char v4) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Char, JavaKind.Char, false, (Object)array, arrayLength, fromIndex, v1, v2, v3, v4);
    }

    public static int indexOf2ConsecutiveBytes(byte[] array, int arrayLength, int fromIndex, int values) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Byte, true, (Object)array, arrayLength, fromIndex, values);
    }

    public static int indexOf2ConsecutiveChars(byte[] array, int arrayLength, int fromIndex, int values) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Byte, JavaKind.Char, true, (Object)array, arrayLength, fromIndex, values);
    }

    public static int indexOf2ConsecutiveChars(char[] array, int arrayLength, int fromIndex, int values) {
        return AMD64ArrayIndexOfNode.optimizedArrayIndexOf(JavaKind.Char, JavaKind.Char, true, (Object)array, arrayLength, fromIndex, values);
    }
}

