/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.replacements.nodes.AssertionNode;

public final class ReplacementsUtil {
    public static final boolean REPLACEMENTS_ASSERTIONS_ENABLED = Assertions.assertionsEnabled();

    private ReplacementsUtil() {
    }

    public static void staticAssert(boolean condition, String message) {
        if (REPLACEMENTS_ASSERTIONS_ENABLED) {
            AssertionNode.assertion(true, condition, message);
        }
    }

    public static void staticAssert(boolean condition, String message, Object arg1) {
        if (REPLACEMENTS_ASSERTIONS_ENABLED) {
            AssertionNode.assertion(true, condition, message, arg1, "");
        }
    }

    public static void staticAssert(boolean condition, String message, Object arg1, Object arg2) {
        if (REPLACEMENTS_ASSERTIONS_ENABLED) {
            AssertionNode.assertion(true, condition, message, arg1, arg2);
        }
    }

    public static void runtimeAssert(boolean condition, String message) {
        if (REPLACEMENTS_ASSERTIONS_ENABLED) {
            AssertionNode.assertion(false, condition, message);
        }
    }

    @Fold
    public static int arrayIndexScale(@Fold.InjectedParameter MetaAccessProvider metaAccessProvider, JavaKind elementKind) {
        return metaAccessProvider.getArrayIndexScale(elementKind);
    }

    @Fold
    public static int getArrayBaseOffset(@Fold.InjectedParameter MetaAccessProvider metaAccessProvider, JavaKind elementKind) {
        return metaAccessProvider.getArrayBaseOffset(elementKind);
    }
}

