/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.replacements.SnippetTemplateCache;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ConstantBindingParameterPlugin;
import org.graalvm.compiler.replacements.IntrinsicGraphBuilder;
import org.graalvm.compiler.replacements.SnippetCounterNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordOperationPlugin;

public class ReplacementsImpl
implements Replacements,
InlineInvokePlugin {
    protected Providers providers;
    public final SnippetReflectionProvider snippetReflection;
    public final TargetDescription target;
    private GraphBuilderConfiguration.Plugins graphBuilderPlugins;
    private final DebugHandlersFactory debugHandlersFactory;
    protected final ConcurrentMap<ResolvedJavaMethod, StructuredGraph> graphs;
    protected final BytecodeProvider defaultBytecodeProvider;
    private static final int MAX_GRAPH_INLINING_DEPTH = 100;
    private final EconomicMap<String, SnippetTemplateCache> snippetTemplateCache;
    private static final TimerKey SnippetPreparationTime = DebugContext.timer("SnippetPreparationTime");
    private static final AtomicInteger nextDebugContextId = new AtomicInteger();

    @Override
    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers.copyWith(this);
    }

    public void setGraphBuilderPlugins(GraphBuilderConfiguration.Plugins plugins) {
        assert (this.graphBuilderPlugins == null);
        this.graphBuilderPlugins = plugins;
    }

    @Override
    public GraphBuilderConfiguration.Plugins getGraphBuilderPlugins() {
        return this.graphBuilderPlugins;
    }

    @Override
    public Class<? extends GraphBuilderPlugin> getIntrinsifyingPlugin(ResolvedJavaMethod method) {
        if (method.getAnnotation(Node.NodeIntrinsic.class) != null || method.getAnnotation(Fold.class) != null) {
            return GeneratedInvocationPlugin.class;
        }
        if (method.getAnnotation(Word.Operation.class) != null) {
            return WordOperationPlugin.class;
        }
        return null;
    }

    @Override
    public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        MethodSubstitutionPlugin msPlugin = this.getMethodSubstitution(method);
        if (msPlugin != null) {
            if (b.parsingIntrinsic() || BytecodeParserOptions.InlineDuringParsing.getValue(b.getOptions()).booleanValue() || BytecodeParserOptions.InlineIntrinsicsDuringParsing.getValue(b.getOptions()).booleanValue()) {
                return InlineInvokePlugin.InlineInfo.createMethodSubstitutionInlineInfo(method, msPlugin);
            }
            return null;
        }
        if (b.parsingIntrinsic()) {
            assert (b.getDepth() < 100) : "inlining limit exceeded";
            return InlineInvokePlugin.InlineInfo.createIntrinsicInlineInfo(method, this.defaultBytecodeProvider);
        }
        assert (Services.IS_BUILDING_NATIVE_IMAGE || method.getAnnotation(Node.NodeIntrinsic.class) == null) : String.format("@%s method %s must only be called from within a replacement%n%s", Node.NodeIntrinsic.class.getSimpleName(), method.format("%h.%n"), b);
        return null;
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
        IntrinsicContext intrinsic;
        if (b.parsingIntrinsic() && !(intrinsic = b.getIntrinsic()).isCallToOriginal(method)) {
            Class<? extends GraphBuilderPlugin> pluginClass = this.getIntrinsifyingPlugin(method);
            if (pluginClass != null) {
                String methodDesc = method.format("%H.%n(%p)");
                throw new GraalError("Call to %s should have been intrinsified by a %s. This is typically caused by Eclipse failing to run an annotation processor. This can usually be fixed by forcing Eclipse to rebuild the source file in which %s is declared", methodDesc, pluginClass.getSimpleName(), methodDesc);
            }
            throw new GraalError("All non-recursive calls in the intrinsic %s must be inlined or intrinsified: found call to %s", intrinsic.getIntrinsicMethod().format("%H.%n(%p)"), method.format("%h.%n(%p)"));
        }
    }

    public ReplacementsImpl(DebugHandlersFactory debugHandlersFactory, Providers providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target) {
        this.providers = providers.copyWith(this);
        this.snippetReflection = snippetReflection;
        this.target = target;
        this.graphs = new ConcurrentHashMap<ResolvedJavaMethod, StructuredGraph>();
        this.snippetTemplateCache = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.defaultBytecodeProvider = bytecodeProvider;
        this.debugHandlersFactory = debugHandlersFactory;
    }

    public DebugContext openDebugContext(String idPrefix, ResolvedJavaMethod method, OptionValues options) {
        if (DebugOptions.DebugStubsAndSnippets.getValue(options).booleanValue()) {
            DebugContext outer = DebugContext.forCurrentThread();
            DebugContext.Description description = new DebugContext.Description(method, idPrefix + nextDebugContextId.incrementAndGet());
            List<DebugHandlersFactory> factories = this.debugHandlersFactory == null ? Collections.emptyList() : Collections.singletonList(this.debugHandlersFactory);
            return DebugContext.create(options, description, outer.getGlobalMetrics(), DebugContext.DEFAULT_LOG_STREAM, factories);
        }
        return DebugContext.disabled(options);
    }

    @Override
    public StructuredGraph getSnippet(ResolvedJavaMethod method, ResolvedJavaMethod recursiveEntry, Object[] args, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        StructuredGraph graph;
        assert (method.getAnnotation(Snippet.class) != null) : "Snippet must be annotated with @" + Snippet.class.getSimpleName();
        assert (method.hasBytecodes()) : "Snippet must not be abstract or native";
        StructuredGraph structuredGraph = graph = GraalOptions.UseSnippetGraphCache.getValue(options) != false ? (StructuredGraph)this.graphs.get(method) : null;
        if (graph == null || trackNodeSourcePosition && !graph.trackNodeSourcePosition()) {
            try (DebugContext debug = this.openDebugContext("Snippet_", method, options);
                 DebugCloseable a = SnippetPreparationTime.start(debug);){
                StructuredGraph newGraph = this.makeGraph(debug, this.defaultBytecodeProvider, method, args, recursiveEntry, trackNodeSourcePosition, replaceePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
                DebugContext.counter("SnippetNodeCount[%#s]", method).add(newGraph.getDebug(), newGraph.getNodeCount());
                if (!GraalOptions.UseSnippetGraphCache.getValue(options).booleanValue() || args != null) {
                    StructuredGraph structuredGraph2 = newGraph;
                    return structuredGraph2;
                }
                newGraph.freeze();
                if (graph != null) {
                    this.graphs.replace(method, graph, newGraph);
                } else {
                    this.graphs.putIfAbsent(method, newGraph);
                }
                graph = (StructuredGraph)this.graphs.get(method);
            }
        }
        assert (!trackNodeSourcePosition || graph.trackNodeSourcePosition());
        return graph;
    }

    @Override
    public void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
    }

    @Override
    public StructuredGraph getMethodSubstitution(MethodSubstitutionPlugin plugin, ResolvedJavaMethod original, IntrinsicContext.CompilationContext context, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable, OptionValues options) {
        return null;
    }

    @Override
    public void registerMethodSubstitution(MethodSubstitutionPlugin plugin) {
    }

    @Override
    public void registerConditionalPlugin(InvocationPlugin plugin) {
    }

    @Override
    public boolean hasSubstitution(ResolvedJavaMethod method, int invokeBci) {
        InvocationPlugin plugin = this.graphBuilderPlugins.getInvocationPlugins().lookupInvocation(method);
        return plugin != null && (!plugin.inlineOnly() || invokeBci >= 0);
    }

    @Override
    public BytecodeProvider getDefaultReplacementBytecodeProvider() {
        return this.defaultBytecodeProvider;
    }

    protected MethodSubstitutionPlugin getMethodSubstitution(ResolvedJavaMethod method) {
        InvocationPlugin plugin = this.graphBuilderPlugins.getInvocationPlugins().lookupInvocation(method);
        if (plugin instanceof MethodSubstitutionPlugin) {
            MethodSubstitutionPlugin msPlugin = (MethodSubstitutionPlugin)plugin;
            return msPlugin;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StructuredGraph getSubstitution(ResolvedJavaMethod method, int invokeBci, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        InvocationPlugin plugin = this.graphBuilderPlugins.getInvocationPlugins().lookupInvocation(method);
        if (plugin == null) return null;
        if (plugin.inlineOnly()) {
            if (invokeBci < 0) return null;
        }
        MetaAccessProvider metaAccess = this.providers.getMetaAccess();
        if (plugin instanceof MethodSubstitutionPlugin) {
            StructuredGraph graph;
            MethodSubstitutionPlugin msPlugin = (MethodSubstitutionPlugin)plugin;
            ResolvedJavaMethod substitute = msPlugin.getSubstitute(metaAccess);
            StructuredGraph structuredGraph = graph = GraalOptions.UseSnippetGraphCache.getValue(options) != false ? (StructuredGraph)this.graphs.get(substitute) : null;
            if (graph == null || graph.trackNodeSourcePosition() != trackNodeSourcePosition) {
                try (DebugContext debug = this.openDebugContext("Substitution_", method, options);){
                    graph = this.makeGraph(debug, msPlugin.getBytecodeProvider(), substitute, null, method, trackNodeSourcePosition, replaceePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
                    if (!GraalOptions.UseSnippetGraphCache.getValue(options).booleanValue()) {
                        StructuredGraph structuredGraph2 = graph;
                        return structuredGraph2;
                    }
                    graph.freeze();
                    this.graphs.putIfAbsent(substitute, graph);
                    graph = (StructuredGraph)this.graphs.get(substitute);
                }
            }
            if ($assertionsDisabled) return graph;
            if (graph.isFrozen()) return graph;
            throw new AssertionError();
        }
        ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode(method);
        try (DebugContext debug = this.openDebugContext("Substitution_", method, options);){
            StructuredGraph result = new IntrinsicGraphBuilder(options, debug, this.providers, code, invokeBci).buildGraph(plugin);
            return result;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StructuredGraph getIntrinsicGraph(ResolvedJavaMethod method, CompilationIdentifier compilationId, DebugContext debug, Cancellable cancellable) {
        MethodSubstitutionPlugin msPlugin = this.getMethodSubstitution(method);
        if (msPlugin == null) return null;
        ResolvedJavaMethod substMethod = msPlugin.getSubstitute(this.providers.getMetaAccess());
        assert (!substMethod.equals(method));
        BytecodeProvider bytecodeProvider = msPlugin.getBytecodeProvider();
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug, StructuredGraph.AllowAssumptions.YES).method(substMethod).compilationId(compilationId).recordInlinedMethods(bytecodeProvider.shouldRecordMethodDependencies()).setIsSubstitution(true).build();
        try (DebugContext.Scope scope = debug.scope((Object)"GetIntrinsicGraph", graph);){
            GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.getGraphBuilderPlugins());
            GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault(plugins);
            IntrinsicContext initialReplacementContext = new IntrinsicContext(method, substMethod, bytecodeProvider, IntrinsicContext.CompilationContext.ROOT_COMPILATION);
            new GraphBuilderPhase.Instance(this.providers, config, OptimisticOptimizations.NONE, initialReplacementContext).apply(graph);
            assert (!graph.isFrozen());
            StructuredGraph structuredGraph = graph;
            return structuredGraph;
        }
        catch (Throwable e) {
            debug.handle(e);
        }
        return null;
    }

    public StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod method, Object[] args, ResolvedJavaMethod original, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
        return this.createGraphMaker(method, original).makeGraph(debug, bytecodeProvider, args, trackNodeSourcePosition, replaceePosition, context);
    }

    public final StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod method, Object[] args, ResolvedJavaMethod original, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition) {
        return this.makeGraph(debug, bytecodeProvider, method, args, original, trackNodeSourcePosition, replaceePosition, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING);
    }

    protected GraphMaker createGraphMaker(ResolvedJavaMethod substitute, ResolvedJavaMethod original) {
        return new GraphMaker(this, substitute, original);
    }

    @Override
    public void registerSnippetTemplateCache(SnippetTemplateCache templates) {
        assert (this.snippetTemplateCache.get((Object)templates.getClass().getName()) == null);
        this.snippetTemplateCache.put((Object)templates.getClass().getName(), (Object)templates);
    }

    @Override
    public <T extends SnippetTemplateCache> T getSnippetTemplateCache(Class<T> templatesClass) {
        SnippetTemplateCache ret = (SnippetTemplateCache)this.snippetTemplateCache.get((Object)templatesClass.getName());
        return (T)((SnippetTemplateCache)templatesClass.cast(ret));
    }

    public static class GraphMaker {
        protected final ReplacementsImpl replacements;
        protected final ResolvedJavaMethod method;
        protected final ResolvedJavaMethod substitutedMethod;

        public GraphMaker(ReplacementsImpl replacements, ResolvedJavaMethod substitute, ResolvedJavaMethod substitutedMethod) {
            this.replacements = replacements;
            this.method = substitute;
            this.substitutedMethod = substitutedMethod;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public StructuredGraph makeGraph(DebugContext debug, BytecodeProvider bytecodeProvider, Object[] args, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
            try (DebugContext.Scope s = debug.scope((Object)"BuildSnippetGraph", this.method);){
                assert (this.method.hasBytecodes()) : this.method;
                StructuredGraph graph = this.buildInitialGraph(debug, bytecodeProvider, this.method, args, trackNodeSourcePosition, replaceePosition, context);
                this.finalizeGraph(graph);
                debug.dump(2, (Object)graph, "%s: Final", this.method.getName());
                StructuredGraph structuredGraph = graph;
                return structuredGraph;
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }

        protected void finalizeGraph(StructuredGraph graph) {
            if (!GraalOptions.SnippetCounters.getValue(graph.getOptions()).booleanValue() || graph.getNodes().filter(SnippetCounterNode.class).isEmpty()) {
                int sideEffectCount = 0;
                assert ((sideEffectCount = graph.getNodes().filter(e -> this.hasSideEffect(e)).count()) >= 0);
                new ConvertDeoptimizeToGuardPhase().apply(graph, null);
                assert (sideEffectCount == graph.getNodes().filter(e -> this.hasSideEffect(e)).count()) : "deleted side effecting node";
                new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required).apply(graph);
            }
        }

        private boolean hasSideEffect(Node node) {
            if (node instanceof StateSplit && ((StateSplit)((Object)node)).hasSideEffect()) {
                ResolvedJavaMethod targetMethod;
                CallTargetNode callTarget;
                if (node instanceof Invoke && (callTarget = ((Invoke)((Object)node)).callTarget()) instanceof MethodCallTargetNode && (targetMethod = ((MethodCallTargetNode)callTarget).targetMethod()).isConstructor()) {
                    ResolvedJavaType throwableType = this.replacements.providers.getMetaAccess().lookupJavaType(Throwable.class);
                    return !throwableType.isAssignableFrom(targetMethod.getDeclaringClass());
                }
                return true;
            }
            return false;
        }

        protected StructuredGraph buildInitialGraph(DebugContext debug, BytecodeProvider bytecodeProvider, ResolvedJavaMethod methodToParse, Object[] args, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, IntrinsicContext.CompilationContext context) {
            StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug).method(methodToParse).trackNodeSourcePosition(trackNodeSourcePosition).callerContext(replaceePosition).setIsSubstitution(true).build();
            graph.disableUnsafeAccessTracking();
            try (DebugContext.Scope s = debug.scope((Object)"buildInitialGraph", graph);){
                MetaAccessProvider metaAccess = this.replacements.providers.getMetaAccess();
                GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(this.replacements.graphBuilderPlugins);
                GraphBuilderConfiguration config = GraphBuilderConfiguration.getSnippetDefault(plugins);
                if (args != null) {
                    plugins.prependParameterPlugin(new ConstantBindingParameterPlugin(args, metaAccess, this.replacements.snippetReflection));
                }
                EncodedIntrinsicContext initialIntrinsicContext = null;
                Snippet snippetAnnotation = (Snippet)this.method.getAnnotation(Snippet.class);
                MethodSubstitution methodAnnotation = (MethodSubstitution)this.method.getAnnotation(MethodSubstitution.class);
                if (methodAnnotation == null && snippetAnnotation == null) {
                    initialIntrinsicContext = new EncodedIntrinsicContext(this.substitutedMethod, this.method, bytecodeProvider, context, false);
                } else {
                    ResolvedJavaMethod original = this.substitutedMethod != null ? this.substitutedMethod : this.method;
                    initialIntrinsicContext = new EncodedIntrinsicContext(original, this.method, bytecodeProvider, context, snippetAnnotation != null ? snippetAnnotation.allowPartialIntrinsicArgumentMismatch() : true);
                }
                this.createGraphBuilder(this.replacements.providers, config, OptimisticOptimizations.NONE, initialIntrinsicContext).apply(graph);
                CanonicalizerPhase.create().apply(graph, this.replacements.providers);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            return graph;
        }

        protected GraphBuilderPhase.Instance createGraphBuilder(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
            return new GraphBuilderPhase.Instance(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        }

        static class EncodedIntrinsicContext
        extends IntrinsicContext {
            EncodedIntrinsicContext(ResolvedJavaMethod method, ResolvedJavaMethod intrinsic, BytecodeProvider bytecodeProvider, IntrinsicContext.CompilationContext compilationContext, boolean allowPartialIntrinsicArgumentMismatch) {
                super(method, intrinsic, bytecodeProvider, compilationContext, allowPartialIntrinsicArgumentMismatch);
            }

            @Override
            public boolean isDeferredInvoke(StateSplit stateSplit) {
                if (stateSplit instanceof Invoke) {
                    Invoke invoke = (Invoke)stateSplit;
                    ResolvedJavaMethod method = invoke.callTarget().targetMethod();
                    if (method.getAnnotation(Fold.class) != null) {
                        return true;
                    }
                    Node.NodeIntrinsic annotation = (Node.NodeIntrinsic)method.getAnnotation(Node.NodeIntrinsic.class);
                    if (annotation != null && !annotation.hasSideEffect()) {
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

