/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import java.util.List;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConditionAnchorNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ShortCircuitOrNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.java.ClassIsAssignableFromNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;

public abstract class InstanceOfSnippetsTemplates
extends SnippetTemplate.AbstractTemplates {
    public InstanceOfSnippetsTemplates(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
        super(options, factories, providers, snippetReflection, target);
    }

    protected abstract SnippetTemplate.Arguments makeArguments(InstanceOfUsageReplacer var1, LoweringTool var2);

    public void lower(FloatingNode instanceOf, LoweringTool tool) {
        assert (instanceOf instanceof InstanceOfNode || instanceOf instanceof InstanceOfDynamicNode || instanceOf instanceof ClassIsAssignableFromNode);
        List<Node> usages = instanceOf.usages().snapshot();
        Instantiation instantiation = new Instantiation();
        for (Node usage : usages) {
            StructuredGraph graph = (StructuredGraph)usage.graph();
            InstanceOfUsageReplacer replacer = this.createReplacer(instanceOf, instantiation, usage, graph);
            if (instantiation.isInitialized()) {
                replacer.replaceUsingInstantiation();
                continue;
            }
            SnippetTemplate.Arguments args = this.makeArguments(replacer, tool);
            this.template(instanceOf, args).instantiate(this.providers.getMetaAccess(), instanceOf, (SnippetTemplate.UsageReplacer)replacer, tool, args);
        }
        assert (instanceOf.hasNoUsages());
        if (!instanceOf.isDeleted()) {
            GraphUtil.killWithUnusedFloatingInputs(instanceOf);
        }
    }

    protected InstanceOfUsageReplacer createReplacer(FloatingNode instanceOf, Instantiation instantiation, Node usage, StructuredGraph graph) {
        InstanceOfUsageReplacer replacer;
        if (!this.canMaterialize(usage)) {
            ValueNode trueValue = ConstantNode.forInt(1, graph);
            ValueNode falseValue = ConstantNode.forInt(0, graph);
            if (instantiation.isInitialized() && (trueValue != instantiation.trueValue || falseValue != instantiation.falseValue)) {
                trueValue = instantiation.trueValue;
                falseValue = instantiation.falseValue;
            }
            replacer = new NonMaterializationUsageReplacer(instantiation, trueValue, falseValue, instanceOf, usage);
        } else {
            assert (usage instanceof ConditionalNode) : "unexpected usage of " + instanceOf + ": " + usage;
            ConditionalNode c = (ConditionalNode)usage;
            replacer = new MaterializationUsageReplacer(instantiation, c.trueValue(), c.falseValue(), instanceOf, c);
        }
        return replacer;
    }

    protected boolean canMaterialize(Node usage) {
        if (usage instanceof ConditionalNode) {
            ConditionalNode cn = (ConditionalNode)usage;
            return cn.trueValue().isConstant() && cn.falseValue().isConstant();
        }
        return !(usage instanceof IfNode) && !(usage instanceof FixedGuardNode) && !(usage instanceof ShortCircuitOrNode) && !(usage instanceof ConditionAnchorNode);
    }

    public static class MaterializationUsageReplacer
    extends InstanceOfUsageReplacer {
        public final ConditionalNode usage;

        public MaterializationUsageReplacer(Instantiation instantiation, ValueNode trueValue, ValueNode falseValue, FloatingNode instanceOf, ConditionalNode usage) {
            super(instantiation, instanceOf, trueValue, falseValue);
            this.usage = usage;
        }

        @Override
        public void replaceUsingInstantiation() {
            ValueNode newValue = this.instantiation.asMaterialization(this.usage.graph(), this.trueValue, this.falseValue);
            this.usage.replaceAtUsages(newValue);
            assert (this.usage.hasNoUsages());
            GraphUtil.killWithUnusedFloatingInputs(this.usage);
        }

        @Override
        public void replace(ValueNode oldNode, ValueNode newNode) {
            assert (newNode instanceof PhiNode);
            assert (oldNode == this.instanceOf);
            newNode.inferStamp();
            this.instantiation.initialize(newNode, this.trueValue, this.falseValue);
            this.usage.replaceAtUsages(newNode);
            assert (this.usage.hasNoUsages());
            GraphUtil.killWithUnusedFloatingInputs(this.usage);
        }
    }

    public static class NonMaterializationUsageReplacer
    extends InstanceOfUsageReplacer {
        private final Node usage;

        public NonMaterializationUsageReplacer(Instantiation instantiation, ValueNode trueValue, ValueNode falseValue, FloatingNode instanceOf, Node usage) {
            super(instantiation, instanceOf, trueValue, falseValue);
            this.usage = usage;
        }

        @Override
        public void replaceUsingInstantiation() {
            this.usage.replaceFirstInput(this.instanceOf, this.instantiation.asCondition(this.trueValue));
        }

        @Override
        public void replace(ValueNode oldNode, ValueNode newNode) {
            assert (newNode instanceof PhiNode);
            assert (oldNode == this.instanceOf);
            newNode.inferStamp();
            this.instantiation.initialize(newNode, this.trueValue, this.falseValue);
            this.usage.replaceFirstInput(oldNode, this.instantiation.asCondition(this.trueValue));
        }
    }

    public static abstract class InstanceOfUsageReplacer
    implements SnippetTemplate.UsageReplacer {
        public final Instantiation instantiation;
        public final FloatingNode instanceOf;
        public final ValueNode trueValue;
        public final ValueNode falseValue;

        public InstanceOfUsageReplacer(Instantiation instantiation, FloatingNode instanceOf, ValueNode trueValue, ValueNode falseValue) {
            assert (instanceOf instanceof InstanceOfNode || instanceOf instanceof InstanceOfDynamicNode || instanceOf instanceof ClassIsAssignableFromNode);
            this.instantiation = instantiation;
            this.instanceOf = instanceOf;
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        public abstract void replaceUsingInstantiation();
    }

    public static final class Instantiation {
        private ValueNode result;
        private LogicNode condition;
        private ValueNode trueValue;
        private ValueNode falseValue;

        boolean isInitialized() {
            return this.result != null;
        }

        void initialize(ValueNode r, ValueNode t, ValueNode f) {
            assert (!this.isInitialized());
            this.result = r;
            this.trueValue = t;
            this.falseValue = f;
        }

        LogicNode asCondition(ValueNode testValue) {
            assert (this.isInitialized());
            if (this.result.isConstant()) {
                assert (testValue.isConstant());
                return LogicConstantNode.forBoolean(this.result.asConstant().equals(testValue.asConstant()), this.result.graph());
            }
            if (this.condition == null || !(this.condition instanceof CompareNode) || ((CompareNode)this.condition).getY() != testValue) {
                this.condition = CompareNode.createCompareNode(this.result.graph(), CanonicalCondition.EQ, this.result, testValue, null, NodeView.DEFAULT);
            }
            return this.condition;
        }

        ValueNode asMaterialization(StructuredGraph graph, ValueNode t, ValueNode f) {
            assert (this.isInitialized());
            if (t == this.trueValue && f == this.falseValue) {
                return this.result;
            }
            return graph.unique(new ConditionalNode(this.asCondition(this.trueValue), t, f));
        }
    }
}

