/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import org.graalvm.compiler.nodes.graphbuilderconf.ParameterPlugin;

public class ConstantBindingParameterPlugin
implements ParameterPlugin {
    private final Object[] constantArgs;
    private final MetaAccessProvider metaAccess;
    private final SnippetReflectionProvider snippetReflection;

    public ConstantBindingParameterPlugin(Object[] constantArgs, MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection) {
        this.constantArgs = constantArgs;
        this.metaAccess = metaAccess;
        this.snippetReflection = snippetReflection;
    }

    @Override
    public FloatingNode interceptParameter(GraphBuilderTool b, int index, StampPair stamp) {
        Object arg;
        if (index < this.constantArgs.length && (arg = this.constantArgs[index]) != null) {
            ConstantNode otherCon;
            ConstantNode constantNode = arg instanceof ConstantNode ? ((otherCon = (ConstantNode)arg).graph() != b.getGraph() ? ConstantNode.forConstant(stamp.getTrustedStamp(), otherCon.getValue(), otherCon.getStableDimension(), otherCon.isDefaultStable(), this.metaAccess) : otherCon) : (arg instanceof Constant ? ConstantNode.forConstant(stamp.getTrustedStamp(), (Constant)arg, this.metaAccess) : ConstantNode.forConstant(this.snippetReflection.forBoxed(stamp.getTrustedStamp().getStackKind(), arg), this.metaAccess));
            return constantNode;
        }
        return null;
    }
}

